/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.AccessControlPolicy;
import com.adobe.testing.s3mock.dto.CanonicalUser;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.ChecksumType;
import com.adobe.testing.s3mock.dto.Grant;
import com.adobe.testing.s3mock.dto.LegalHold;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Retention;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.store.S3ObjectVersions;
import com.adobe.testing.s3mock.store.StoreBase;
import com.adobe.testing.s3mock.util.DigestUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStore
extends StoreBase {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStore.class);
    private static final String META_FILE = "objectMetadata.json";
    private static final String DATA_FILE = "binaryData";
    private static final String VERSIONED_META_FILE = "%s-objectMetadata.json";
    private static final String VERSIONED_DATA_FILE = "%s-binaryData";
    private static final String VERSIONS_FILE = "versions.json";
    private static final String NULL_VERSION = "null";
    private final Map<UUID, Object> lockStore = new ConcurrentHashMap<UUID, Object>();
    private final DateTimeFormatter s3ObjectDateFormat;
    private final ObjectMapper objectMapper;

    public ObjectStore(DateTimeFormatter s3ObjectDateFormat, ObjectMapper objectMapper) {
        this.s3ObjectDateFormat = s3ObjectDateFormat;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3ObjectMetadata storeS3ObjectMetadata(BucketMetadata bucket, UUID id, String key, @Nullable String contentType, @Nullable Map<String, String> storeHeaders, Path path, @Nullable Map<String, String> userMetadata, @Nullable Map<String, String> encryptionHeaders, @Nullable String etag, @Nullable List<Tag> tags, @Nullable ChecksumAlgorithm checksumAlgorithm, @Nullable String checksum, Owner owner, @Nullable StorageClass storageClass, @Nullable ChecksumType checksumType) {
        this.lockStore.putIfAbsent(id, new Object());
        Object object = this.lockStore.get(id);
        synchronized (object) {
            this.createObjectRootFolder(bucket, id);
            String versionId = null;
            if (bucket.isVersioningEnabled()) {
                S3ObjectVersions existingVersions = this.getS3ObjectVersions(bucket, id);
                if (existingVersions != null) {
                    versionId = existingVersions.createVersion();
                    this.writeVersionsFile(bucket, id, existingVersions);
                } else {
                    S3ObjectVersions newVersions = this.createS3ObjectVersions(bucket, id);
                    versionId = newVersions.createVersion();
                    this.writeVersionsFile(bucket, id, newVersions);
                }
            }
            File dataFile = this.inputPathToFile(path, this.getDataFilePath(bucket, id, versionId));
            Instant now = Instant.now();
            S3ObjectMetadata s3ObjectMetadata = new S3ObjectMetadata(id, key, Long.toString(dataFile.length()), this.s3ObjectDateFormat.format(now), etag != null ? etag : DigestUtil.hexDigest(encryptionHeaders.get("x-amz-server-side-encryption-aws-kms-key-id"), dataFile), contentType, now.toEpochMilli(), dataFile.toPath(), userMetadata, tags, null, null, owner, storeHeaders, encryptionHeaders, checksumAlgorithm, checksum, storageClass, null, versionId, false, checksumType);
            this.writeMetafile(bucket, s3ObjectMetadata);
            return s3ObjectMetadata;
        }
    }

    private AccessControlPolicy privateCannedAcl(Owner owner) {
        Grant grant = new Grant(new CanonicalUser(owner.displayName(), owner.id()), Grant.Permission.FULL_CONTROL);
        return new AccessControlPolicy(owner, Collections.singletonList(grant));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeObjectTags(BucketMetadata bucket, UUID id, @Nullable String versionId, @Nullable List<Tag> tags) {
        Object object = this.lockStore.get(id);
        synchronized (object) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id, versionId);
            this.writeMetafile(bucket, new S3ObjectMetadata(s3ObjectMetadata.id(), s3ObjectMetadata.key(), s3ObjectMetadata.size(), s3ObjectMetadata.modificationDate(), s3ObjectMetadata.etag(), s3ObjectMetadata.contentType(), s3ObjectMetadata.lastModified(), s3ObjectMetadata.dataPath(), s3ObjectMetadata.userMetadata(), tags, s3ObjectMetadata.legalHold(), s3ObjectMetadata.retention(), s3ObjectMetadata.owner(), s3ObjectMetadata.storeHeaders(), s3ObjectMetadata.encryptionHeaders(), s3ObjectMetadata.checksumAlgorithm(), s3ObjectMetadata.checksum(), s3ObjectMetadata.storageClass(), s3ObjectMetadata.policy(), s3ObjectMetadata.versionId(), s3ObjectMetadata.deleteMarker(), s3ObjectMetadata.checksumType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLegalHold(BucketMetadata bucket, UUID id, @Nullable String versionId, LegalHold legalHold) {
        Object object = this.lockStore.get(id);
        synchronized (object) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id, versionId);
            this.writeMetafile(bucket, new S3ObjectMetadata(s3ObjectMetadata.id(), s3ObjectMetadata.key(), s3ObjectMetadata.size(), s3ObjectMetadata.modificationDate(), s3ObjectMetadata.etag(), s3ObjectMetadata.contentType(), s3ObjectMetadata.lastModified(), s3ObjectMetadata.dataPath(), s3ObjectMetadata.userMetadata(), s3ObjectMetadata.tags(), legalHold, s3ObjectMetadata.retention(), s3ObjectMetadata.owner(), s3ObjectMetadata.storeHeaders(), s3ObjectMetadata.encryptionHeaders(), s3ObjectMetadata.checksumAlgorithm(), s3ObjectMetadata.checksum(), s3ObjectMetadata.storageClass(), s3ObjectMetadata.policy(), s3ObjectMetadata.versionId(), s3ObjectMetadata.deleteMarker(), s3ObjectMetadata.checksumType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAcl(BucketMetadata bucket, UUID id, @Nullable String versionId, AccessControlPolicy policy) {
        Object object = this.lockStore.get(id);
        synchronized (object) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id, versionId);
            this.writeMetafile(bucket, new S3ObjectMetadata(s3ObjectMetadata.id(), s3ObjectMetadata.key(), s3ObjectMetadata.size(), s3ObjectMetadata.modificationDate(), s3ObjectMetadata.etag(), s3ObjectMetadata.contentType(), s3ObjectMetadata.lastModified(), s3ObjectMetadata.dataPath(), s3ObjectMetadata.userMetadata(), s3ObjectMetadata.tags(), s3ObjectMetadata.legalHold(), s3ObjectMetadata.retention(), s3ObjectMetadata.owner(), s3ObjectMetadata.storeHeaders(), s3ObjectMetadata.encryptionHeaders(), s3ObjectMetadata.checksumAlgorithm(), s3ObjectMetadata.checksum(), s3ObjectMetadata.storageClass(), policy, s3ObjectMetadata.versionId(), s3ObjectMetadata.deleteMarker(), s3ObjectMetadata.checksumType()));
        }
    }

    public AccessControlPolicy readAcl(BucketMetadata bucket, UUID id, @Nullable String versionId) {
        S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id, versionId);
        return s3ObjectMetadata.policy() == null ? this.privateCannedAcl(s3ObjectMetadata.owner()) : s3ObjectMetadata.policy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRetention(BucketMetadata bucket, UUID id, @Nullable String versionId, Retention retention) {
        Object object = this.lockStore.get(id);
        synchronized (object) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id, versionId);
            this.writeMetafile(bucket, new S3ObjectMetadata(s3ObjectMetadata.id(), s3ObjectMetadata.key(), s3ObjectMetadata.size(), s3ObjectMetadata.modificationDate(), s3ObjectMetadata.etag(), s3ObjectMetadata.contentType(), s3ObjectMetadata.lastModified(), s3ObjectMetadata.dataPath(), s3ObjectMetadata.userMetadata(), s3ObjectMetadata.tags(), s3ObjectMetadata.legalHold(), retention, s3ObjectMetadata.owner(), s3ObjectMetadata.storeHeaders(), s3ObjectMetadata.encryptionHeaders(), s3ObjectMetadata.checksumAlgorithm(), s3ObjectMetadata.checksum(), s3ObjectMetadata.storageClass(), s3ObjectMetadata.policy(), s3ObjectMetadata.versionId(), s3ObjectMetadata.deleteMarker(), s3ObjectMetadata.checksumType()));
        }
    }

    public @Nullable S3ObjectMetadata getS3ObjectMetadata(BucketMetadata bucket, UUID id, @Nullable String versionId) {
        Path metaPath;
        S3ObjectVersions s3ObjectVersions;
        if (bucket.isVersioningEnabled() && versionId == null && (s3ObjectVersions = this.getS3ObjectVersions(bucket, id)) != null) {
            versionId = s3ObjectVersions.getLatestVersion();
        }
        if (Files.exists(metaPath = this.getMetaFilePath(bucket, id, versionId), new LinkOption[0])) {
            Object object = this.lockStore.get(id);
            synchronized (object) {
                try {
                    return (S3ObjectMetadata)this.objectMapper.readValue(metaPath.toFile(), S3ObjectMetadata.class);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read object metadata-file " + String.valueOf(id), e);
                }
            }
        }
        return null;
    }

    public @Nullable S3ObjectVersions getS3ObjectVersions(BucketMetadata bucket, UUID id) {
        Path metaPath = this.getVersionFilePath(bucket, id);
        if (Files.exists(metaPath, new LinkOption[0])) {
            Object object = this.lockStore.get(id);
            synchronized (object) {
                try {
                    return (S3ObjectVersions)this.objectMapper.readValue(metaPath.toFile(), S3ObjectVersions.class);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read object versions-file " + String.valueOf(id), e);
                }
            }
        }
        return null;
    }

    public @Nullable S3ObjectVersions createS3ObjectVersions(BucketMetadata bucket, UUID id) {
        Path metaPath = this.getVersionFilePath(bucket, id);
        if (Files.exists(metaPath, new LinkOption[0])) {
            return this.getS3ObjectVersions(bucket, id);
        }
        Object object = this.lockStore.get(id);
        synchronized (object) {
            try {
                this.writeVersionsFile(bucket, id, new S3ObjectVersions(id));
                return (S3ObjectVersions)this.objectMapper.readValue(metaPath.toFile(), S3ObjectVersions.class);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read object versions-file " + String.valueOf(id), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable S3ObjectMetadata copyS3Object(BucketMetadata sourceBucket, UUID sourceId, @Nullable String versionId, BucketMetadata destinationBucket, UUID destinationId, String destinationKey, @Nullable Map<String, String> encryptionHeaders, @Nullable Map<String, String> storeHeaders, @Nullable Map<String, String> userMetadata, @Nullable StorageClass storageClass) {
        S3ObjectMetadata sourceObject = this.getS3ObjectMetadata(sourceBucket, sourceId, versionId);
        if (sourceObject == null) {
            return null;
        }
        Object object = this.lockStore.get(sourceId);
        synchronized (object) {
            return this.storeS3ObjectMetadata(destinationBucket, destinationId, destinationKey, sourceObject.contentType(), storeHeaders == null || storeHeaders.isEmpty() ? sourceObject.storeHeaders() : storeHeaders, sourceObject.dataPath(), userMetadata == null || userMetadata.isEmpty() ? sourceObject.userMetadata() : userMetadata, encryptionHeaders == null || encryptionHeaders.isEmpty() ? sourceObject.encryptionHeaders() : encryptionHeaders, null, sourceObject.tags(), sourceObject.checksumAlgorithm(), sourceObject.checksum(), sourceObject.owner(), storageClass != null ? storageClass : sourceObject.storageClass(), sourceObject.checksumType());
        }
    }

    public @Nullable S3ObjectMetadata pretendToCopyS3Object(BucketMetadata sourceBucket, UUID sourceId, @Nullable String versionId, @Nullable Map<String, String> encryptionHeaders, @Nullable Map<String, String> storeHeaders, @Nullable Map<String, String> userMetadata, @Nullable StorageClass storageClass) {
        S3ObjectMetadata sourceObject = this.getS3ObjectMetadata(sourceBucket, sourceId, versionId);
        if (sourceObject == null) {
            return null;
        }
        this.verifyPretendCopy(sourceObject, userMetadata, encryptionHeaders, storeHeaders, storageClass);
        S3ObjectMetadata s3ObjectMetadata = new S3ObjectMetadata(sourceObject.id(), sourceObject.key(), sourceObject.size(), sourceObject.modificationDate(), sourceObject.etag(), sourceObject.contentType(), Instant.now().toEpochMilli(), sourceObject.dataPath(), userMetadata == null || userMetadata.isEmpty() ? sourceObject.userMetadata() : userMetadata, sourceObject.tags(), sourceObject.legalHold(), sourceObject.retention(), sourceObject.owner(), storeHeaders == null || storeHeaders.isEmpty() ? sourceObject.storeHeaders() : storeHeaders, encryptionHeaders == null || encryptionHeaders.isEmpty() ? sourceObject.encryptionHeaders() : encryptionHeaders, sourceObject.checksumAlgorithm(), sourceObject.checksum(), storageClass != null ? storageClass : sourceObject.storageClass(), sourceObject.policy(), sourceObject.versionId(), sourceObject.deleteMarker(), sourceObject.checksumType());
        this.writeMetafile(sourceBucket, s3ObjectMetadata);
        return s3ObjectMetadata;
    }

    private void verifyPretendCopy(S3ObjectMetadata sourceObject, @Nullable Map<String, String> userMetadata, @Nullable Map<String, String> encryptionHeaders, @Nullable Map<String, String> storeHeaders, @Nullable StorageClass storageClass) {
        boolean storageClassUnChanged;
        boolean userDataUnChanged = userMetadata == null || userMetadata.isEmpty();
        boolean encryptionHeadersUnChanged = encryptionHeaders == null || encryptionHeaders.isEmpty();
        boolean storeHeadersUnChanged = storeHeaders == null || storeHeaders.isEmpty();
        boolean bl = storageClassUnChanged = storageClass == null || storageClass == sourceObject.storageClass();
        if (userDataUnChanged && storageClassUnChanged && encryptionHeadersUnChanged && storeHeadersUnChanged) {
            throw S3Exception.INVALID_COPY_REQUEST_SAME_KEY;
        }
    }

    public boolean deleteObject(BucketMetadata bucket, UUID id, @Nullable String versionId) {
        S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, id, versionId);
        if (s3ObjectMetadata != null) {
            if (bucket.isVersioningEnabled() && !NULL_VERSION.equals(versionId)) {
                if (versionId != null) {
                    return this.doDeleteVersion(bucket, id, versionId);
                }
                return this.insertDeleteMarker(bucket, id, s3ObjectMetadata);
            }
            return this.doDeleteObject(bucket, id);
        }
        return false;
    }

    private boolean doDeleteVersion(BucketMetadata bucket, UUID id, String versionId) {
        Object object = this.lockStore.get(id);
        synchronized (object) {
            try {
                S3ObjectVersions existingVersions = this.getS3ObjectVersions(bucket, id);
                if (existingVersions == null) {
                    return false;
                }
                if (existingVersions.versions().size() <= 1) {
                    return this.doDeleteObject(bucket, id);
                }
                existingVersions.deleteVersion(versionId);
                this.writeVersionsFile(bucket, id, existingVersions);
                return false;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not delete object-version " + String.valueOf(id), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doDeleteObject(BucketMetadata bucket, UUID id) {
        Object object = this.lockStore.get(id);
        synchronized (object) {
            try {
                FileUtils.deleteDirectory((File)this.getObjectFolderPath(bucket, id).toFile());
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not delete object-directory " + String.valueOf(id), e);
            }
            this.lockStore.remove(id);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertDeleteMarker(BucketMetadata bucket, UUID id, S3ObjectMetadata s3ObjectMetadata) {
        String versionId = null;
        Object object = this.lockStore.get(id);
        synchronized (object) {
            try {
                S3ObjectVersions existingVersions = this.getS3ObjectVersions(bucket, id);
                if (existingVersions != null) {
                    versionId = existingVersions.createVersion();
                    this.writeVersionsFile(bucket, id, existingVersions);
                }
                this.writeMetafile(bucket, S3ObjectMetadata.deleteMarker(s3ObjectMetadata, versionId));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not insert object-deletemarker " + String.valueOf(id), e);
            }
            return false;
        }
    }

    void loadObjects(BucketMetadata bucketMetadata, Collection<UUID> ids) {
        int loaded = 0;
        for (UUID id : ids) {
            this.lockStore.putIfAbsent(id, new Object());
            S3ObjectVersions s3ObjectVersions = this.getS3ObjectVersions(bucketMetadata, id);
            if (s3ObjectVersions != null) {
                if (!this.loadVersions(bucketMetadata, s3ObjectVersions)) continue;
                ++loaded;
                continue;
            }
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucketMetadata, id, null);
            if (s3ObjectMetadata == null) continue;
            ++loaded;
        }
        LOG.info("Loaded {}/{} objects for bucket {}", new Object[]{loaded, ids.size(), bucketMetadata.name()});
    }

    private boolean loadVersions(BucketMetadata bucket, S3ObjectVersions versions) {
        boolean loaded = false;
        S3ObjectVersions s3ObjectVersions = this.getS3ObjectVersions(bucket, versions.id());
        for (String version : s3ObjectVersions.versions()) {
            S3ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(bucket, versions.id(), version);
            if (s3ObjectMetadata == null) continue;
            loaded = true;
        }
        return loaded;
    }

    private void createObjectRootFolder(BucketMetadata bucket, UUID id) {
        File objectRootFolder = this.getObjectFolderPath(bucket, id).toFile();
        objectRootFolder.mkdirs();
    }

    private Path getObjectFolderPath(BucketMetadata bucket, UUID id) {
        return Paths.get(bucket.path().toString(), id.toString());
    }

    private Path getMetaFilePath(BucketMetadata bucket, UUID id, @Nullable String versionId) {
        if (versionId != null && !NULL_VERSION.equals(versionId)) {
            return this.getObjectFolderPath(bucket, id).resolve(String.format(VERSIONED_META_FILE, versionId));
        }
        return this.getObjectFolderPath(bucket, id).resolve(META_FILE);
    }

    private Path getDataFilePath(BucketMetadata bucket, UUID id, @Nullable String versionId) {
        if (versionId != null) {
            return this.getObjectFolderPath(bucket, id).resolve(String.format(VERSIONED_DATA_FILE, versionId));
        }
        return this.getObjectFolderPath(bucket, id).resolve(DATA_FILE);
    }

    private Path getVersionFilePath(BucketMetadata bucket, UUID id) {
        return this.getObjectFolderPath(bucket, id).resolve(VERSIONS_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVersionsFile(BucketMetadata bucket, UUID id, S3ObjectVersions s3ObjectVersions) {
        try {
            Object object = this.lockStore.get(id);
            synchronized (object) {
                File versionsFile = this.getVersionFilePath(bucket, id).toFile();
                this.objectMapper.writeValue(versionsFile, (Object)s3ObjectVersions);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write object versions-file " + String.valueOf(id), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetafile(BucketMetadata bucket, S3ObjectMetadata s3ObjectMetadata) {
        UUID id = s3ObjectMetadata.id();
        try {
            Object object = this.lockStore.get(id);
            synchronized (object) {
                File metaFile = this.getMetaFilePath(bucket, id, s3ObjectMetadata.versionId()).toFile();
                this.objectMapper.writeValue(metaFile, (Object)s3ObjectMetadata);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write object metadata-file " + String.valueOf(id), e);
        }
    }
}

