/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.dto.BucketInfo;
import com.adobe.testing.s3mock.dto.BucketLifecycleConfiguration;
import com.adobe.testing.s3mock.dto.LocationInfo;
import com.adobe.testing.s3mock.dto.ObjectLockConfiguration;
import com.adobe.testing.s3mock.dto.ObjectLockEnabled;
import com.adobe.testing.s3mock.dto.ObjectOwnership;
import com.adobe.testing.s3mock.dto.VersioningConfiguration;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketStore {
    private static final Logger LOG = LoggerFactory.getLogger(BucketStore.class);
    static final String BUCKET_META_FILE = "bucketMetadata.json";
    private final Map<String, Object> lockStore = new ConcurrentHashMap<String, Object>();
    private final File rootFolder;
    private final DateTimeFormatter s3ObjectDateFormat;
    private final String region;
    private final ObjectMapper objectMapper;

    public BucketStore(File rootFolder, DateTimeFormatter s3ObjectDateFormat, String region, ObjectMapper objectMapper) {
        this.rootFolder = rootFolder;
        this.s3ObjectDateFormat = s3ObjectDateFormat;
        this.region = region;
        this.objectMapper = objectMapper;
    }

    public List<BucketMetadata> listBuckets() {
        return this.findBucketPaths().stream().map(path -> path.getFileName().toString()).map(this::getBucketMetadata).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketMetadata getBucketMetadata(String bucketName) {
        try {
            if (!this.doesBucketExist(bucketName)) {
                throw new IllegalStateException("Bucket does not exist: " + bucketName);
            }
            Path metaFilePath = this.getMetaFilePath(bucketName);
            Object object = this.lockStore.get(bucketName);
            synchronized (object) {
                return (BucketMetadata)this.objectMapper.readValue(metaFilePath.toFile(), BucketMetadata.class);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read bucket metadata-file " + bucketName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UUID addKeyToBucket(String key, String bucketName) {
        Object object = this.lockStore.get(bucketName);
        synchronized (object) {
            BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
            UUID uuid = bucketMetadata.addKey(key);
            this.writeToDisk(bucketMetadata);
            return uuid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UUID> lookupKeysInBucket(@Nullable String prefix, String bucketName) {
        BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
        String normalizedPrefix = prefix == null ? "" : prefix;
        Object object = this.lockStore.get(bucketName);
        synchronized (object) {
            return bucketMetadata.objects().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(normalizedPrefix)).map(Map.Entry::getValue).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeFromBucket(String key, String bucketName) {
        Object object = this.lockStore.get(bucketName);
        synchronized (object) {
            BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
            boolean removed = bucketMetadata.removeKey(key);
            this.writeToDisk(bucketMetadata);
            return removed;
        }
    }

    private List<Path> findBucketPaths() {
        ArrayList<Path> bucketPaths = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.rootFolder.toPath(), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path path : stream) {
                bucketPaths.add(path);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not Iterate over Bucket-Folders.", e);
        }
        return bucketPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketMetadata createBucket(String bucketName, boolean objectLockEnabled, ObjectOwnership objectOwnership, @Nullable String bucketRegion, @Nullable BucketInfo bucketInfo, @Nullable LocationInfo locationInfo) {
        if (this.doesBucketExist(bucketName)) {
            throw new IllegalStateException("Bucket already exists.");
        }
        this.lockStore.putIfAbsent(bucketName, new Object());
        Object object = this.lockStore.get(bucketName);
        synchronized (object) {
            File bucketFolder = this.createBucketFolder(bucketName);
            String region = bucketRegion == null ? this.region : bucketRegion;
            BucketMetadata newBucketMetadata = new BucketMetadata(bucketName, this.s3ObjectDateFormat.format(LocalDateTime.now()), new VersioningConfiguration(null, null, null), objectLockEnabled ? new ObjectLockConfiguration(ObjectLockEnabled.ENABLED, null) : null, null, objectOwnership, bucketFolder.toPath(), region, bucketInfo, locationInfo);
            this.writeToDisk(newBucketMetadata);
            return newBucketMetadata;
        }
    }

    public boolean doesBucketExist(String bucketName) {
        Path metaFilePath = this.getMetaFilePath(bucketName);
        return metaFilePath.toFile().exists();
    }

    public boolean isObjectLockEnabled(String bucketName) {
        ObjectLockConfiguration objectLockConfiguration = this.getBucketMetadata(bucketName).objectLockConfiguration();
        if (objectLockConfiguration != null) {
            return ObjectLockEnabled.ENABLED == objectLockConfiguration.objectLockEnabled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeObjectLockConfiguration(BucketMetadata metadata, ObjectLockConfiguration configuration) {
        Object object = this.lockStore.get(metadata.name());
        synchronized (object) {
            this.writeToDisk(metadata.withObjectLockConfiguration(configuration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeVersioningConfiguration(BucketMetadata metadata, VersioningConfiguration configuration) {
        Object object = this.lockStore.get(metadata.name());
        synchronized (object) {
            this.writeToDisk(metadata.withVersioningConfiguration(configuration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeBucketLifecycleConfiguration(BucketMetadata metadata, @Nullable BucketLifecycleConfiguration configuration) {
        Object object = this.lockStore.get(metadata.name());
        synchronized (object) {
            this.writeToDisk(metadata.withBucketLifecycleConfiguration(configuration));
        }
    }

    public boolean isBucketEmpty(String bucketName) {
        if (!this.doesBucketExist(bucketName)) {
            throw new IllegalStateException("Requested Bucket does not exist: " + bucketName);
        }
        return this.getBucketMetadata(bucketName).objects().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteBucket(String bucketName) {
        try {
            Object object = this.lockStore.get(bucketName);
            synchronized (object) {
                if (this.isBucketEmpty(bucketName)) {
                    BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
                    FileUtils.deleteDirectory((File)bucketMetadata.path().toFile());
                    this.lockStore.remove(bucketName);
                    return true;
                }
                return false;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't delete bucket directory!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UUID> loadBuckets(List<String> bucketNames) {
        ArrayList<UUID> objectIds = new ArrayList<UUID>();
        for (String bucketName : bucketNames) {
            LOG.info("Loading existing bucket {}.", (Object)bucketName);
            this.lockStore.putIfAbsent(bucketName, new Object());
            Object object = this.lockStore.get(bucketName);
            synchronized (object) {
                BucketMetadata bucketMetadata = this.getBucketMetadata(bucketName);
                Map<String, UUID> objects = bucketMetadata.objects();
                for (Map.Entry<String, UUID> objectEntry : objects.entrySet()) {
                    objectIds.add(objectEntry.getValue());
                    LOG.info("Loading existing bucket {} key {}", (Object)bucketName, (Object)objectEntry.getKey());
                }
            }
        }
        return objectIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDisk(BucketMetadata bucketMetadata) {
        try {
            File metaFile = this.getMetaFilePath(bucketMetadata.name()).toFile();
            Object object = this.lockStore.get(bucketMetadata.name());
            synchronized (object) {
                this.objectMapper.writeValue(metaFile, (Object)bucketMetadata);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write bucket metadata-file", e);
        }
    }

    private Path getBucketFolderPath(String bucketName) {
        return Paths.get(this.rootFolder.getPath(), bucketName);
    }

    private File createBucketFolder(String bucketName) {
        try {
            File bucketFolder = this.getBucketFolderPath(bucketName).toFile();
            FileUtils.forceMkdir((File)bucketFolder);
            return bucketFolder;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create bucket directory!", e);
        }
    }

    private Path getMetaFilePath(String bucketName) {
        return Paths.get(this.getBucketFolderPath(bucketName).toString(), BUCKET_META_FILE);
    }
}

