/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.service;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.util.AbstractAwsInputStream;
import com.adobe.testing.s3mock.util.AwsChunkedDecodingChecksumInputStream;
import com.adobe.testing.s3mock.util.AwsUnsignedChunkedDecodingChecksumInputStream;
import com.adobe.testing.s3mock.util.DigestUtil;
import com.adobe.testing.s3mock.util.HeaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

abstract class ServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceBase.class);

    ServiceBase() {
    }

    public void verifyChecksum(Path path, String checksum, ChecksumAlgorithm checksumAlgorithm) {
        String checksumFor = DigestUtil.checksumFor(path, checksumAlgorithm.toChecksumAlgorithm());
        DigestUtil.verifyChecksum(checksum, checksumFor, checksumAlgorithm);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Pair<Path, @Nullable String> toTempFile(InputStream inputStream, HttpHeaders httpHeaders) {
        try {
            Path tempFile = Files.createTempFile("ObjectService", "toTempFile", new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
                Pair pair;
                block18: {
                    InputStream wrappedStream;
                    block16: {
                        Pair pair2;
                        block17: {
                            wrappedStream = this.wrapStream(inputStream, httpHeaders);
                            try {
                                wrappedStream.transferTo(os);
                                ChecksumAlgorithm algorithmFromSdk = HeaderUtil.checksumAlgorithmFromSdk(httpHeaders);
                                if (algorithmFromSdk == null || !(wrappedStream instanceof AbstractAwsInputStream)) break block16;
                                AbstractAwsInputStream awsInputStream = (AbstractAwsInputStream)wrappedStream;
                                pair2 = Pair.of((Object)tempFile, (Object)awsInputStream.getChecksum());
                                if (wrappedStream == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (wrappedStream != null) {
                                    try {
                                        wrappedStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            wrappedStream.close();
                        }
                        return pair2;
                    }
                    pair = Pair.of((Object)tempFile, null);
                    if (wrappedStream == null) break block18;
                    wrappedStream.close();
                }
                return pair;
            }
        }
        catch (IOException e) {
            LOG.error("Error reading from InputStream", (Throwable)e);
            throw S3Exception.BAD_REQUEST_CONTENT;
        }
    }

    public Pair<Path, @Nullable String> toTempFile(InputStream inputStream) {
        Pair pair;
        block8: {
            Path tempFile = Files.createTempFile("ObjectService", "toTempFile", new FileAttribute[0]);
            OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);
            try {
                inputStream.transferTo(os);
                pair = Pair.of((Object)tempFile, null);
                if (os == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Error reading from InputStream", (Throwable)e);
                    throw S3Exception.BAD_REQUEST_CONTENT;
                }
            }
            os.close();
        }
        return pair;
    }

    static <T> List<T> mapContents(List<T> contents, UnaryOperator<T> extractor) {
        return contents.stream().map(extractor).toList();
    }

    static <T> List<T> filterBy(List<T> contents, Function<T, String> function, @Nullable String compareTo) {
        if (StringUtils.isNotEmpty((CharSequence)compareTo)) {
            return contents.stream().filter(content -> ((String)function.apply(content)).compareTo(compareTo) > 0).toList();
        }
        return contents;
    }

    static <T> List<T> filterBy(List<T> contents, Function<T, Integer> function, @Nullable Integer compareTo) {
        if (compareTo != null) {
            return contents.stream().filter(content -> ((Integer)function.apply(content)).compareTo(compareTo) > 0).toList();
        }
        return contents;
    }

    static <T> List<T> filterBy(List<T> contents, Function<T, String> function, @Nullable List<String> prefixes) {
        if (prefixes != null && !prefixes.isEmpty()) {
            return contents.stream().filter(content -> prefixes.stream().noneMatch(prefix -> ((String)function.apply(content)).startsWith((String)prefix))).toList();
        }
        return contents;
    }

    static <T> List<String> collapseCommonPrefixes(@Nullable String queryPrefix, @Nullable String delimiter, List<T> contents, Function<T, String> function) {
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)delimiter)) {
            return commonPrefixes;
        }
        String normalizedQueryPrefix = queryPrefix == null ? "" : queryPrefix;
        for (T c : contents) {
            String commonPrefix;
            int delimiterIndex;
            String key = function.apply(c);
            if (!key.startsWith(normalizedQueryPrefix) || (delimiterIndex = key.indexOf(delimiter, normalizedQueryPrefix.length())) <= 0 || commonPrefixes.contains(commonPrefix = key.substring(0, delimiterIndex + delimiter.length()))) continue;
            commonPrefixes.add(commonPrefix);
        }
        return commonPrefixes;
    }

    private InputStream wrapStream(InputStream dataStream, HttpHeaders headers) {
        long length;
        String lengthHeader = headers.getFirst("x-amz-decoded-content-length");
        long l = length = lengthHeader == null ? -1L : Long.parseLong(lengthHeader);
        if (HeaderUtil.isV4Signed(headers)) {
            return new AwsChunkedDecodingChecksumInputStream(dataStream, length);
        }
        if (HeaderUtil.isChunkedEncoding(headers)) {
            return new AwsUnsignedChunkedDecodingChecksumInputStream(dataStream, length);
        }
        return dataStream;
    }
}

