/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.service;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.AccessControlPolicy;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.ChecksumType;
import com.adobe.testing.s3mock.dto.Delete;
import com.adobe.testing.s3mock.dto.DeleteResult;
import com.adobe.testing.s3mock.dto.DeletedS3Object;
import com.adobe.testing.s3mock.dto.Error;
import com.adobe.testing.s3mock.dto.LegalHold;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Retention;
import com.adobe.testing.s3mock.dto.S3ObjectIdentifier;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.service.ServiceBase;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.DigestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectService
extends ServiceBase {
    static final String WILDCARD_ETAG = "\"*\"";
    static final String WILDCARD = "*";
    private static final Logger LOG = LoggerFactory.getLogger(ObjectService.class);
    private static final Pattern TAG_ALLOWED_CHARS = Pattern.compile("[\\w+ \\-=.:/@]*");
    private static final int MAX_ALLOWED_TAGS = 50;
    private static final int MIN_ALLOWED_TAG_KEY_LENGTH = 1;
    private static final int MAX_ALLOWED_TAG_KEY_LENGTH = 128;
    private static final int MIN_ALLOWED_TAG_VALUE_LENGTH = 0;
    private static final int MAX_ALLOWED_TAG_VALUE_LENGTH = 256;
    private static final String DISALLOWED_TAG_KEY_PREFIX = "aws:";
    private final BucketStore bucketStore;
    private final ObjectStore objectStore;

    public ObjectService(BucketStore bucketStore, ObjectStore objectStore) {
        this.bucketStore = bucketStore;
        this.objectStore = objectStore;
    }

    public @Nullable S3ObjectMetadata copyS3Object(String sourceBucketName, String sourceKey, @Nullable String versionId, String destinationBucketName, String destinationKey, Map<String, String> encryptionHeaders, Map<String, String> storeHeaders, Map<String, String> userMetadata, @Nullable StorageClass storageClass) {
        BucketMetadata sourceBucketMetadata = this.bucketStore.getBucketMetadata(sourceBucketName);
        BucketMetadata destinationBucketMetadata = this.bucketStore.getBucketMetadata(destinationBucketName);
        UUID sourceId = sourceBucketMetadata.getID(sourceKey);
        if (sourceId == null) {
            return null;
        }
        if (sourceKey.equals(destinationKey) && sourceBucketName.equals(destinationBucketName)) {
            return this.objectStore.pretendToCopyS3Object(sourceBucketMetadata, sourceId, versionId, encryptionHeaders, storeHeaders, userMetadata, storageClass);
        }
        UUID destinationId = this.bucketStore.addKeyToBucket(destinationKey, destinationBucketName);
        try {
            return this.objectStore.copyS3Object(sourceBucketMetadata, sourceId, versionId, destinationBucketMetadata, destinationId, destinationKey, encryptionHeaders, storeHeaders, userMetadata, storageClass);
        }
        catch (Exception e) {
            this.bucketStore.removeFromBucket(destinationKey, destinationBucketName);
            throw e;
        }
    }

    public S3ObjectMetadata putS3Object(String bucketName, String key, String contentType, Map<String, String> storeHeaders, Path path, Map<String, String> userMetadata, Map<String, String> encryptionHeaders, @Nullable List<Tag> tags, @Nullable ChecksumAlgorithm checksumAlgorithm, @Nullable String checksum, Owner owner, @Nullable StorageClass storageClass) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            id = this.bucketStore.addKeyToBucket(key, bucketName);
        }
        return this.objectStore.storeS3ObjectMetadata(bucketMetadata, id, key, contentType, storeHeaders, path, userMetadata, encryptionHeaders, null, tags, checksumAlgorithm, checksum, owner, storageClass, ChecksumType.FULL_OBJECT);
    }

    public DeleteResult deleteObjects(String bucketName, Delete delete) {
        DeleteResult response = new DeleteResult(new ArrayList<Error>(), new ArrayList<DeletedS3Object>());
        for (S3ObjectIdentifier object : delete.objectsToDelete()) {
            try {
                this.deleteObject(bucketName, object.key(), object.versionId());
                response.addDeletedObject(DeletedS3Object.from(object));
            }
            catch (IllegalStateException e) {
                response.addError(new Error("InternalError", object.key(), "We encountered an internal error. Please try again.", object.versionId()));
                LOG.error("Object could not be deleted!", (Throwable)e);
            }
        }
        return response;
    }

    public boolean deleteObject(String bucketName, String key, @Nullable String versionId) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            return false;
        }
        if (this.objectStore.deleteObject(bucketMetadata, id, versionId)) {
            return this.bucketStore.removeFromBucket(key, bucketName);
        }
        return false;
    }

    public void setObjectTags(String bucketName, String key, @Nullable String versionId, @Nullable List<Tag> tags) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        this.objectStore.storeObjectTags(bucketMetadata, uuid, versionId, tags);
    }

    public void verifyObjectTags(List<Tag> tags) {
        if (tags.size() > 50) {
            throw S3Exception.INVALID_TAG;
        }
        this.verifyDuplicateTagKeys(tags);
        for (Tag tag : tags) {
            this.verifyTagKeyPrefix(tag.key());
            this.verifyTagLength(1, 128, tag.key());
            this.verifyTagChars(tag.key());
            this.verifyTagLength(0, 256, tag.value());
            this.verifyTagChars(tag.value());
        }
    }

    private void verifyDuplicateTagKeys(List<Tag> tags) {
        HashSet<String> tagKeys = new HashSet<String>();
        for (Tag tag : tags) {
            if (tagKeys.add(tag.key())) continue;
            throw S3Exception.INVALID_TAG;
        }
    }

    private void verifyTagKeyPrefix(String tagKey) {
        if (tagKey.startsWith(DISALLOWED_TAG_KEY_PREFIX)) {
            throw S3Exception.INVALID_TAG;
        }
    }

    private void verifyTagLength(int minLength, int maxLength, String tag) {
        if (tag.length() < minLength || tag.length() > maxLength) {
            throw S3Exception.INVALID_TAG;
        }
    }

    private void verifyTagChars(String tag) {
        if (!TAG_ALLOWED_CHARS.matcher(tag).matches()) {
            throw S3Exception.INVALID_TAG;
        }
    }

    public void setLegalHold(String bucketName, String key, @Nullable String versionId, LegalHold legalHold) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        this.objectStore.storeLegalHold(bucketMetadata, uuid, versionId, legalHold);
    }

    public void setAcl(String bucketName, String key, @Nullable String versionId, AccessControlPolicy policy) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        this.objectStore.storeAcl(bucketMetadata, uuid, versionId, policy);
    }

    public AccessControlPolicy getAcl(String bucketName, String key, @Nullable String versionId) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        return this.objectStore.readAcl(bucketMetadata, uuid, versionId);
    }

    public void setRetention(String bucketName, String key, @Nullable String versionId, Retention retention) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        this.objectStore.storeRetention(bucketMetadata, uuid, versionId, retention);
    }

    public void verifyRetention(Retention retention) {
        Instant retainUntilDate = retention.retainUntilDate();
        if (Instant.now().isAfter(retainUntilDate)) {
            throw S3Exception.INVALID_REQUEST_RETAIN_DATE;
        }
    }

    public void verifyMd5(Path input, @Nullable String contentMd5) {
        try (InputStream stream = Files.newInputStream(input, new OpenOption[0]);){
            this.verifyMd5(stream, contentMd5);
        }
        catch (IOException e) {
            throw S3Exception.BAD_REQUEST_CONTENT;
        }
    }

    public void verifyMd5(InputStream inputStream, @Nullable String contentMd5) {
        String md5;
        if (contentMd5 != null && !(md5 = DigestUtil.base64Digest(inputStream)).equals(contentMd5)) {
            LOG.error("Content-MD5 {} does not match object md5 {}", (Object)contentMd5, (Object)md5);
            throw S3Exception.BAD_REQUEST_MD5;
        }
    }

    public void verifyObjectMatchingForCopy(@Nullable List<String> match, @Nullable List<String> noneMatch, @Nullable List<Instant> ifModifiedSince, @Nullable List<Instant> ifUnmodifiedSince, @Nullable S3ObjectMetadata s3ObjectMetadata) {
        try {
            this.verifyObjectMatching(match, noneMatch, ifModifiedSince, ifUnmodifiedSince, s3ObjectMetadata);
        }
        catch (S3Exception e) {
            if (S3Exception.NOT_MODIFIED.equals(e)) {
                throw S3Exception.PRECONDITION_FAILED;
            }
            throw e;
        }
    }

    public void verifyObjectMatching(String bucketName, String key, @Nullable List<String> match, @Nullable List<String> noneMatch) {
        try {
            S3ObjectMetadata s3ObjectMetadataExisting = this.getObject(bucketName, key, null);
            this.verifyObjectMatching(match, noneMatch, null, null, s3ObjectMetadataExisting);
        }
        catch (S3Exception e) {
            if (e == S3Exception.NOT_MODIFIED) {
                throw S3Exception.PRECONDITION_FAILED;
            }
            throw e;
        }
    }

    public void verifyObjectMatching(List<String> match, @Nullable List<Instant> matchLastModifiedTime, @Nullable List<Long> matchSize, @Nullable S3ObjectMetadata s3ObjectMetadata) {
        this.verifyObjectMatching(match, null, null, null, s3ObjectMetadata);
        if (s3ObjectMetadata != null) {
            String size;
            Instant lastModified;
            if (matchLastModifiedTime != null && !matchLastModifiedTime.isEmpty() && !(lastModified = Instant.ofEpochMilli(s3ObjectMetadata.lastModified())).truncatedTo(ChronoUnit.SECONDS).equals(matchLastModifiedTime.get(0).truncatedTo(ChronoUnit.SECONDS))) {
                throw S3Exception.PRECONDITION_FAILED;
            }
            if (matchSize != null && !matchSize.isEmpty() && !Long.valueOf(size = s3ObjectMetadata.size()).equals(matchSize.get(0))) {
                throw S3Exception.PRECONDITION_FAILED;
            }
        }
    }

    public void verifyObjectMatching(@Nullable List<String> match, @Nullable List<String> noneMatch, @Nullable List<Instant> ifModifiedSince, @Nullable List<Instant> ifUnmodifiedSince, @Nullable S3ObjectMetadata s3ObjectMetadata) {
        boolean setNoneMatch;
        boolean setUnmodifiedSince;
        boolean setMatch;
        boolean setModifiedSince;
        if (s3ObjectMetadata == null) {
            if (match != null && !match.isEmpty()) {
                throw S3Exception.NO_SUCH_KEY;
            }
            return;
        }
        String etag = s3ObjectMetadata.etag();
        Instant lastModified = Instant.ofEpochMilli(s3ObjectMetadata.lastModified());
        boolean bl = setModifiedSince = ifModifiedSince != null && !ifModifiedSince.isEmpty();
        if (setModifiedSince && ifModifiedSince.get(0).isAfter(lastModified)) {
            LOG.debug("Object {} not modified since {}", (Object)s3ObjectMetadata.key(), (Object)ifModifiedSince.get(0));
            throw S3Exception.NOT_MODIFIED;
        }
        boolean bl2 = setMatch = match != null && !match.isEmpty();
        if (setMatch) {
            if (match.contains(WILDCARD_ETAG) || match.contains(WILDCARD) || match.contains(etag)) {
                LOG.debug("Object {} exists", (Object)s3ObjectMetadata.key());
                return;
            }
            if (!match.contains(etag)) {
                LOG.debug("Object {} does not match etag {}", (Object)s3ObjectMetadata.key(), (Object)etag);
                throw S3Exception.PRECONDITION_FAILED;
            }
        }
        boolean bl3 = setUnmodifiedSince = ifUnmodifiedSince != null && !ifUnmodifiedSince.isEmpty();
        if (setUnmodifiedSince && ifUnmodifiedSince.get(0).isBefore(lastModified)) {
            LOG.debug("Object {} modified since {}", (Object)s3ObjectMetadata.key(), (Object)ifUnmodifiedSince.get(0));
            throw S3Exception.PRECONDITION_FAILED;
        }
        boolean bl4 = setNoneMatch = noneMatch != null && !noneMatch.isEmpty();
        if (setNoneMatch && (noneMatch.contains(WILDCARD_ETAG) || noneMatch.contains(WILDCARD) || noneMatch.contains(etag))) {
            LOG.debug("Object {} has an ETag {} that matches one of the 'noneMatch' values", (Object)s3ObjectMetadata.key(), (Object)etag);
            throw S3Exception.NOT_MODIFIED;
        }
    }

    public S3ObjectMetadata verifyObjectExists(String bucketName, String key, @Nullable String versionId) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        if (uuid == null) {
            throw S3Exception.NO_SUCH_KEY;
        }
        S3ObjectMetadata s3ObjectMetadata = this.objectStore.getS3ObjectMetadata(bucketMetadata, uuid, versionId);
        if (s3ObjectMetadata == null) {
            throw S3Exception.NO_SUCH_KEY;
        }
        if (s3ObjectMetadata.deleteMarker()) {
            throw S3Exception.NO_SUCH_KEY_DELETE_MARKER;
        }
        return s3ObjectMetadata;
    }

    public @Nullable S3ObjectMetadata getObject(String bucketName, String key, @Nullable String versionId) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        if (uuid == null) {
            return null;
        }
        return this.objectStore.getS3ObjectMetadata(bucketMetadata, uuid, versionId);
    }

    public S3ObjectMetadata verifyObjectLockConfiguration(String bucketName, String key, @Nullable String versionId) {
        boolean noRetention;
        S3ObjectMetadata s3ObjectMetadata = this.verifyObjectExists(bucketName, key, versionId);
        boolean noLegalHold = s3ObjectMetadata.legalHold() == null;
        boolean bl = noRetention = s3ObjectMetadata.retention() == null;
        if (noLegalHold && noRetention) {
            throw S3Exception.NOT_FOUND_OBJECT_LOCK;
        }
        return s3ObjectMetadata;
    }
}

