/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.service;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.ChecksumType;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CompletedPart;
import com.adobe.testing.s3mock.dto.CopyPartResult;
import com.adobe.testing.s3mock.dto.InitiateMultipartUploadResult;
import com.adobe.testing.s3mock.dto.ListMultipartUploadsResult;
import com.adobe.testing.s3mock.dto.ListPartsResult;
import com.adobe.testing.s3mock.dto.MultipartUpload;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Part;
import com.adobe.testing.s3mock.dto.Prefix;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.service.ServiceBase;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.MultipartStore;
import com.adobe.testing.s3mock.store.MultipartUploadInfo;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRange;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public class MultipartService
extends ServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartService.class);
    static final Long MINIMUM_PART_SIZE = 0x500000L;
    private final BucketStore bucketStore;
    private final MultipartStore multipartStore;

    public MultipartService(BucketStore bucketStore, MultipartStore multipartStore) {
        this.bucketStore = bucketStore;
        this.multipartStore = multipartStore;
    }

    public @Nullable String putPart(String bucketName, String key, String uploadId, String partNumber, Path path, Map<String, String> encryptionHeaders) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        if (uuid == null) {
            return null;
        }
        return this.multipartStore.putPart(bucketMetadata, uuid, uploadId, partNumber, path, encryptionHeaders);
    }

    public @Nullable CopyPartResult copyPart(String bucketName, String key, HttpRange copyRange, String partNumber, String destinationBucket, String destinationKey, String uploadId, Map<String, String> encryptionHeaders, String versionId) {
        BucketMetadata sourceBucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        BucketMetadata destinationBucketMetadata = this.bucketStore.getBucketMetadata(destinationBucket);
        UUID sourceId = sourceBucketMetadata.getID(key);
        if (sourceId == null) {
            return null;
        }
        UUID destinationId = this.bucketStore.addKeyToBucket(destinationKey, destinationBucket);
        try {
            String partEtag = this.multipartStore.copyPart(sourceBucketMetadata, sourceId, copyRange, partNumber, destinationBucketMetadata, destinationId, uploadId, encryptionHeaders, versionId);
            return CopyPartResult.from(new Date(), "\"" + partEtag + "\"");
        }
        catch (Exception e) {
            this.bucketStore.removeFromBucket(destinationKey, destinationBucket);
            throw new IllegalStateException(String.format("Could not copy part. sourceBucket=%s, destinationBucket=%s, key=%s, sourceId=%s, destinationId=%s, uploadId=%s", sourceBucketMetadata, destinationBucketMetadata, key, sourceId, destinationId, uploadId), e);
        }
    }

    public @Nullable ListPartsResult getMultipartUploadParts(String bucketName, String key, Integer maxParts, Integer partNumberMarker, String uploadId) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            return null;
        }
        MultipartUpload multipartUpload = this.multipartStore.getMultipartUpload(bucketMetadata, uploadId);
        List<Object> parts = this.multipartStore.getMultipartUploadParts(bucketMetadata, id, uploadId).stream().toList();
        parts = MultipartService.filterBy(parts, Part::partNumber, partNumberMarker);
        Integer nextPartNumberMarker = null;
        boolean isTruncated = false;
        if (parts.size() > maxParts) {
            parts = parts.subList(0, maxParts);
            nextPartNumberMarker = ((Part)parts.get(maxParts - 1)).partNumber();
            isTruncated = true;
        }
        return new ListPartsResult(bucketName, multipartUpload.checksumAlgorithm(), multipartUpload.checksumType(), multipartUpload.initiator(), isTruncated, key, maxParts, nextPartNumberMarker, multipartUpload.owner(), parts, partNumberMarker, multipartUpload.storageClass(), uploadId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortMultipartUpload(String bucketName, String key, String uploadId) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        try {
            this.multipartStore.abortMultipartUpload(bucketMetadata, id, uploadId);
        }
        finally {
            this.bucketStore.removeFromBucket(key, bucketName);
        }
    }

    public @Nullable CompleteMultipartUploadResult completeMultipartUpload(String bucketName, String key, String uploadId, List<CompletedPart> parts, Map<String, String> encryptionHeaders, String location, @Nullable String checksum, @Nullable ChecksumAlgorithm checksumAlgorithm) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            return null;
        }
        MultipartUploadInfo multipartUploadInfo = this.multipartStore.getMultipartUploadInfo(bucketMetadata, uploadId);
        return this.multipartStore.completeMultipartUpload(bucketMetadata, key, id, uploadId, parts, encryptionHeaders, multipartUploadInfo, location, checksum, checksumAlgorithm);
    }

    public InitiateMultipartUploadResult createMultipartUpload(String bucketName, String key, @Nullable String contentType, Map<String, String> storeHeaders, Owner owner, Owner initiator, Map<String, String> userMetadata, Map<String, String> encryptionHeaders, List<Tag> tags, StorageClass storageClass, ChecksumType checksumType, ChecksumAlgorithm checksumAlgorithm) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = this.bucketStore.addKeyToBucket(key, bucketName);
        try {
            MultipartUpload multipartUpload = this.multipartStore.createMultipartUpload(bucketMetadata, key, id, contentType, storeHeaders, owner, initiator, userMetadata, encryptionHeaders, tags, storageClass, checksumType, checksumAlgorithm);
            return new InitiateMultipartUploadResult(bucketName, key, multipartUpload.uploadId());
        }
        catch (Exception e) {
            this.bucketStore.removeFromBucket(key, bucketName);
            throw new IllegalStateException(String.format("Could prepare Multipart Upload. bucket=%s, key=%s, id=%s", bucketMetadata, key, id), e);
        }
    }

    public ListMultipartUploadsResult listMultipartUploads(String bucketName, String delimiter, String encodingType, String keyMarker, Integer maxUploads, @Nullable String prefix, String uploadIdMarker) {
        String nextKeyMarker = null;
        String nextUploadIdMarker = null;
        boolean isTruncated = false;
        String normalizedPrefix = prefix == null ? "" : prefix;
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        List<MultipartUpload> contents = this.multipartStore.listMultipartUploads(bucketMetadata, prefix).stream().filter(mu -> mu.key().startsWith(normalizedPrefix)).sorted(Comparator.comparing(MultipartUpload::key)).toList();
        contents = MultipartService.filterBy(contents, MultipartUpload::key, keyMarker);
        List<String> commonPrefixes = MultipartService.collapseCommonPrefixes(prefix, delimiter, contents, MultipartUpload::key);
        contents = MultipartService.filterBy(contents, MultipartUpload::key, commonPrefixes);
        if (maxUploads < contents.size()) {
            contents = contents.subList(0, maxUploads);
            isTruncated = true;
            if (maxUploads > 0) {
                nextKeyMarker = contents.get(maxUploads - 1).key();
                nextUploadIdMarker = contents.get(maxUploads - 1).uploadId();
            }
        }
        String returnDelimiter = delimiter;
        String returnKeyMarker = keyMarker;
        String returnPrefix = prefix;
        List<String> returnCommonPrefixes = commonPrefixes;
        if (Objects.equals("url", encodingType)) {
            contents = MultipartService.mapContents(contents, object -> new MultipartUpload(object.checksumAlgorithm(), object.checksumType(), object.initiated(), object.initiator(), SdkHttpUtils.urlEncodeIgnoreSlashes((String)object.key()), object.owner(), object.storageClass(), object.uploadId()));
            returnPrefix = SdkHttpUtils.urlEncodeIgnoreSlashes((String)prefix);
            returnCommonPrefixes = MultipartService.mapContents(commonPrefixes, SdkHttpUtils::urlEncodeIgnoreSlashes);
            returnDelimiter = SdkHttpUtils.urlEncodeIgnoreSlashes((String)delimiter);
            returnKeyMarker = SdkHttpUtils.urlEncodeIgnoreSlashes((String)keyMarker);
            nextKeyMarker = SdkHttpUtils.urlEncodeIgnoreSlashes((String)nextKeyMarker);
        }
        return new ListMultipartUploadsResult(bucketName, returnKeyMarker, returnDelimiter, returnPrefix, uploadIdMarker, maxUploads, isTruncated, nextKeyMarker, nextUploadIdMarker, contents, returnCommonPrefixes.stream().map(Prefix::new).toList(), encodingType);
    }

    public void verifyPartNumberLimits(String partNumberString) {
        try {
            int partNumber = Integer.parseInt(partNumberString);
            if (partNumber < 1 || partNumber > 10000) {
                LOG.error("Multipart part number invalid. partNumber={}", (Object)partNumberString);
                throw S3Exception.INVALID_PART_NUMBER;
            }
        }
        catch (NumberFormatException nfe) {
            LOG.error("Multipart part number invalid. partNumber={}", (Object)partNumberString, (Object)nfe);
            throw S3Exception.INVALID_PART_NUMBER;
        }
    }

    public void verifyMultipartParts(String bucketName, String key, String uploadId, List<CompletedPart> requestedParts) throws S3Exception {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            throw S3Exception.INVALID_PART;
        }
        this.verifyMultipartParts(bucketName, id, uploadId);
        List<Part> uploadedParts = this.multipartStore.getMultipartUploadParts(bucketMetadata, id, uploadId);
        Map<Integer, String> uploadedPartsMap = uploadedParts.stream().collect(Collectors.toMap(Part::partNumber, Part::etag));
        int prevPartNumber = 0;
        for (CompletedPart part : requestedParts) {
            if (!uploadedPartsMap.containsKey(part.partNumber()) || !uploadedPartsMap.get(part.partNumber()).equals(part.etag())) {
                LOG.error("Multipart part not valid. bucket={}, id={}, uploadId={}, partNumber={}", new Object[]{bucketMetadata, id, uploadId, part.partNumber()});
                throw S3Exception.INVALID_PART;
            }
            if (part.partNumber() < prevPartNumber) {
                LOG.error("Multipart parts order invalid. bucket={}, id={}, uploadId={}, partNumber={}", new Object[]{bucketMetadata, id, uploadId, part.partNumber()});
                throw S3Exception.INVALID_PART_ORDER;
            }
            prevPartNumber = part.partNumber();
        }
    }

    public void verifyMultipartParts(String bucketName, UUID id, String uploadId) throws S3Exception {
        this.verifyMultipartUploadExists(bucketName, uploadId);
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        List<Part> uploadedParts = this.multipartStore.getMultipartUploadParts(bucketMetadata, id, uploadId);
        if (!uploadedParts.isEmpty()) {
            for (int i = 0; i < uploadedParts.size() - 1; ++i) {
                Part part = uploadedParts.get(i);
                this.verifyPartNumberLimits(part.partNumber().toString());
                if (part.size() >= MINIMUM_PART_SIZE) continue;
                LOG.error("Multipart part size too small. bucket={}, id={}, uploadId={}, size={}", new Object[]{bucketMetadata, id, uploadId, part.size()});
                throw S3Exception.ENTITY_TOO_SMALL;
            }
        }
    }

    public void verifyMultipartUploadExists(String bucketName, String uploadId) throws S3Exception {
        try {
            BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
            this.multipartStore.getMultipartUpload(bucketMetadata, uploadId);
        }
        catch (IllegalArgumentException e) {
            throw S3Exception.NO_SUCH_UPLOAD_MULTIPART;
        }
    }
}

