/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.service;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.Bucket;
import com.adobe.testing.s3mock.dto.BucketInfo;
import com.adobe.testing.s3mock.dto.BucketLifecycleConfiguration;
import com.adobe.testing.s3mock.dto.BucketType;
import com.adobe.testing.s3mock.dto.Buckets;
import com.adobe.testing.s3mock.dto.DeleteMarkerEntry;
import com.adobe.testing.s3mock.dto.ListAllMyBucketsResult;
import com.adobe.testing.s3mock.dto.ListBucketResult;
import com.adobe.testing.s3mock.dto.ListBucketResultV2;
import com.adobe.testing.s3mock.dto.ListVersionsResult;
import com.adobe.testing.s3mock.dto.LocationInfo;
import com.adobe.testing.s3mock.dto.ObjectLockConfiguration;
import com.adobe.testing.s3mock.dto.ObjectOwnership;
import com.adobe.testing.s3mock.dto.ObjectVersion;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Prefix;
import com.adobe.testing.s3mock.dto.Region;
import com.adobe.testing.s3mock.dto.S3Object;
import com.adobe.testing.s3mock.dto.VersioningConfiguration;
import com.adobe.testing.s3mock.service.ServiceBase;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.store.S3ObjectVersions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public class BucketService {
    private final Map<String, String> listObjectsPagingStateCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> listBucketsPagingStateCache = new ConcurrentHashMap<String, String>();
    private final BucketStore bucketStore;
    private final ObjectStore objectStore;

    public BucketService(BucketStore bucketStore, ObjectStore objectStore) {
        this.bucketStore = bucketStore;
        this.objectStore = objectStore;
    }

    public boolean isBucketEmpty(String bucketName) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        if (bucketMetadata != null) {
            Map<String, UUID> objects = bucketMetadata.objects();
            if (!objects.isEmpty()) {
                for (UUID id : objects.values()) {
                    S3ObjectMetadata s3ObjectMetadata = this.objectStore.getS3ObjectMetadata(bucketMetadata, id, null);
                    if (s3ObjectMetadata == null || s3ObjectMetadata.deleteMarker()) continue;
                    return false;
                }
                return true;
            }
            return bucketMetadata.objects().isEmpty();
        }
        throw new IllegalStateException("Requested Bucket does not exist: " + bucketName);
    }

    public boolean doesBucketExist(String bucketName) {
        return this.bucketStore.doesBucketExist(bucketName);
    }

    public ListAllMyBucketsResult listBuckets(@Nullable Region bucketRegion, @Nullable String continuationToken, Integer maxBuckets, @Nullable String prefix) {
        String nextContinuationToken = null;
        String normalizedPrefix = prefix == null ? "" : prefix;
        List<Bucket> buckets = this.bucketStore.listBuckets().stream().filter(Objects::nonNull).filter(b -> b.name().startsWith(normalizedPrefix)).sorted(Comparator.comparing(BucketMetadata::name)).map(Bucket::from).toList();
        if (bucketRegion != null) {
            buckets = buckets.stream().filter(b -> b.bucketRegion().equals(bucketRegion.toString())).toList();
        }
        if (continuationToken != null) {
            String continueAfter = this.listBucketsPagingStateCache.get(continuationToken);
            buckets = ServiceBase.filterBy(buckets, Bucket::name, continueAfter);
            this.listBucketsPagingStateCache.remove(continuationToken);
        }
        if (buckets.size() > maxBuckets) {
            nextContinuationToken = UUID.randomUUID().toString();
            buckets = buckets.subList(0, maxBuckets);
            this.listBucketsPagingStateCache.put(nextContinuationToken, buckets.get(maxBuckets - 1).name());
        }
        return new ListAllMyBucketsResult(Owner.DEFAULT_OWNER, new Buckets(buckets), prefix, nextContinuationToken);
    }

    public Bucket getBucket(String bucketName) {
        return Bucket.from(this.bucketStore.getBucketMetadata(bucketName));
    }

    public Bucket createBucket(String bucketName, boolean objectLockEnabled, ObjectOwnership objectOwnership, @Nullable String bucketRegion, @Nullable BucketInfo bucketInfo, @Nullable LocationInfo locationInfo) {
        return Bucket.from(this.bucketStore.createBucket(bucketName, objectLockEnabled, objectOwnership, bucketRegion, bucketInfo, locationInfo));
    }

    public boolean deleteBucket(String bucketName) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        if (bucketMetadata != null) {
            Map<String, UUID> objects = bucketMetadata.objects();
            if (!objects.isEmpty()) {
                for (Map.Entry<String, UUID> entry : objects.entrySet()) {
                    S3ObjectMetadata s3ObjectMetadata = this.objectStore.getS3ObjectMetadata(bucketMetadata, entry.getValue(), null);
                    if (s3ObjectMetadata == null || !s3ObjectMetadata.deleteMarker()) continue;
                    this.objectStore.doDeleteObject(bucketMetadata, entry.getValue());
                    this.bucketStore.removeFromBucket(entry.getKey(), bucketName);
                }
            }
            if (!(bucketMetadata = this.bucketStore.getBucketMetadata(bucketName)).objects().isEmpty()) {
                throw new IllegalStateException("Bucket is not empty: " + bucketName);
            }
            return this.bucketStore.deleteBucket(bucketName);
        }
        throw new IllegalStateException("Requested Bucket does not exist: " + bucketName);
    }

    public void setVersioningConfiguration(String bucketName, VersioningConfiguration configuration) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        this.bucketStore.storeVersioningConfiguration(bucketMetadata, configuration);
    }

    public VersioningConfiguration getVersioningConfiguration(String bucketName) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        VersioningConfiguration configuration = bucketMetadata.versioningConfiguration();
        if (configuration != null) {
            return configuration;
        }
        throw S3Exception.NOT_FOUND_BUCKET_VERSIONING_CONFIGURATION;
    }

    public void setObjectLockConfiguration(String bucketName, ObjectLockConfiguration configuration) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        this.bucketStore.storeObjectLockConfiguration(bucketMetadata, configuration);
    }

    public ObjectLockConfiguration getObjectLockConfiguration(String bucketName) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        ObjectLockConfiguration objectLockConfiguration = bucketMetadata.objectLockConfiguration();
        if (objectLockConfiguration != null) {
            return objectLockConfiguration;
        }
        throw S3Exception.NOT_FOUND_BUCKET_OBJECT_LOCK;
    }

    public void setBucketLifecycleConfiguration(String bucketName, @Nullable BucketLifecycleConfiguration configuration) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        this.bucketStore.storeBucketLifecycleConfiguration(bucketMetadata, configuration);
    }

    public void deleteBucketLifecycleConfiguration(String bucketName) {
        this.setBucketLifecycleConfiguration(bucketName, null);
    }

    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        BucketLifecycleConfiguration configuration = bucketMetadata.bucketLifecycleConfiguration();
        if (configuration != null) {
            return configuration;
        }
        throw S3Exception.NO_SUCH_LIFECYCLE_CONFIGURATION;
    }

    public List<S3Object> getS3Objects(String bucketName, @Nullable String prefix) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        List<UUID> uuids = this.bucketStore.lookupKeysInBucket(prefix, bucketName);
        return uuids.stream().filter(Objects::nonNull).map(uuid -> this.objectStore.getS3ObjectMetadata(bucketMetadata, (UUID)uuid, null)).filter(Objects::nonNull).map(S3Object::from).sorted(Comparator.comparing(S3Object::key)).toList();
    }

    public ListVersionsResult listVersions(String bucketName, String prefix, String delimiter, String encodingType, Integer maxKeys, String keyMarker, String versionIdMarker) {
        ListBucketResult result = this.listObjectsV1(bucketName, prefix, delimiter, keyMarker, encodingType, maxKeys);
        BucketMetadata bucket = this.bucketStore.getBucketMetadata(bucketName);
        ArrayList<ObjectVersion> objectVersions = new ArrayList<ObjectVersion>();
        ArrayList<DeleteMarkerEntry> deleteMarkers = new ArrayList<DeleteMarkerEntry>();
        String nextVersionIdMarker = null;
        block0: for (S3Object object : result.contents()) {
            if (nextVersionIdMarker != null) break;
            UUID id = bucket.getID(object.key());
            if (bucket.isVersioningEnabled()) {
                S3ObjectVersions s3ObjectVersions = this.objectStore.getS3ObjectVersions(bucket, id);
                ArrayList<String> versions = new ArrayList<String>(s3ObjectVersions.versions());
                Collections.reverse(versions);
                for (String s3ObjectVersion : versions) {
                    S3ObjectMetadata s3ObjectMetadata = this.objectStore.getS3ObjectMetadata(bucket, id, s3ObjectVersion);
                    if (!s3ObjectMetadata.deleteMarker()) {
                        if (objectVersions.size() > maxKeys) {
                            nextVersionIdMarker = s3ObjectVersion;
                            continue block0;
                        }
                        objectVersions.add(ObjectVersion.from(s3ObjectMetadata, Objects.equals(s3ObjectVersions.getLatestVersion(), s3ObjectVersion)));
                        continue;
                    }
                    deleteMarkers.add(DeleteMarkerEntry.from(s3ObjectMetadata, Objects.equals(s3ObjectVersions.getLatestVersion(), s3ObjectVersion)));
                }
                continue;
            }
            objectVersions.add(ObjectVersion.from(object));
        }
        return new ListVersionsResult(result.commonPrefixes(), deleteMarkers, delimiter, result.encodingType(), result.isTruncated(), keyMarker, result.maxKeys(), result.name(), result.nextMarker(), nextVersionIdMarker, result.prefix(), objectVersions, versionIdMarker);
    }

    public ListBucketResultV2 listObjectsV2(String bucketName, @Nullable String prefix, @Nullable String delimiter, @Nullable String encodingType, @Nullable String startAfter, Integer maxKeys, @Nullable String continuationToken, boolean fetchOwner) {
        if (maxKeys == 0) {
            return new ListBucketResultV2(List.of(), List.of(), continuationToken, delimiter, encodingType, false, maxKeys, bucketName, null, prefix, "0", null);
        }
        List<S3Object> contents = this.getS3Objects(bucketName, prefix);
        if (!fetchOwner) {
            contents = ServiceBase.mapContents(contents, object -> new S3Object(object.checksumAlgorithm(), object.checksumType(), object.etag(), object.key(), object.lastModified(), null, null, object.size(), object.storageClass()));
        }
        String nextContinuationToken = null;
        boolean isTruncated = false;
        if (continuationToken != null) {
            String continueAfter = this.listObjectsPagingStateCache.get(continuationToken);
            contents = ServiceBase.filterBy(contents, S3Object::key, continueAfter);
            this.listObjectsPagingStateCache.remove(continuationToken);
        } else {
            contents = ServiceBase.filterBy(contents, S3Object::key, startAfter);
        }
        List<String> commonPrefixes = ServiceBase.collapseCommonPrefixes(prefix, delimiter, contents, S3Object::key);
        contents = ServiceBase.filterBy(contents, S3Object::key, commonPrefixes);
        if (contents.size() > maxKeys) {
            isTruncated = true;
            nextContinuationToken = UUID.randomUUID().toString();
            contents = contents.subList(0, maxKeys);
            this.listObjectsPagingStateCache.put(nextContinuationToken, contents.get(maxKeys - 1).key());
        }
        String returnDelimiter = delimiter;
        String returnPrefix = prefix;
        String returnStartAfter = startAfter;
        List<String> returnCommonPrefixes = commonPrefixes;
        if (Objects.equals("url", encodingType)) {
            contents = ServiceBase.mapContents(contents, object -> new S3Object(object.checksumAlgorithm(), object.checksumType(), object.etag(), SdkHttpUtils.urlEncodeIgnoreSlashes((String)object.key()), object.lastModified(), object.owner(), object.restoreStatus(), object.size(), object.storageClass()));
            returnPrefix = SdkHttpUtils.urlEncodeIgnoreSlashes((String)prefix);
            returnStartAfter = SdkHttpUtils.urlEncodeIgnoreSlashes((String)startAfter);
            returnCommonPrefixes = ServiceBase.mapContents(commonPrefixes, SdkHttpUtils::urlEncodeIgnoreSlashes);
            returnDelimiter = SdkHttpUtils.urlEncodeIgnoreSlashes((String)delimiter);
        }
        return new ListBucketResultV2(returnCommonPrefixes.stream().map(Prefix::new).toList(), contents, continuationToken, returnDelimiter, encodingType, isTruncated, maxKeys, bucketName, nextContinuationToken, returnPrefix, String.valueOf(contents.size()), returnStartAfter);
    }

    @Deprecated(since="2.12.2", forRemoval=true)
    public ListBucketResult listObjectsV1(String bucketName, @Nullable String prefix, @Nullable String delimiter, @Nullable String marker, @Nullable String encodingType, Integer maxKeys) {
        if (maxKeys == 0) {
            return new ListBucketResult(List.of(), List.of(), null, encodingType, false, marker, maxKeys, bucketName, marker, prefix);
        }
        List<S3Object> contents = this.getS3Objects(bucketName, prefix);
        contents = ServiceBase.filterBy(contents, S3Object::key, marker);
        boolean isTruncated = false;
        String nextMarker = null;
        List<String> commonPrefixes = ServiceBase.collapseCommonPrefixes(prefix, delimiter, contents, S3Object::key);
        contents = ServiceBase.filterBy(contents, S3Object::key, commonPrefixes);
        if (maxKeys < contents.size()) {
            contents = contents.subList(0, maxKeys);
            isTruncated = true;
            if (maxKeys > 0) {
                nextMarker = contents.get(maxKeys - 1).key();
            }
        }
        String returnPrefix = prefix;
        List<String> returnCommonPrefixes = commonPrefixes;
        if (Objects.equals("url", encodingType)) {
            contents = ServiceBase.mapContents(contents, object -> new S3Object(object.checksumAlgorithm(), object.checksumType(), object.etag(), SdkHttpUtils.urlEncodeIgnoreSlashes((String)object.key()), object.lastModified(), object.owner(), object.restoreStatus(), object.size(), object.storageClass()));
            returnPrefix = SdkHttpUtils.urlEncodeIgnoreSlashes((String)prefix);
            returnCommonPrefixes = ServiceBase.mapContents(commonPrefixes, SdkHttpUtils::urlEncodeIgnoreSlashes);
        }
        return new ListBucketResult(returnCommonPrefixes.stream().map(Prefix::new).toList(), contents, delimiter, encodingType, isTruncated, marker, maxKeys, bucketName, nextMarker, returnPrefix);
    }

    public Map<String, String> bucketLocationHeaders(BucketMetadata bucketMetadata) {
        if (bucketMetadata.bucketInfo() != null && bucketMetadata.bucketInfo().type() != null && bucketMetadata.bucketInfo().type() == BucketType.DIRECTORY && bucketMetadata.locationInfo() != null && bucketMetadata.locationInfo().name() != null && bucketMetadata.locationInfo().type() != null) {
            return Map.of("x-amz-bucket-location-name", bucketMetadata.locationInfo().name(), "x-amz-bucket-location-type", bucketMetadata.locationInfo().type().toString());
        }
        return Map.of();
    }

    public BucketMetadata verifyBucketExists(String bucketName) {
        if (!this.bucketStore.doesBucketExist(bucketName)) {
            throw S3Exception.NO_SUCH_BUCKET;
        }
        return this.bucketStore.getBucketMetadata(bucketName);
    }

    public void verifyBucketObjectLockEnabled(String bucketName) {
        if (!this.bucketStore.isObjectLockEnabled(bucketName)) {
            throw S3Exception.NOT_FOUND_BUCKET_OBJECT_LOCK;
        }
    }

    public void verifyBucketNameIsAllowed(String bucketName) {
        if (!bucketName.matches("[a-z0-9.-]+")) {
            throw S3Exception.INVALID_BUCKET_NAME;
        }
    }

    public void verifyBucketIsEmpty(String bucketName) {
        if (!this.isBucketEmpty(bucketName)) {
            throw S3Exception.BUCKET_NOT_EMPTY;
        }
    }

    public void verifyBucketDoesNotExist(String bucketName) {
        if (this.bucketStore.doesBucketExist(bucketName)) {
            throw S3Exception.BUCKET_ALREADY_OWNED_BY_YOU;
        }
    }

    public void verifyMaxKeys(Integer maxKeys) {
        if (maxKeys < 0) {
            throw S3Exception.INVALID_REQUEST_MAX_KEYS;
        }
    }

    public void verifyEncodingType(String encodingType) {
        if (StringUtils.isNotEmpty((CharSequence)encodingType) && !"url".equals(encodingType)) {
            throw S3Exception.INVALID_REQUEST_ENCODING_TYPE;
        }
    }
}

