/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public record CopySource(String bucket, String key, @Nullable String versionId) {
    static final String DELIMITER = "/";

    public static CopySource from(String copySource) {
        String[] bucketAndKey = CopySource.extractBucketAndKeyArray(SdkHttpUtils.urlDecode((String)copySource));
        String bucket = Objects.requireNonNull(bucketAndKey[0]);
        String key = Objects.requireNonNull(bucketAndKey[1]);
        String versionId = null;
        if (key.contains("?versionId=")) {
            String[] keyAndVersionId = key.split("\\?versionId=");
            key = keyAndVersionId[0];
            versionId = keyAndVersionId[1];
        }
        return new CopySource(bucket, key, versionId);
    }

    private static String[] extractBucketAndKeyArray(String copySource) {
        Objects.requireNonNull(copySource, "copySource == null");
        String source = CopySource.normalizeCopySource(copySource);
        String[] bucketAndKey = source.split(DELIMITER, 2);
        if (bucketAndKey.length != 2) {
            throw new IllegalArgumentException("Expected a copySource as '/{bucket}/{key}' but got: " + copySource);
        }
        return bucketAndKey;
    }

    private static String normalizeCopySource(String copySource) {
        if (copySource.startsWith(DELIMITER)) {
            return copySource.substring(1);
        }
        return copySource;
    }
}

