/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.S3Verified;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.EtagUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

@JsonRootName(value="CopyObjectResult")
@S3Verified(year=2025)
public record CopyObjectResult(@JsonProperty(value="ETag") String etag, @JsonProperty(value="LastModified") String lastModified, @JacksonXmlProperty(isAttribute=true, localName="xmlns") String xmlns) {
    public CopyObjectResult {
        etag = EtagUtil.normalizeEtag(etag);
        if (xmlns == null) {
            xmlns = "http://s3.amazonaws.com/doc/2006-03-01/";
        }
    }

    public CopyObjectResult(String lastModified, String etag) {
        this(etag, lastModified, null);
    }

    public CopyObjectResult(S3ObjectMetadata metadata) {
        this(metadata.modificationDate(), metadata.etag());
    }
}

