/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.BucketController;
import com.adobe.testing.s3mock.ChecksumModeHeaderConverter;
import com.adobe.testing.s3mock.FaviconController;
import com.adobe.testing.s3mock.HttpRangeHeaderConverter;
import com.adobe.testing.s3mock.KmsValidationFilter;
import com.adobe.testing.s3mock.MultipartController;
import com.adobe.testing.s3mock.ObjectCannedAclHeaderConverter;
import com.adobe.testing.s3mock.ObjectController;
import com.adobe.testing.s3mock.ObjectOwnershipHeaderConverter;
import com.adobe.testing.s3mock.RegionConverter;
import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.S3MockProperties;
import com.adobe.testing.s3mock.TaggingHeaderConverter;
import com.adobe.testing.s3mock.dto.ErrorResponse;
import com.adobe.testing.s3mock.service.BucketService;
import com.adobe.testing.s3mock.service.MultipartService;
import com.adobe.testing.s3mock.service.ObjectService;
import com.adobe.testing.s3mock.store.KmsKeyStore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import org.apache.catalina.connector.Connector;
import org.apache.tomcat.util.buf.EncodedSolidusHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.filter.OrderedFormContentFilter;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.filter.CommonsRequestLoggingFilter;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Configuration
@EnableConfigurationProperties(value={S3MockProperties.class})
public class S3MockConfiguration
implements WebMvcConfigurer {
    private Connector httpConnector;

    @Bean
    ServletWebServerFactory webServerFactory(S3MockProperties properties) {
        TomcatServletWebServerFactory factory = new TomcatServletWebServerFactory();
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            connector.setEncodedSolidusHandling(EncodedSolidusHandling.DECODE.getValue());
            connector.setAllowBackslash(true);
        }});
        factory.addAdditionalTomcatConnectors(new Connector[]{this.createHttpConnector(properties.httpPort())});
        return factory;
    }

    private Connector createHttpConnector(int httpPort) {
        this.httpConnector = new Connector();
        this.httpConnector.setPort(httpPort);
        return this.httpConnector;
    }

    Connector getHttpConnector() {
        return this.httpConnector;
    }

    @Bean
    Filter kmsFilter(KmsKeyStore kmsKeyStore, MappingJackson2XmlHttpMessageConverter messageConverter) {
        return new KmsValidationFilter(kmsKeyStore, messageConverter);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_XML});
        configurer.mediaType("xml", MediaType.TEXT_XML);
    }

    @Bean
    @Profile(value={"debug"})
    public CommonsRequestLoggingFilter logFilter() {
        CommonsRequestLoggingFilter filter = new CommonsRequestLoggingFilter();
        filter.setIncludeQueryString(true);
        filter.setIncludeClientInfo(true);
        filter.setIncludePayload(true);
        filter.setMaxPayloadLength(10000);
        filter.setIncludeHeaders(true);
        return filter;
    }

    @Bean
    MappingJackson2XmlHttpMessageConverter messageConverter() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaType.APPLICATION_XML);
        mediaTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
        mediaTypes.add(MediaType.APPLICATION_OCTET_STREAM);
        MappingJackson2XmlHttpMessageConverter xmlConverter = new MappingJackson2XmlHttpMessageConverter();
        xmlConverter.setSupportedMediaTypes(mediaTypes);
        XmlMapper xmlMapper = (XmlMapper)xmlConverter.getObjectMapper();
        xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        xmlMapper.enable(ToXmlGenerator.Feature.AUTO_DETECT_XSI_TYPE);
        xmlMapper.enable(FromXmlParser.Feature.AUTO_DETECT_XSI_TYPE);
        xmlMapper.enable(ToXmlGenerator.Feature.WRITE_XML_DECLARATION);
        xmlMapper.getFactory().getXMLOutputFactory().setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        return xmlConverter;
    }

    @Bean
    OrderedFormContentFilter httpPutFormContentFilter() {
        return new OrderedFormContentFilter(){

            protected boolean shouldNotFilter(@NonNull HttpServletRequest request) {
                return true;
            }
        };
    }

    @Bean
    FaviconController faviconController() {
        return new FaviconController();
    }

    @Bean
    ObjectController fileStoreController(ObjectService objectService, BucketService bucketService) {
        return new ObjectController(bucketService, objectService);
    }

    @Bean
    BucketController bucketController(BucketService bucketService) {
        return new BucketController(bucketService);
    }

    @Bean
    MultipartController multipartController(BucketService bucketService, ObjectService objectService, MultipartService multipartService) {
        return new MultipartController(bucketService, objectService, multipartService);
    }

    @Bean
    S3MockExceptionHandler s3MockExceptionHandler() {
        return new S3MockExceptionHandler();
    }

    @Bean
    IllegalStateExceptionHandler illegalStateExceptionHandler() {
        return new IllegalStateExceptionHandler();
    }

    @Bean
    ObjectCannedAclHeaderConverter objectCannedAclHeaderConverter() {
        return new ObjectCannedAclHeaderConverter();
    }

    @Bean
    TaggingHeaderConverter taggingHeaderConverter() {
        return new TaggingHeaderConverter();
    }

    @Bean
    HttpRangeHeaderConverter httpRangeHeaderConverter() {
        return new HttpRangeHeaderConverter();
    }

    @Bean
    ObjectOwnershipHeaderConverter objectOwnershipHeaderConverter() {
        return new ObjectOwnershipHeaderConverter();
    }

    @Bean
    ChecksumModeHeaderConverter checksumModeHeaderConverter() {
        return new ChecksumModeHeaderConverter();
    }

    @Bean
    RegionConverter regionConverter() {
        return new RegionConverter();
    }

    @ControllerAdvice
    static class S3MockExceptionHandler
    extends ResponseEntityExceptionHandler {
        private static final Logger LOG = LoggerFactory.getLogger(S3MockExceptionHandler.class);

        S3MockExceptionHandler() {
        }

        @ExceptionHandler(value={S3Exception.class})
        public ResponseEntity<ErrorResponse> handleS3Exception(S3Exception s3Exception) {
            LOG.debug("Responding with status {}: {}", new Object[]{s3Exception.getStatus(), s3Exception.getMessage(), s3Exception});
            ErrorResponse errorResponse = new ErrorResponse(s3Exception.getCode(), s3Exception.getMessage(), null, null);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_XML);
            if (s3Exception == S3Exception.NO_SUCH_KEY_DELETE_MARKER) {
                headers.set("x-amz-delete-marker", "true");
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)s3Exception.getStatus()).headers(headers)).body((Object)errorResponse);
        }
    }

    @ControllerAdvice
    static class IllegalStateExceptionHandler
    extends ResponseEntityExceptionHandler {
        private static final Logger LOG = LoggerFactory.getLogger(IllegalStateExceptionHandler.class);

        IllegalStateExceptionHandler() {
        }

        @ExceptionHandler(value={IllegalStateException.class})
        public ResponseEntity<ErrorResponse> handleS3Exception(IllegalStateException exception) {
            LOG.debug("Responding with status {}: {}", new Object[]{HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage(), exception});
            ErrorResponse errorResponse = new ErrorResponse("InternalError", "We encountered an internal error. Please try again.", null, null);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_XML);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.internalServerError().headers(headers)).body((Object)errorResponse);
        }
    }
}

