/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.S3Verified;
import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.ChecksumType;
import com.adobe.testing.s3mock.dto.CompleteMultipartUpload;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CopyPartResult;
import com.adobe.testing.s3mock.dto.CopySource;
import com.adobe.testing.s3mock.dto.InitiateMultipartUploadResult;
import com.adobe.testing.s3mock.dto.ListMultipartUploadsResult;
import com.adobe.testing.s3mock.dto.ListPartsResult;
import com.adobe.testing.s3mock.dto.ObjectKey;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.service.BucketService;
import com.adobe.testing.s3mock.service.MultipartService;
import com.adobe.testing.s3mock.service.ObjectService;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.HeaderUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@CrossOrigin(origins={"*"}, exposedHeaders={"*"})
@Controller
@RequestMapping(value={"${com.adobe.testing.s3mock.contextPath:}"})
public class MultipartController {
    private final BucketService bucketService;
    private final ObjectService objectService;
    private final MultipartService multipartService;

    public MultipartController(BucketService bucketService, ObjectService objectService, MultipartService multipartService) {
        this.bucketService = bucketService;
        this.objectService = objectService;
        this.multipartService = multipartService;
    }

    @GetMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"uploads"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<ListMultipartUploadsResult> listMultipartUploads(@PathVariable String bucketName, @RequestParam(required=false) String delimiter, @RequestParam(name="encoding-type", required=false) String encodingType, @RequestParam(name="key-marker", required=false) String keyMarker, @RequestParam(name="max-uploads", defaultValue="1000", required=false) Integer maxUploads, @RequestParam(required=false) String prefix, @RequestParam(name="upload-id-marker", required=false) String uploadIdMarker) {
        this.bucketService.verifyBucketExists(bucketName);
        return ResponseEntity.ok((Object)this.multipartService.listMultipartUploads(bucketName, delimiter, encodingType, keyMarker, maxUploads, prefix, uploadIdMarker));
    }

    @DeleteMapping(value={"/{bucketName:.+}/{*key}"}, params={"uploadId", "!lifecycle"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> abortMultipartUpload(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam String uploadId) {
        this.bucketService.verifyBucketExists(bucketName);
        this.multipartService.verifyMultipartUploadExists(bucketName, uploadId);
        this.multipartService.abortMultipartUpload(bucketName, key.key(), uploadId);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"uploadId"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<ListPartsResult> listParts(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam(name="max-parts", defaultValue="1000", required=false) Integer maxParts, @RequestParam(name="part-number-marker", required=false) Integer partNumberMarker, @RequestParam String uploadId) {
        this.bucketService.verifyBucketExists(bucketName);
        this.multipartService.verifyMultipartUploadExists(bucketName, uploadId);
        return ResponseEntity.ok((Object)this.multipartService.getMultipartUploadParts(bucketName, key.key(), maxParts, partNumberMarker, uploadId));
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"uploadId", "partNumber"}, headers={"!x-amz-copy-source", "!x-amz-copy-source-range"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> uploadPart(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam String uploadId, @RequestParam String partNumber, @RequestHeader HttpHeaders httpHeaders, InputStream inputStream) {
        ChecksumAlgorithm algorithmFromHeader;
        Pair tempFileAndChecksum = this.multipartService.toTempFile(inputStream, httpHeaders);
        this.bucketService.verifyBucketExists(bucketName);
        this.multipartService.verifyMultipartUploadExists(bucketName, uploadId);
        this.multipartService.verifyPartNumberLimits(partNumber);
        String checksum = null;
        ChecksumAlgorithm checksumAlgorithm = null;
        ChecksumAlgorithm algorithmFromSdk = HeaderUtil.checksumAlgorithmFromSdk(httpHeaders);
        if (algorithmFromSdk != null) {
            checksum = (String)tempFileAndChecksum.getRight();
            checksumAlgorithm = algorithmFromSdk;
        }
        if ((algorithmFromHeader = HeaderUtil.checksumAlgorithmFromHeader(httpHeaders)) != null) {
            checksum = HeaderUtil.checksumFrom(httpHeaders);
            checksumAlgorithm = algorithmFromHeader;
        }
        Path tempFile = (Path)tempFileAndChecksum.getLeft();
        if (checksum != null) {
            this.multipartService.verifyChecksum(tempFile, checksum, checksumAlgorithm);
        }
        String etag = this.multipartService.putPart(bucketName, key.key(), uploadId, partNumber, tempFile, HeaderUtil.encryptionHeadersFrom(httpHeaders));
        FileUtils.deleteQuietly((File)tempFile.toFile());
        Map<String, String> checksumHeader = HeaderUtil.checksumHeaderFrom(checksum, checksumAlgorithm);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> h.setAll(checksumHeader))).headers(h -> h.setAll(HeaderUtil.encryptionHeadersFrom(httpHeaders)))).eTag("\"" + etag + "\"")).build();
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, headers={"x-amz-copy-source"}, params={"uploadId", "partNumber"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<CopyPartResult> uploadPartCopy(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="x-amz-copy-source") CopySource copySource, @RequestHeader(value="x-amz-copy-source-range", required=false) HttpRange copyRange, @RequestHeader(value="x-amz-copy-source-if-match", required=false) List<String> match, @RequestHeader(value="x-amz-copy-source-if-none-match", required=false) List<String> noneMatch, @RequestHeader(value="x-amz-copy-source-if-modified-since", required=false) List<Instant> ifModifiedSince, @RequestHeader(value="x-amz-copy-source-if-unmodified-since", required=false) List<Instant> ifUnmodifiedSince, @RequestParam String uploadId, @RequestParam String partNumber, @RequestHeader HttpHeaders httpHeaders) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        this.multipartService.verifyPartNumberLimits(partNumber);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(copySource.bucket(), copySource.key(), copySource.versionId());
        this.objectService.verifyObjectMatchingForCopy(match, noneMatch, ifModifiedSince, ifUnmodifiedSince, s3ObjectMetadata);
        Map<String, String> encryptionHeaders = HeaderUtil.encryptionHeadersFrom(httpHeaders);
        CopyPartResult result = this.multipartService.copyPart(copySource.bucket(), copySource.key(), copyRange, partNumber, bucketName, key.key(), uploadId, encryptionHeaders, copySource.versionId());
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).headers(h -> {
            if (encryptionHeaders != null) {
                h.setAll(encryptionHeaders);
            }
        })).body((Object)result);
    }

    @PostMapping(value={"/{bucketName:.+}/{*key}"}, params={"uploads"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<InitiateMultipartUploadResult> createMultipartUpload(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="Content-Type", required=false) @Nullable String contentType, @RequestHeader(value="x-amz-checksum-type", required=false) @Nullable ChecksumType checksumType, @RequestHeader(value="x-amz-tagging", required=false) @Nullable List<Tag> tags, @RequestHeader(value="x-amz-storage-class", required=false, defaultValue="STANDARD") StorageClass storageClass, @RequestHeader HttpHeaders httpHeaders, InputStream inputStream) {
        this.bucketService.verifyBucketExists(bucketName);
        try {
            IOUtils.consume((InputStream)inputStream);
        }
        catch (IOException e) {
            throw S3Exception.BAD_REQUEST_CONTENT;
        }
        Map<String, String> encryptionHeaders = HeaderUtil.encryptionHeadersFrom(httpHeaders);
        ChecksumAlgorithm checksumAlgorithm = HeaderUtil.checksumAlgorithmFromHeader(httpHeaders);
        InitiateMultipartUploadResult result = this.multipartService.createMultipartUpload(bucketName, key.key(), contentType, HeaderUtil.storeHeadersFrom(httpHeaders), Owner.DEFAULT_OWNER, Owner.DEFAULT_OWNER, HeaderUtil.userMetadataFrom(httpHeaders), encryptionHeaders, tags, storageClass, checksumType, checksumAlgorithm);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> {
            if (encryptionHeaders != null) {
                h.setAll(encryptionHeaders);
            }
        })).headers(h -> {
            if (checksumAlgorithm != null) {
                h.set("x-amz-checksum-algorithm", checksumAlgorithm.toString());
            }
        })).headers(h -> {
            if (checksumType != null) {
                h.set("x-amz-checksum-type", checksumType.toString());
            }
        })).body((Object)result);
    }

    @PostMapping(value={"/{bucketName:.+}/{*key}"}, params={"uploadId"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<CompleteMultipartUploadResult> completeMultipartUpload(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="If-Match", required=false) List<String> match, @RequestHeader(value="If-None-Match", required=false) List<String> noneMatch, @RequestParam String uploadId, @RequestBody CompleteMultipartUpload upload, HttpServletRequest request, @RequestHeader HttpHeaders httpHeaders) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        this.multipartService.verifyMultipartUploadExists(bucketName, uploadId);
        this.multipartService.verifyMultipartParts(bucketName, key.key(), uploadId, upload.parts());
        S3ObjectMetadata s3ObjectMetadata = this.objectService.getObject(bucketName, key.key(), null);
        this.objectService.verifyObjectMatching(match, noneMatch, null, null, s3ObjectMetadata);
        String objectName = key.key();
        String locationWithEncodedKey = request.getRequestURL().toString().replace(objectName, SdkHttpUtils.urlEncode((String)objectName));
        CompleteMultipartUploadResult result = this.multipartService.completeMultipartUpload(bucketName, key.key(), uploadId, upload.parts(), HeaderUtil.encryptionHeadersFrom(httpHeaders), locationWithEncodedKey, HeaderUtil.checksumFrom(httpHeaders), HeaderUtil.checksumAlgorithmFromHeader(httpHeaders));
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> {
            if (result.multipartUploadInfo().encryptionHeaders() != null) {
                h.setAll(result.multipartUploadInfo().encryptionHeaders());
            }
        })).headers(h -> {
            if (bucket.isVersioningEnabled() && result.versionId() != null) {
                h.set("x-amz-version-id", result.versionId());
            }
        })).body((Object)result);
    }
}

