/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.service;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.Bucket;
import com.adobe.testing.s3mock.dto.BucketLifecycleConfiguration;
import com.adobe.testing.s3mock.dto.ListAllMyBucketsResult;
import com.adobe.testing.s3mock.dto.ListBucketResult;
import com.adobe.testing.s3mock.dto.ListBucketResultV2;
import com.adobe.testing.s3mock.dto.ObjectLockConfiguration;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.S3Object;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.ObjectStore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public class BucketService {
    private final Map<String, String> listObjectsPagingStateCache = new ConcurrentHashMap<String, String>();
    private final BucketStore bucketStore;
    private final ObjectStore objectStore;

    public BucketService(BucketStore bucketStore, ObjectStore objectStore) {
        this.bucketStore = bucketStore;
        this.objectStore = objectStore;
    }

    public boolean isBucketEmpty(String bucketName) {
        return this.bucketStore.isBucketEmpty(bucketName);
    }

    public boolean doesBucketExist(String bucketName) {
        return this.bucketStore.doesBucketExist(bucketName);
    }

    public ListAllMyBucketsResult listBuckets() {
        List<Bucket> buckets = this.bucketStore.listBuckets().stream().filter(Objects::nonNull).map(Bucket::from).collect(Collectors.toList());
        return new ListAllMyBucketsResult(Owner.DEFAULT_OWNER, buckets);
    }

    public Bucket getBucket(String bucketName) {
        return Bucket.from(this.bucketStore.getBucketMetadata(bucketName));
    }

    public Bucket createBucket(String bucketName, boolean objectLockEnabled) {
        return Bucket.from(this.bucketStore.createBucket(bucketName, objectLockEnabled));
    }

    public boolean deleteBucket(String bucketName) {
        return this.bucketStore.deleteBucket(bucketName);
    }

    public void setObjectLockConfiguration(String bucketName, ObjectLockConfiguration configuration) {
        this.bucketStore.storeObjectLockConfiguration(bucketName, configuration);
    }

    public ObjectLockConfiguration getObjectLockConfiguration(String bucketName) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        ObjectLockConfiguration objectLockConfiguration = bucketMetadata.getObjectLockConfiguration();
        if (objectLockConfiguration != null) {
            return objectLockConfiguration;
        }
        throw S3Exception.NOT_FOUND_BUCKET_OBJECT_LOCK;
    }

    public void setBucketLifecycleConfiguration(String bucketName, BucketLifecycleConfiguration configuration) {
        this.bucketStore.storeBucketLifecycleConfiguration(bucketName, configuration);
    }

    public void deleteBucketLifecycleConfiguration(String bucketName) {
        this.setBucketLifecycleConfiguration(bucketName, null);
    }

    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        BucketLifecycleConfiguration configuration = bucketMetadata.getBucketLifecycleConfiguration();
        if (configuration != null) {
            return configuration;
        }
        throw S3Exception.NO_SUCH_LIFECYCLE_CONFIGURATION;
    }

    public List<S3Object> getS3Objects(String bucketName, String prefix) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        List<UUID> uuids = this.bucketStore.lookupKeysInBucket(prefix, bucketName);
        return uuids.stream().map(uuid -> this.objectStore.getS3ObjectMetadata(bucketMetadata, (UUID)uuid)).filter(Objects::nonNull).map(S3Object::from).sorted(Comparator.comparing(S3Object::getKey)).collect(Collectors.toList());
    }

    public ListBucketResultV2 listObjectsV2(String bucketName, String prefix, String delimiter, String encodingType, String startAfter, Integer maxKeys, String continuationToken) {
        List<S3Object> contents = this.getS3Objects(bucketName, prefix);
        String nextContinuationToken = null;
        boolean isTruncated = false;
        if (continuationToken != null) {
            String continueAfter = this.listObjectsPagingStateCache.get(continuationToken);
            contents = BucketService.filterObjectsBy(contents, continueAfter);
            this.listObjectsPagingStateCache.remove(continuationToken);
        } else {
            contents = BucketService.filterObjectsBy(contents, startAfter);
        }
        List<String> commonPrefixes = BucketService.collapseCommonPrefixes(prefix, delimiter, contents);
        contents = BucketService.filterObjectsBy(contents, commonPrefixes);
        if (contents.size() > maxKeys) {
            isTruncated = true;
            nextContinuationToken = UUID.randomUUID().toString();
            contents = contents.subList(0, maxKeys);
            this.listObjectsPagingStateCache.put(nextContinuationToken, contents.get(maxKeys - 1).getKey());
        }
        String returnPrefix = prefix;
        String returnStartAfter = startAfter;
        List<String> returnCommonPrefixes = commonPrefixes;
        if (Objects.equals("url", encodingType)) {
            contents = BucketService.apply(contents, object -> {
                object.setKey(SdkHttpUtils.urlEncodeIgnoreSlashes((String)object.getKey()));
                return object;
            });
            returnPrefix = SdkHttpUtils.urlEncodeIgnoreSlashes((String)prefix);
            returnStartAfter = SdkHttpUtils.urlEncodeIgnoreSlashes((String)startAfter);
            returnCommonPrefixes = BucketService.apply(commonPrefixes, SdkHttpUtils::urlEncodeIgnoreSlashes);
        }
        return new ListBucketResultV2(bucketName, returnPrefix, maxKeys, isTruncated, contents, returnCommonPrefixes, continuationToken, String.valueOf(contents.size()), nextContinuationToken, returnStartAfter, encodingType);
    }

    @Deprecated
    public ListBucketResult listObjectsV1(String bucketName, String prefix, String delimiter, String marker, String encodingType, Integer maxKeys) {
        this.verifyMaxKeys(maxKeys);
        this.verifyEncodingType(encodingType);
        List<S3Object> contents = this.getS3Objects(bucketName, prefix);
        contents = BucketService.filterObjectsBy(contents, marker);
        boolean isTruncated = false;
        String nextMarker = null;
        List<String> commonPrefixes = BucketService.collapseCommonPrefixes(prefix, delimiter, contents);
        contents = BucketService.filterObjectsBy(contents, commonPrefixes);
        if (maxKeys < contents.size()) {
            contents = contents.subList(0, maxKeys);
            isTruncated = true;
            if (maxKeys > 0) {
                nextMarker = contents.get(maxKeys - 1).getKey();
            }
        }
        String returnPrefix = prefix;
        List<String> returnCommonPrefixes = commonPrefixes;
        if (Objects.equals("url", encodingType)) {
            contents = BucketService.apply(contents, object -> {
                object.setKey(SdkHttpUtils.urlEncodeIgnoreSlashes((String)object.getKey()));
                return object;
            });
            returnPrefix = SdkHttpUtils.urlEncodeIgnoreSlashes((String)prefix);
            returnCommonPrefixes = BucketService.apply(commonPrefixes, SdkHttpUtils::urlEncodeIgnoreSlashes);
        }
        return new ListBucketResult(bucketName, returnPrefix, marker, maxKeys, isTruncated, encodingType, nextMarker, contents, returnCommonPrefixes);
    }

    public void verifyBucketExists(String bucketName) {
        if (!this.bucketStore.doesBucketExist(bucketName).booleanValue()) {
            throw S3Exception.NO_SUCH_BUCKET;
        }
    }

    public void verifyBucketObjectLockEnabled(String bucketName) {
        if (!this.bucketStore.isObjectLockEnabled(bucketName).booleanValue()) {
            throw S3Exception.NOT_FOUND_BUCKET_OBJECT_LOCK;
        }
    }

    public void verifyBucketNameIsAllowed(String bucketName) {
        if (!bucketName.matches("[a-z0-9.-]+")) {
            throw S3Exception.INVALID_BUCKET_NAME;
        }
    }

    public void verifyBucketIsEmpty(String bucketName) {
        if (!this.bucketStore.isBucketEmpty(bucketName)) {
            throw S3Exception.BUCKET_NOT_EMPTY;
        }
    }

    public void verifyBucketDoesNotExist(String bucketName) {
        if (this.bucketStore.doesBucketExist(bucketName).booleanValue()) {
            throw S3Exception.BUCKET_ALREADY_EXISTS;
        }
    }

    public void verifyMaxKeys(Integer maxKeys) {
        if (maxKeys < 0) {
            throw S3Exception.INVALID_REQUEST_MAXKEYS;
        }
    }

    public void verifyEncodingType(String encodingType) {
        if (StringUtils.isNotEmpty((CharSequence)encodingType) && !"url".equals(encodingType)) {
            throw S3Exception.INVALID_REQUEST_ENCODINGTYPE;
        }
    }

    static List<String> collapseCommonPrefixes(String queryPrefix, String delimiter, List<S3Object> s3Objects) {
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)delimiter)) {
            return commonPrefixes;
        }
        String normalizedQueryPrefix = queryPrefix == null ? "" : queryPrefix;
        for (S3Object c : s3Objects) {
            String commonPrefix;
            int delimiterIndex;
            String key = c.getKey();
            if (!key.startsWith(normalizedQueryPrefix) || (delimiterIndex = key.indexOf(delimiter, normalizedQueryPrefix.length())) <= 0 || commonPrefixes.contains(commonPrefix = key.substring(0, delimiterIndex + delimiter.length()))) continue;
            commonPrefixes.add(commonPrefix);
        }
        return commonPrefixes;
    }

    private static <T> List<T> apply(List<T> contents, Function<T, T> extractor) {
        return contents.stream().map(extractor).collect(Collectors.toList());
    }

    static List<S3Object> filterObjectsBy(List<S3Object> s3Objects, String startAfter) {
        if (StringUtils.isNotEmpty((CharSequence)startAfter)) {
            return s3Objects.stream().filter(p -> p.getKey().compareTo(startAfter) > 0).collect(Collectors.toList());
        }
        return s3Objects;
    }

    static List<S3Object> filterObjectsBy(List<S3Object> s3Objects, List<String> commonPrefixes) {
        if (commonPrefixes != null && !commonPrefixes.isEmpty()) {
            return s3Objects.stream().filter(c -> commonPrefixes.stream().noneMatch(p -> c.getKey().startsWith((String)p))).collect(Collectors.toList());
        }
        return s3Objects;
    }
}

