/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.dto.AccessControlPolicy;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.CopySource;
import com.adobe.testing.s3mock.dto.Delete;
import com.adobe.testing.s3mock.dto.DeleteResult;
import com.adobe.testing.s3mock.dto.LegalHold;
import com.adobe.testing.s3mock.dto.ObjectKey;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Range;
import com.adobe.testing.s3mock.dto.Retention;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.dto.Tagging;
import com.adobe.testing.s3mock.service.BucketService;
import com.adobe.testing.s3mock.service.ObjectService;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.AwsHttpHeaders;
import com.adobe.testing.s3mock.util.HeaderUtil;
import com.adobe.testing.s3mock.util.XmlUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@CrossOrigin(origins={"*"})
@RequestMapping(value={"${com.adobe.testing.s3mock.contextPath:}"})
public class ObjectController {
    private static final String RANGES_BYTES = "bytes";
    private final BucketService bucketService;
    private final ObjectService objectService;

    public ObjectController(BucketService bucketService, ObjectService objectService) {
        this.bucketService = bucketService;
        this.objectService = objectService;
    }

    @RequestMapping(value={"/{bucketName:.+}"}, params={"delete"}, method={RequestMethod.POST}, produces={"application/xml"})
    public ResponseEntity<DeleteResult> deleteObjects(@PathVariable String bucketName, @RequestBody Delete body) {
        this.bucketService.verifyBucketExists(bucketName);
        DeleteResult response = this.objectService.deleteObjects(bucketName, body);
        return ResponseEntity.ok((Object)response);
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> headObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="If-Match", required=false) List<String> match, @RequestHeader(value="If-None-Match", required=false) List<String> noneMatch) {
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.getKey());
        if (s3ObjectMetadata != null) {
            this.objectService.verifyObjectMatching(match, noneMatch, s3ObjectMetadata);
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers -> headers.setAll(HeaderUtil.createUserMetadataHeaders(s3ObjectMetadata)))).headers(headers -> headers.setAll(HeaderUtil.createEncryptionHeaders(s3ObjectMetadata)))).contentType(HeaderUtil.parseMediaType(s3ObjectMetadata.getContentType())).eTag(s3ObjectMetadata.getEtag())).contentLength(Long.parseLong(s3ObjectMetadata.getSize())).lastModified(s3ObjectMetadata.getLastModified())).build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, params={"!lifecycle"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteObject(@PathVariable String bucketName, @PathVariable ObjectKey key) {
        this.bucketService.verifyBucketExists(bucketName);
        boolean deleted = this.objectService.deleteObject(bucketName, key.getKey());
        return ResponseEntity.noContent().header("x-amz-delete-marker", new String[]{String.valueOf(deleted)}).build();
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, params={"!uploads", "!uploadId", "!tagging", "!legal-hold", "!retention", "!acl"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<StreamingResponseBody> getObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="Range", required=false) Range range, @RequestHeader(value="If-Match", required=false) List<String> match, @RequestHeader(value="If-None-Match", required=false) List<String> noneMatch, @RequestParam Map<String, String> queryParams) {
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.getKey());
        this.objectService.verifyObjectMatching(match, noneMatch, s3ObjectMetadata);
        if (range != null) {
            return this.getObjectWithRange(range, s3ObjectMetadata);
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.getEtag())).header("Content-Encoding", new String[]{s3ObjectMetadata.getContentEncoding()})).header("Accept-Ranges", new String[]{RANGES_BYTES})).headers(headers -> headers.setAll(HeaderUtil.createUserMetadataHeaders(s3ObjectMetadata)))).headers(headers -> headers.setAll(HeaderUtil.createEncryptionHeaders(s3ObjectMetadata)))).lastModified(s3ObjectMetadata.getLastModified())).contentLength(s3ObjectMetadata.getDataPath().toFile().length()).contentType(HeaderUtil.parseMediaType(s3ObjectMetadata.getContentType())).headers(headers -> headers.setAll(HeaderUtil.createOverrideHeaders(queryParams)))).body(outputStream -> Files.copy(s3ObjectMetadata.getDataPath(), outputStream));
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, params={"acl"}, method={RequestMethod.PUT}, consumes={"application/xml"})
    public ResponseEntity<Void> putObjectAcl(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestBody String body) throws XMLStreamException, JAXBException {
        this.bucketService.verifyBucketExists(bucketName);
        this.objectService.verifyObjectExists(bucketName, key.getKey());
        AccessControlPolicy policy = XmlUtil.deserializeJaxb(body);
        this.objectService.setAcl(bucketName, key.getKey(), policy);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, params={"acl"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<String> getObjectAcl(@PathVariable String bucketName, @PathVariable ObjectKey key) throws JAXBException {
        this.bucketService.verifyBucketExists(bucketName);
        this.objectService.verifyObjectExists(bucketName, key.getKey());
        AccessControlPolicy acl = this.objectService.getAcl(bucketName, key.getKey());
        return ResponseEntity.ok((Object)XmlUtil.serializeJaxb(acl));
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, params={"tagging"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<Tagging> getObjectTagging(@PathVariable String bucketName, @PathVariable ObjectKey key) {
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.getKey());
        ArrayList<Tag> tagList = new ArrayList<Tag>(s3ObjectMetadata.getTags());
        Tagging result = new Tagging(tagList);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.getEtag())).lastModified(s3ObjectMetadata.getLastModified())).body((Object)result);
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, params={"tagging"}, method={RequestMethod.PUT}, consumes={"application/xml"})
    public ResponseEntity<String> putObjectTagging(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestBody Tagging body) {
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.getKey());
        this.objectService.setObjectTags(bucketName, key.getKey(), body.getTagSet());
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.getEtag())).lastModified(s3ObjectMetadata.getLastModified())).build();
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, params={"legal-hold"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<LegalHold> getLegalHold(@PathVariable String bucketName, @PathVariable ObjectKey key) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectLockConfiguration(bucketName, key.getKey());
        return ResponseEntity.ok().body((Object)s3ObjectMetadata.getLegalHold());
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, params={"legal-hold"}, method={RequestMethod.PUT}, consumes={"application/xml"})
    public ResponseEntity<String> putLegalHold(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestBody LegalHold body) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        this.objectService.verifyObjectExists(bucketName, key.getKey());
        this.objectService.setLegalHold(bucketName, key.getKey(), body);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, params={"retention"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<Retention> getObjectRetention(@PathVariable String bucketName, @PathVariable ObjectKey key) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectLockConfiguration(bucketName, key.getKey());
        return ResponseEntity.ok().body((Object)s3ObjectMetadata.getRetention());
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, params={"retention"}, method={RequestMethod.PUT}, consumes={"application/xml"})
    public ResponseEntity<Void> putObjectRetention(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestBody Retention body) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        this.objectService.verifyObjectExists(bucketName, key.getKey());
        this.objectService.verifyRetention(body);
        this.objectService.setRetention(bucketName, key.getKey(), body);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(params={"!uploadId", "!tagging", "!legal-hold", "!retention", "!acl"}, headers={"!x-amz-copy-source"}, value={"/{bucketName:.+}/{*key}"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> putObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="x-amz-server-side-encryption", required=false) String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, @RequestHeader(name="x-amz-tagging", required=false) List<Tag> tags, @RequestHeader(value="Content-Encoding", required=false) String contentEncoding, @RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="Content-MD5", required=false) String contentMd5, @RequestHeader(value="x-amz-content-sha256", required=false) String sha256Header, @RequestHeader HttpHeaders headers, InputStream inputStream) {
        this.bucketService.verifyBucketExists(bucketName);
        InputStream stream = this.objectService.verifyMd5(inputStream, contentMd5, sha256Header);
        Owner owner = Owner.DEFAULT_OWNER;
        Map<String, String> userMetadata = HeaderUtil.getUserMetadata(headers);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.putS3Object(bucketName, key.getKey(), HeaderUtil.parseMediaType(contentType).toString(), contentEncoding, stream, HeaderUtil.isV4ChunkedWithSigningEnabled(sha256Header), userMetadata, encryption, kmsKeyId, tags, owner);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.getEtag())).lastModified(s3ObjectMetadata.getLastModified())).header("x-amz-server-side-encryption-aws-kms-key-id", new String[]{kmsKeyId})).build();
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, headers={"x-amz-copy-source"}, params={"!uploadId", "!tagging", "!legal-hold", "!retention", "!acl"}, method={RequestMethod.PUT}, produces={"application/xml"})
    public ResponseEntity<CopyObjectResult> copyObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="x-amz-copy-source") CopySource copySource, @RequestHeader(value="x-amz-metadata-directive", defaultValue="COPY") AwsHttpHeaders.MetadataDirective metadataDirective, @RequestHeader(value="x-amz-server-side-encryption", required=false) String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, @RequestHeader(value="x-amz-copy-source-if-match", required=false) List<String> match, @RequestHeader(value="x-amz-copy-source-if-none-match", required=false) List<String> noneMatch, @RequestHeader HttpHeaders httpHeaders) {
        CopyObjectResult copyObjectResult;
        this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(copySource.getBucket(), copySource.getKey());
        this.objectService.verifyObjectMatchingForCopy(match, noneMatch, s3ObjectMetadata);
        Map<String, String> metadata = Collections.emptyMap();
        if (AwsHttpHeaders.MetadataDirective.REPLACE == metadataDirective) {
            metadata = HeaderUtil.getUserMetadata(httpHeaders);
        }
        if ((copyObjectResult = this.objectService.copyS3Object(copySource.getBucket(), copySource.getKey(), bucketName, key.getKey(), encryption, kmsKeyId, metadata)) == null) {
            return ResponseEntity.notFound().header("x-amz-server-side-encryption-aws-kms-key-id", new String[]{kmsKeyId}).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("x-amz-server-side-encryption-aws-kms-key-id", new String[]{kmsKeyId})).body((Object)copyObjectResult);
    }

    private ResponseEntity<StreamingResponseBody> getObjectWithRange(Range range, S3ObjectMetadata s3ObjectMetadata) {
        long fileSize = s3ObjectMetadata.getDataPath().toFile().length();
        long bytesToRead = Math.min(fileSize - 1L, range.getEnd()) - range.getStart() + 1L;
        if (bytesToRead < 0L || fileSize < range.getStart()) {
            return ResponseEntity.status((int)HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE.value()).build();
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((int)HttpStatus.PARTIAL_CONTENT.value()).headers(headers -> headers.setAll(HeaderUtil.createUserMetadataHeaders(s3ObjectMetadata)))).headers(headers -> headers.setAll(HeaderUtil.createEncryptionHeaders(s3ObjectMetadata)))).header("Accept-Ranges", new String[]{RANGES_BYTES})).header("Content-Range", new String[]{String.format("bytes %s-%s/%s", range.getStart(), bytesToRead + range.getStart() - 1L, s3ObjectMetadata.getSize())})).eTag(s3ObjectMetadata.getEtag())).contentType(HeaderUtil.parseMediaType(s3ObjectMetadata.getContentType())).lastModified(s3ObjectMetadata.getLastModified())).contentLength(bytesToRead).body(outputStream -> {
            block7: {
                try (InputStream fis = Files.newInputStream(s3ObjectMetadata.getDataPath(), new OpenOption[0]);){
                    long skip = fis.skip(range.getStart());
                    if (skip == range.getStart()) {
                        IOUtils.copy((InputStream)new BoundedInputStream(fis, bytesToRead), (OutputStream)outputStream);
                        break block7;
                    }
                    throw new IllegalStateException("Could not skip exact byte range");
                }
            }
        });
    }
}

