/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.domain.Bucket;
import com.adobe.testing.s3mock.domain.BucketContents;
import com.adobe.testing.s3mock.domain.FileStore;
import com.adobe.testing.s3mock.domain.S3Exception;
import com.adobe.testing.s3mock.domain.S3Object;
import com.adobe.testing.s3mock.domain.Tag;
import com.adobe.testing.s3mock.dto.BatchDeleteRequest;
import com.adobe.testing.s3mock.dto.BatchDeleteResponse;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadRequest;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.CopyPartResult;
import com.adobe.testing.s3mock.dto.DeletedObject;
import com.adobe.testing.s3mock.dto.InitiateMultipartUploadResult;
import com.adobe.testing.s3mock.dto.ListAllMyBucketsResult;
import com.adobe.testing.s3mock.dto.ListBucketResult;
import com.adobe.testing.s3mock.dto.ListBucketResultV2;
import com.adobe.testing.s3mock.dto.ListMultipartUploadsResult;
import com.adobe.testing.s3mock.dto.ListPartsResult;
import com.adobe.testing.s3mock.dto.MultipartUpload;
import com.adobe.testing.s3mock.dto.ObjectRef;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Part;
import com.adobe.testing.s3mock.dto.Range;
import com.adobe.testing.s3mock.dto.Tagging;
import com.adobe.testing.s3mock.util.MetadataUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
class FileStoreController {
    private static final String ANY = "*";
    private static final String RANGES_BYTES = "bytes";
    private static final String STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final String RESPONSE_HEADER_CONTENT_TYPE = "response-content-type";
    private static final String RESPONSE_HEADER_CONTENT_LANGUAGE = "response-content-language";
    private static final String RESPONSE_HEADER_EXPIRES = "response-expires";
    private static final String RESPONSE_HEADER_CACHE_CONTROL = "response-cache-control";
    private static final String RESPONSE_HEADER_CONTENT_DISPOSITION = "response-content-disposition";
    private static final String RESPONSE_HEADER_CONTENT_ENCODING = "response-content-encoding";
    private static final String HEADER_X_AMZ_CONTENT_SHA256 = "x-amz-content-sha256";
    private static final String HEADER_X_AMZ_TAGGING = "x-amz-tagging";
    private static final String ABSENT_ENCRYPTION = null;
    private static final String ABSENT_KEY_ID = null;
    private static final String METADATA_DIRECTIVE_COPY = "COPY";
    private static final String METADATA_DIRECTIVE_REPLACE = "REPLACE";
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreController.class);
    private static final Owner TEST_OWNER = new Owner(123L, "s3-mock-file-store");
    private static final Comparator<String> KEY_COMPARATOR = Comparator.naturalOrder();
    private static final Comparator<BucketContents> BUCKET_CONTENTS_COMPARATOR = Comparator.comparing(BucketContents::getKey, KEY_COMPARATOR);
    private static final MediaType FALLBACK_MEDIA_TYPE = new MediaType("binary", "octet-stream");
    @Autowired
    private FileStore fileStore;
    @Autowired
    private Cache fileStorePagingStateCache;

    FileStoreController() {
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseBody
    public ListAllMyBucketsResult listBuckets() {
        return new ListAllMyBucketsResult(TEST_OWNER, this.fileStore.listBuckets());
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.PUT})
    public ResponseEntity<String> putBucket(@PathVariable String bucketName) {
        try {
            this.fileStore.createBucket(bucketName);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (IOException e) {
            LOG.error("Bucket could not be created!", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.HEAD})
    public ResponseEntity<String> headBucket(@PathVariable String bucketName) {
        if (this.fileStore.doesBucketExist(bucketName).booleanValue()) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteBucket(@PathVariable String bucketName) {
        boolean deleted;
        this.verifyBucketExistence(bucketName);
        try {
            if (!this.fileStore.getS3Objects(bucketName, null).isEmpty()) {
                throw new S3Exception(HttpStatus.CONFLICT.value(), "BucketNotEmpty", "The bucket you tried to delete is not empty.");
            }
            deleted = this.fileStore.deleteBucket(bucketName);
        }
        catch (IOException e) {
            LOG.error("Bucket could not be deleted!", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (deleted) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.HEAD})
    public ResponseEntity<String> headObject(@PathVariable String bucketName, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        S3Object s3Object = this.fileStore.getS3Object(bucketName, filename);
        if (s3Object != null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentLength(Long.parseLong(s3Object.getSize()));
            responseHeaders.setContentType(this.parseMediaType(s3Object.getContentType()));
            responseHeaders.setETag("\"" + s3Object.getMd5() + "\"");
            responseHeaders.setLastModified(s3Object.getLastModified());
            if (s3Object.isEncrypted()) {
                responseHeaders.add("x-amz-server-side-encryption-aws-kms-key-id", s3Object.getKmsKeyId());
            }
            MetadataUtil.addUserMetadata((arg_0, arg_1) -> ((HttpHeaders)responseHeaders).add(arg_0, arg_1), s3Object);
            return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseBody
    public ListBucketResult listObjectsInsideBucket(@PathVariable String bucketName, @RequestParam(required=false) String prefix, @RequestParam(required=false) String delimiter, @RequestParam(required=false) String marker, @RequestParam(name="encoding-type", required=false) String encodingtype, @RequestParam(name="max-keys", defaultValue="1000", required=false) Integer maxKeys, HttpServletResponse response) throws IOException {
        this.verifyBucketExistence(bucketName);
        if (maxKeys < 0) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "maxKeys should be non-negative");
        }
        if (!StringUtils.isEmpty((Object)encodingtype) && !"url".equals(encodingtype)) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "encodingtype can only be none or 'url'");
        }
        boolean useUrlEncoding = Objects.equals("url", encodingtype);
        try {
            List<BucketContents> contents = this.getFilteredBucketContents(this.getBucketContents(bucketName, prefix), marker);
            boolean isTruncated = false;
            String nextMarker = null;
            HashSet<String> commonPrefixes = new HashSet<String>();
            if (null != delimiter) {
                this.collapseCommonPrefixes(prefix, delimiter, contents, commonPrefixes);
            }
            if (maxKeys < contents.size()) {
                contents = contents.subList(0, maxKeys);
                isTruncated = true;
                if (maxKeys > 0) {
                    nextMarker = contents.get(maxKeys - 1).getKey();
                }
            }
            if (useUrlEncoding) {
                contents = this.applyUrlEncoding(contents);
            }
            return new ListBucketResult(bucketName, prefix, marker, maxKeys, isTruncated, nextMarker, contents, commonPrefixes);
        }
        catch (IOException e) {
            LOG.error(String.format("Object(s) could not retrieved from bucket %s", bucketName));
            response.sendError(500, e.getMessage());
            return null;
        }
    }

    private List<BucketContents> applyUrlEncoding(List<BucketContents> contents) {
        return contents.stream().map(c -> new BucketContents(UrlEncoded.encodeString((String)c.getKey()), c.getLastModified(), c.getEtag(), c.getSize(), c.getStorageClass(), c.getOwner())).collect(Collectors.toList());
    }

    private void collapseCommonPrefixes(String queryPrefix, String delimiter, List<BucketContents> contents, Set<String> commonPrefixes) {
        String normalizedQueryPrefix = queryPrefix == null ? "" : queryPrefix;
        Iterator<BucketContents> i = contents.iterator();
        while (i.hasNext()) {
            int delimiterIndex;
            BucketContents c = i.next();
            String key = c.getKey();
            if (!key.startsWith(normalizedQueryPrefix) || (delimiterIndex = key.indexOf(delimiter, normalizedQueryPrefix.length())) <= 0) continue;
            commonPrefixes.add(key.substring(0, delimiterIndex + delimiter.length()));
            i.remove();
        }
    }

    @RequestMapping(value={"/{bucketName}"}, params={"list-type=2"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseBody
    public ListBucketResultV2 listObjectsInsideBucketV2(@PathVariable String bucketName, @RequestParam(required=false) String prefix, @RequestParam(required=false) String delimiter, @RequestParam(name="encoding-type", required=false) String encodingtype, @RequestParam(name="start-after", required=false) String startAfter, @RequestParam(name="max-keys", defaultValue="1000", required=false) String maxKeysParam, @RequestParam(name="continuation-token", required=false) String continuationToken, HttpServletResponse response) throws IOException {
        if (!StringUtils.isEmpty((Object)encodingtype) && !"url".equals(encodingtype)) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "encodingtype can only be none or 'url'");
        }
        boolean useUrlEncoding = Objects.equals("url", encodingtype);
        this.verifyBucketExistence(bucketName);
        try {
            List<BucketContents> filteredContents;
            List<BucketContents> contents = this.getBucketContents(bucketName, prefix);
            String nextContinuationToken = null;
            boolean isTruncated = false;
            if (continuationToken != null) {
                String continueAfter = this.fileStorePagingStateCache.get((Object)continuationToken).get().toString();
                filteredContents = this.getFilteredBucketContents(contents, continueAfter);
                this.fileStorePagingStateCache.evict((Object)continuationToken);
            } else {
                filteredContents = this.getFilteredBucketContents(contents, startAfter);
            }
            int maxKeys = Integer.parseInt(maxKeysParam);
            if (filteredContents.size() > maxKeys) {
                isTruncated = true;
                nextContinuationToken = UUID.randomUUID().toString();
                filteredContents = filteredContents.subList(0, maxKeys);
                this.fileStorePagingStateCache.put((Object)nextContinuationToken, (Object)filteredContents.get(maxKeys - 1).getKey());
            }
            HashSet<String> commonPrefixes = new HashSet<String>();
            if (delimiter != null) {
                this.collapseCommonPrefixes(prefix, delimiter, filteredContents, commonPrefixes);
            }
            if (useUrlEncoding) {
                filteredContents = this.applyUrlEncoding(filteredContents);
            }
            return new ListBucketResultV2(bucketName, prefix, maxKeysParam, isTruncated, filteredContents, commonPrefixes, continuationToken, String.valueOf(filteredContents.size()), nextContinuationToken, startAfter);
        }
        catch (IOException e) {
            LOG.error(String.format("Object(s) could not retrieved from bucket %s", bucketName));
            response.sendError(500, e.getMessage());
            return null;
        }
    }

    private List<BucketContents> getFilteredBucketContents(List<BucketContents> contents, String startAfter) {
        if (startAfter != null && !"".equals(startAfter)) {
            return contents.stream().filter(p -> KEY_COMPARATOR.compare(p.getKey(), startAfter) > 0).collect(Collectors.toList());
        }
        return contents;
    }

    private List<BucketContents> getBucketContents(String bucketName, String prefix) throws IOException {
        String encodedPrefix = null != prefix ? FileStoreController.objectNameToFileName(prefix) : null;
        List<S3Object> s3Objects = this.fileStore.getS3Objects(bucketName, encodedPrefix);
        LOG.debug(String.format("Found %s objects in bucket %s", s3Objects.size(), bucketName));
        return s3Objects.stream().map(s3Object -> new BucketContents(FileStoreController.fileNameToObjectName(s3Object.getName()), s3Object.getModificationDate(), s3Object.getMd5(), s3Object.getSize(), "STANDARD", TEST_OWNER)).sorted(BUCKET_CONTENTS_COMPARATOR).collect(Collectors.toList());
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.PUT})
    public ResponseEntity<String> putObject(@PathVariable String bucketName, HttpServletRequest request) {
        ResponseEntity responseEntity;
        block8: {
            this.verifyBucketExistence(bucketName);
            String filename = FileStoreController.filenameFrom(bucketName, request);
            ServletInputStream inputStream = request.getInputStream();
            try {
                Map<String, String> userMetadata = MetadataUtil.getUserMetadata(request);
                S3Object s3Object = this.fileStore.putS3Object(bucketName, filename, request.getContentType(), request.getHeader("Content-Encoding"), (InputStream)inputStream, this.isV4ChunkedWithSigningEnabled(request), userMetadata);
                this.addTagsFromReq(request, bucketName, filename);
                HttpHeaders responseHeaders = new HttpHeaders();
                responseHeaders.setETag("\"" + s3Object.getMd5() + "\"");
                responseHeaders.setLastModified(s3Object.getLastModified());
                MetadataUtil.addUserMetadata((arg_0, arg_1) -> ((HttpHeaders)responseHeaders).add(arg_0, arg_1), s3Object);
                responseEntity = new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.OK);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Object could not be saved!", (Throwable)e);
                    return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            inputStream.close();
        }
        return responseEntity;
    }

    private void addTagsFromReq(HttpServletRequest request, String bucketName, String filename) throws IOException {
        String header = request.getHeader(HEADER_X_AMZ_TAGGING);
        if (header != null && !header.isEmpty()) {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            new UrlEncoded(header).forEach((tag, values) -> tags.add(new Tag((String)tag, (String)values.get(0))));
            this.fileStore.setObjectTags(bucketName, filename, tags);
        }
    }

    private boolean isV4ChunkedWithSigningEnabled(HttpServletRequest request) {
        String sha256Header = request.getHeader(HEADER_X_AMZ_CONTENT_SHA256);
        return sha256Header != null && sha256Header.equals(STREAMING_AWS_4_HMAC_SHA_256_PAYLOAD);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, headers={"x-amz-server-side-encryption", "x-amz-server-side-encryption-aws-kms-key-id", "!x-amz-copy-source"}, method={RequestMethod.PUT})
    public ResponseEntity<String> putObjectEncrypted(@PathVariable String bucketName, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id") String kmsKeyId, HttpServletRequest request) throws IOException {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        try (ServletInputStream inputStream = request.getInputStream();){
            Map<String, String> userMetadata = MetadataUtil.getUserMetadata(request);
            S3Object s3Object = this.fileStore.putS3ObjectWithKMSEncryption(bucketName, filename, request.getContentType(), (InputStream)inputStream, this.isV4ChunkedWithSigningEnabled(request), userMetadata, encryption, kmsKeyId);
            this.addTagsFromReq(request, bucketName, filename);
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setETag("\"" + s3Object.getMd5() + "\"");
            responseHeaders.setLastModified(s3Object.getLastModified());
            responseHeaders.add("x-amz-server-side-encryption-aws-kms-key-id", kmsKeyId);
            ResponseEntity responseEntity = new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.OK);
            return responseEntity;
        }
    }

    @RequestMapping(value={"/{destinationBucket:.+}/**"}, method={RequestMethod.PUT}, headers={"x-amz-copy-source", "!x-amz-server-side-encryption"}, produces={"application/xml; charset=utf-8"})
    @ResponseBody
    public CopyObjectResult copyObject(@PathVariable String destinationBucket, @RequestHeader(value="x-amz-copy-source") ObjectRef objectRef, @RequestHeader(value="x-amz-metadata-directive", defaultValue="COPY") String metadataDirective, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.copyObject(destinationBucket, objectRef, metadataDirective, ABSENT_ENCRYPTION, ABSENT_KEY_ID, request, response);
    }

    @RequestMapping(value={"/{destinationBucket:.+}/**"}, method={RequestMethod.PUT}, headers={"x-amz-copy-source", "x-amz-server-side-encryption"}, produces={"application/xml; charset=utf-8"})
    @ResponseBody
    public CopyObjectResult copyObject(@PathVariable String destinationBucket, @RequestHeader(value="x-amz-copy-source") ObjectRef objectRef, @RequestHeader(value="x-amz-metadata-directive", defaultValue="COPY") String metadataDirective, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.verifyBucketExistence(destinationBucket);
        this.validateMetadataDirective(metadataDirective);
        String destinationFile = FileStoreController.filenameFrom(destinationBucket, request);
        CopyObjectResult copyObjectResult = METADATA_DIRECTIVE_REPLACE.equals(metadataDirective) ? this.fileStore.copyS3ObjectEncrypted(objectRef.getBucket(), FileStoreController.objectNameToFileName(objectRef.getKey()), destinationBucket, destinationFile, encryption, kmsKeyId, MetadataUtil.getUserMetadata(request)) : this.fileStore.copyS3ObjectEncrypted(objectRef.getBucket(), FileStoreController.objectNameToFileName(objectRef.getKey()), destinationBucket, destinationFile, encryption, kmsKeyId);
        response.addHeader("x-amz-server-side-encryption-aws-kms-key-id", kmsKeyId);
        if (copyObjectResult == null) {
            response.sendError(404, String.format("Could not find source File %s in Bucket %s!", objectRef.getBucket(), objectRef.getKey()));
        }
        return copyObjectResult;
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.GET}, produces={"application/xml"})
    public void getObject(@PathVariable String bucketName, @RequestHeader(value="Range", required=false) Range range, @RequestHeader(value="If-Match", required=false) List<String> match, @RequestHeader(value="If-None-Match", required=false) List<String> noMatch, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        S3Object s3Object = this.verifyObjectExistence(bucketName, filename);
        this.verifyObjectMatching(match, noMatch, s3Object.getMd5());
        if (range != null) {
            this.getObjectWithRange(response, range, s3Object);
        } else {
            response.setHeader("ETag", "\"" + s3Object.getMd5() + "\"");
            response.setContentType(s3Object.getContentType());
            response.setHeader("Content-Encoding", s3Object.getContentEncoding());
            response.setContentLengthLong(s3Object.getDataFile().length());
            response.setHeader("Accept-Ranges", RANGES_BYTES);
            response.setHeader("Access-Control-Allow-Origin", ANY);
            response.setDateHeader("Last-Modified", s3Object.getLastModified());
            MetadataUtil.addUserMetadata((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1), s3Object);
            this.addOverrideHeaders(response, request.getQueryString());
            try (ServletOutputStream outputStream = response.getOutputStream();){
                Files.copy(s3Object.getDataFile().toPath(), (OutputStream)outputStream);
            }
        }
    }

    private void addOverrideHeaders(HttpServletResponse response, String query) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)query)) {
            Arrays.stream(query.split("&")).map(this::splitQueryParameter).forEach(h -> this.addOverrideHeader(response, (String)h.getKey(), (String)h.getValue()));
        }
    }

    private AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String param) {
        try {
            String key = URLDecoder.decode(org.apache.commons.lang3.StringUtils.substringBefore((String)param, (String)"="), StandardCharsets.UTF_8.name());
            String value = URLDecoder.decode(org.apache.commons.lang3.StringUtils.substringAfter((String)param, (String)"="), StandardCharsets.UTF_8.name());
            return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)(StandardCharsets.UTF_8.name() + " is unknown"));
        }
    }

    private void addOverrideHeader(HttpServletResponse response, String name, String value) {
        switch (name) {
            case "response-cache-control": {
                response.setHeader("Cache-Control", value);
                break;
            }
            case "response-content-disposition": {
                response.setHeader("Content-Disposition", value);
                break;
            }
            case "response-content-encoding": {
                response.setHeader("Content-Encoding", value);
                break;
            }
            case "response-content-language": {
                response.setHeader("Content-Language", value);
                break;
            }
            case "response-content-type": {
                response.setContentType(value);
                break;
            }
            case "response-expires": {
                response.setHeader("Expires", value);
                break;
            }
        }
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteObject(@PathVariable String bucketName, HttpServletRequest request) {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        try {
            this.fileStore.deleteObject(bucketName, filename);
        }
        catch (IOException e) {
            LOG.error("Object could not be deleted!", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{bucketName}"}, params={"delete"}, method={RequestMethod.POST}, produces={"application/xml"})
    public BatchDeleteResponse batchDeleteObjects(@PathVariable String bucketName, @RequestBody BatchDeleteRequest body) {
        this.verifyBucketExistence(bucketName);
        BatchDeleteResponse response = new BatchDeleteResponse();
        for (BatchDeleteRequest.ObjectToDelete object : body.getObjectsToDelete()) {
            try {
                if (!this.fileStore.deleteObject(bucketName, FileStoreController.objectNameToFileName(object.getKey()))) continue;
                DeletedObject deletedObject = new DeletedObject();
                deletedObject.setKey(object.getKey());
                response.addDeletedObject(deletedObject);
            }
            catch (IOException e) {
                LOG.error("Object could not be deleted!", (Throwable)e);
            }
        }
        return response;
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"tagging"}, method={RequestMethod.GET})
    public ResponseEntity<Tagging> getObjectTagging(@PathVariable String bucketName, HttpServletRequest request) {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        S3Object s3Object = this.verifyObjectExistence(bucketName, filename);
        ArrayList<Tag> tagList = new ArrayList<Tag>(s3Object.getTags());
        Tagging result = new Tagging(tagList);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setETag("\"" + s3Object.getMd5() + "\"");
        responseHeaders.setLastModified(s3Object.getLastModified());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)result);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"tagging"}, method={RequestMethod.PUT})
    public ResponseEntity<String> putObjectTagging(@PathVariable String bucketName, @RequestBody Tagging body, HttpServletRequest request) {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        S3Object s3Object = this.verifyObjectExistence(bucketName, filename);
        try {
            this.fileStore.setObjectTags(bucketName, filename, body.getTagSet());
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setETag("\"" + s3Object.getMd5() + "\"");
            responseHeaders.setLastModified(s3Object.getLastModified());
            return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (IOException e) {
            LOG.error("Tags could not be set!", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploads"}, method={RequestMethod.POST}, produces={"application/xml"})
    public InitiateMultipartUploadResult initiateMultipartUpload(@PathVariable String bucketName, HttpServletRequest request) {
        return this.initiateMultipartUpload(bucketName, ABSENT_ENCRYPTION, ABSENT_KEY_ID, request);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploads"}, headers={"x-amz-server-side-encryption", "x-amz-server-side-encryption-aws-kms-key-id"}, method={RequestMethod.POST}, produces={"application/xml"})
    public InitiateMultipartUploadResult initiateMultipartUpload(@PathVariable String bucketName, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id") String kmsKeyId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        Map<String, String> userMetadata = MetadataUtil.getUserMetadata(request);
        String uploadId = UUID.randomUUID().toString();
        this.fileStore.prepareMultipartUpload(bucketName, filename, request.getContentType(), request.getHeader("Content-Encoding"), uploadId, TEST_OWNER, TEST_OWNER, userMetadata);
        return new InitiateMultipartUploadResult(bucketName, FileStoreController.fileNameToObjectName(filename), uploadId);
    }

    @RequestMapping(value={"/{bucketName:.+}/"}, params={"uploads"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ListMultipartUploadsResult listMultipartUploads(@PathVariable String bucketName, @RequestParam(required=false) String prefix, @RequestParam String uploads) {
        this.verifyBucketExistence(bucketName);
        List<MultipartUpload> multipartUploads = this.fileStore.listMultipartUploads().stream().filter(m -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)prefix) || prefix != null && m.getKey().startsWith(prefix)).map(m -> new MultipartUpload(FileStoreController.fileNameToObjectName(m.getKey()), m.getUploadId(), m.getOwner(), m.getInitiator(), m.getInitiated())).collect(Collectors.toList());
        int maxUploads = Math.max(1000, multipartUploads.size());
        boolean isTruncated = false;
        String uploadIdMarker = null;
        String nextUploadIdMarker = null;
        String keyMarker = null;
        String nextKeyMarker = null;
        String delimiter = null;
        List<String> commonPrefixes = Collections.emptyList();
        return new ListMultipartUploadsResult(bucketName, keyMarker, delimiter, prefix, uploadIdMarker, maxUploads, false, nextKeyMarker, nextUploadIdMarker, multipartUploads, commonPrefixes);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId"}, method={RequestMethod.DELETE}, produces={"application/xml"})
    public void abortMultipartUpload(@PathVariable String bucketName, @RequestParam String uploadId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.fileStore.abortMultipartUpload(bucketName, filename, uploadId);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ListPartsResult multipartListParts(@PathVariable String bucketName, @RequestParam String uploadId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        List<Part> parts = this.fileStore.getMultipartUploadParts(bucketName, filename, uploadId);
        return new ListPartsResult(bucketName, filename, uploadId, parts);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId", "partNumber"}, headers={"!x-amz-copy-source", "!x-amz-copy-source-range", "x-amz-server-side-encryption"}, method={RequestMethod.PUT})
    public ResponseEntity<CopyPartResult> putObjectPart(@PathVariable String bucketName, @RequestParam String uploadId, @RequestParam String partNumber, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, HttpServletRequest request) throws IOException {
        this.verifyBucketExistence(bucketName);
        this.verifyPartNumberLimits(partNumber);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        String etag = this.fileStore.putPart(bucketName, filename, uploadId, partNumber, (InputStream)request.getInputStream(), this.isV4ChunkedWithSigningEnabled(request));
        HttpHeaders responseHeaders = new HttpHeaders();
        String quotedEtag = "\"" + etag + "\"";
        responseHeaders.setETag(quotedEtag);
        return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId", "partNumber"}, headers={"!x-amz-copy-source", "!x-amz-copy-source-range"}, method={RequestMethod.PUT})
    public ResponseEntity<CopyPartResult> putObjectPart(@PathVariable String bucketName, @RequestParam String uploadId, @RequestParam String partNumber, HttpServletRequest request) throws IOException {
        return this.putObjectPart(bucketName, uploadId, partNumber, ABSENT_ENCRYPTION, ABSENT_KEY_ID, request);
    }

    @RequestMapping(value={"/{destinationBucket:.+}/**"}, method={RequestMethod.PUT}, headers={"x-amz-copy-source", "x-amz-copy-source-range", "x-amz-server-side-encryption", "x-amz-server-side-encryption-aws-kms-key-id"})
    public ResponseEntity<CopyPartResult> copyObjectPart(@RequestHeader(value="x-amz-copy-source") ObjectRef copySource, @RequestHeader(value="x-amz-copy-source-range") Range copyRange, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, @PathVariable String destinationBucket, @RequestParam String uploadId, @RequestParam String partNumber, HttpServletRequest request) throws IOException {
        this.verifyBucketExistence(destinationBucket);
        String destinationFile = FileStoreController.filenameFrom(destinationBucket, request);
        String partEtag = this.fileStore.copyPart(copySource.getBucket(), copySource.getKey(), (int)copyRange.getStart(), (int)copyRange.getEnd(), partNumber, destinationBucket, destinationFile, uploadId);
        return ResponseEntity.ok((Object)CopyPartResult.from(new Date(), "\"" + partEtag + "\""));
    }

    @RequestMapping(value={"/{destinationBucket:.+}/**"}, method={RequestMethod.PUT}, headers={"x-amz-copy-source", "x-amz-copy-source-range", "!x-amz-server-side-encryption"})
    public ResponseEntity<CopyPartResult> copyObjectPart(@RequestHeader(value="x-amz-copy-source") ObjectRef copySource, @RequestHeader(value="x-amz-copy-source-range") Range copyRange, @PathVariable String destinationBucket, @RequestParam String uploadId, @RequestParam String partNumber, HttpServletRequest request) throws IOException {
        return this.copyObjectPart(copySource, copyRange, ABSENT_ENCRYPTION, ABSENT_KEY_ID, destinationBucket, uploadId, partNumber, request);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId"}, method={RequestMethod.POST}, produces={"application/xml"})
    public ResponseEntity<CompleteMultipartUploadResult> completeMultipartUpload(@PathVariable String bucketName, @RequestParam String uploadId, @RequestBody CompleteMultipartUploadRequest requestBody, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.validateMultipartParts(bucketName, filename, uploadId, requestBody.getParts());
        String eTag = this.fileStore.completeMultipartUpload(bucketName, filename, uploadId, requestBody.getParts());
        return new ResponseEntity((Object)new CompleteMultipartUploadResult(request.getRequestURL().toString(), bucketName, filename, eTag), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, headers={"x-amz-server-side-encryption", "x-amz-server-side-encryption-aws-kms-key-id"}, params={"uploadId"}, method={RequestMethod.POST}, produces={"application/xml"})
    public ResponseEntity<CompleteMultipartUploadResult> completeMultipartUploadEncrypted(@PathVariable String bucketName, @RequestParam String uploadId, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id") String kmsKeyId, @RequestBody CompleteMultipartUploadRequest requestBody, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        String eTag = this.fileStore.completeMultipartUpload(bucketName, filename, uploadId, requestBody.getParts(), encryption, kmsKeyId);
        return new ResponseEntity((Object)new CompleteMultipartUploadResult(request.getRequestURL().toString(), bucketName, filename, eTag), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    private void getObjectWithRange(HttpServletResponse response, Range range, S3Object s3Object) throws IOException {
        long fileSize = s3Object.getDataFile().length();
        long bytesToRead = Math.min(fileSize - 1L, range.getEnd()) - range.getStart() + 1L;
        if (bytesToRead < 0L || fileSize < range.getStart()) {
            response.setStatus(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE.value());
            response.flushBuffer();
            return;
        }
        response.setStatus(HttpStatus.PARTIAL_CONTENT.value());
        response.setHeader("Accept-Ranges", RANGES_BYTES);
        response.setHeader("Content-Range", String.format("bytes %s-%s/%s", range.getStart(), bytesToRead + range.getStart() - 1L, s3Object.getSize()));
        response.setHeader("ETag", "\"" + s3Object.getMd5() + "\"");
        response.setDateHeader("Last-Modified", s3Object.getLastModified());
        response.setContentType(s3Object.getContentType());
        response.setContentLengthLong(bytesToRead);
        MetadataUtil.addUserMetadata((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1), s3Object);
        try (ServletOutputStream outputStream = response.getOutputStream();
             FileInputStream fis = new FileInputStream(s3Object.getDataFile());){
            fis.skip(range.getStart());
            IOUtils.copy((InputStream)new BoundedInputStream((InputStream)fis, bytesToRead), (OutputStream)outputStream);
        }
    }

    private static String filenameFrom(@PathVariable String bucketName, HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        return FileStoreController.objectNameToFileName(UrlEncoded.decodeString((String)requestUri.substring(requestUri.indexOf(bucketName) + bucketName.length() + 1)));
    }

    static String objectNameToFileName(String objectName) {
        char[] chars = objectName.toCharArray();
        int len = chars.length;
        StringBuffer buffer = null;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c < ' ' || c >= '\u007f' || c == '<' || c == '>' || c == ':' || c == '\"' || c == '\\' || c == '|' || c == '?' || c == '*' || c == '.' || c == '%') {
                if (buffer == null) {
                    buffer = new StringBuffer(objectName.length() * 2);
                    buffer.append(objectName, 0, i);
                }
                buffer.append('%');
                TypeUtil.toHex((byte)((byte)((c & 0xFF00) >> 8)), (Appendable)buffer);
                TypeUtil.toHex((byte)((byte)(c & 0xFF)), (Appendable)buffer);
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        if (buffer == null) {
            return objectName;
        }
        return buffer.toString();
    }

    static String fileNameToObjectName(String encoded) {
        StringBuffer buffer = null;
        char[] chars = encoded.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '%') {
                if (buffer == null) {
                    buffer = new StringBuffer(encoded.length());
                    buffer.append(encoded, 0, i);
                }
                buffer.append((char)TypeUtil.parseInt((String)encoded, (int)(i + 1), (int)4, (int)16));
                i += 4;
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        if (buffer == null) {
            return encoded;
        }
        return buffer.toString();
    }

    private void verifyObjectMatching(List<String> match, List<String> noneMatch, String etag) {
        if (match != null && !match.contains(etag)) {
            throw new S3Exception(HttpStatus.PRECONDITION_FAILED.value(), "PreconditionFailed", "Precondition Failed");
        }
        if (noneMatch != null && noneMatch.contains(etag)) {
            throw new S3Exception(HttpStatus.NOT_MODIFIED.value(), "NotModified", "Not Modified");
        }
    }

    private S3Object verifyObjectExistence(@PathVariable String bucketName, String filename) {
        S3Object s3Object = this.fileStore.getS3Object(bucketName, filename);
        if (s3Object == null) {
            throw new S3Exception(HttpStatus.NOT_FOUND.value(), "NoSuchKey", "The specified key does not exist.");
        }
        return s3Object;
    }

    private void verifyBucketExistence(String bucketName) {
        Bucket bucket = this.fileStore.getBucket(bucketName);
        if (bucket == null) {
            throw new S3Exception(HttpStatus.NOT_FOUND.value(), "NoSuchBucket", "The specified bucket does not exist.");
        }
    }

    private void verifyPartNumberLimits(String partNumberString) {
        Integer partNumber;
        try {
            partNumber = Integer.parseInt(partNumberString);
        }
        catch (NumberFormatException nfe) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "Part number must be an integer between 1 and 10000, inclusive");
        }
        if (partNumber < 1 || partNumber > 10000) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "Part number must be an integer between 1 and 10000, inclusive");
        }
    }

    private void validateMetadataDirective(String metadataDirective) {
        if (!METADATA_DIRECTIVE_REPLACE.equals(metadataDirective) && !METADATA_DIRECTIVE_COPY.equals(metadataDirective)) {
            throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidRequest", "Invalid x-amz-metadata-directive header value.");
        }
    }

    private MediaType parseMediaType(String contentType) {
        try {
            return MediaType.parseMediaType((String)contentType);
        }
        catch (InvalidMediaTypeException e) {
            return FALLBACK_MEDIA_TYPE;
        }
    }

    private void validateMultipartParts(String bucketName, String filename, String uploadId, List<Part> requestedParts) {
        List<Part> uploadedParts = this.fileStore.getMultipartUploadParts(bucketName, filename, uploadId);
        Map<Integer, String> uploadedPartsMap = uploadedParts.stream().collect(Collectors.toMap(Part::getPartNumber, Part::getETag));
        Integer prevPartNumber = 0;
        for (Part part : requestedParts) {
            if (!uploadedPartsMap.containsKey(part.getPartNumber()) || !uploadedPartsMap.get(part.getPartNumber()).equals(part.getETag().replaceAll("^\"|\"$", ""))) {
                throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidPart", "One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part's entity tag.");
            }
            if (part.getPartNumber() < prevPartNumber) {
                throw new S3Exception(HttpStatus.BAD_REQUEST.value(), "InvalidPartOrder", "The list of parts was not in ascending order. The parts list must be specified in order by part number.");
            }
            prevPartNumber = part.getPartNumber();
        }
    }
}

