/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.decoder;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.AdditionalInformation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public abstract class AbstractDecoder<T> {
    private static final int BUFFER_SIZE = 4096;
    protected static final int INFINITY = -1;
    protected final InputStream inputStream;
    protected final CborDecoder decoder;
    private int maxPreallocationSize;

    public AbstractDecoder(CborDecoder decoder, InputStream inputStream) {
        this.decoder = decoder;
        this.inputStream = inputStream;
    }

    public abstract T decode(int var1) throws CborException;

    protected int nextSymbol() throws CborException {
        try {
            int symbol = this.inputStream.read();
            if (symbol == -1) {
                throw new IOException("Unexpected end of stream");
            }
            return symbol;
        }
        catch (IOException ioException) {
            throw new CborException(ioException);
        }
    }

    protected byte[] nextSymbols(int amount) throws CborException {
        try {
            byte[] symbols = new byte[amount];
            int read = this.inputStream.read(symbols);
            if (read == amount) {
                return symbols;
            }
            if (read == -1) {
                throw new IOException("Unexpected end of stream");
            }
            for (int left = amount - read; left > 0; left -= read) {
                read = this.inputStream.read(symbols, amount - left, left);
                if (read != -1) continue;
                throw new IOException("Unexpected end of stream");
            }
            return symbols;
        }
        catch (IOException ioException) {
            throw new CborException(ioException);
        }
    }

    byte[] decodeBytes(long length) throws CborException {
        int read;
        if (length > Integer.MAX_VALUE) {
            throw new CborException("Decoding fixed size items is limited to INTMAX");
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(this.getPreallocationSize(length));
        int chunkSize = (int)(length > 4096L ? 4096L : length);
        byte[] buf = new byte[chunkSize];
        for (int i = (int)length; i > 0; i -= read) {
            try {
                read = this.inputStream.read(buf, 0, i > chunkSize ? chunkSize : i);
                if (read == -1) {
                    throw new IOException("Unexpected end of stream");
                }
                bytes.write(buf, 0, read);
                continue;
            }
            catch (IOException e) {
                throw new CborException(e);
            }
        }
        return bytes.toByteArray();
    }

    protected long getLength(int initialByte) throws CborException {
        switch (AdditionalInformation.ofByte(initialByte)) {
            case DIRECT: {
                return initialByte & 0x1F;
            }
            case ONE_BYTE: {
                return this.nextSymbol();
            }
            case TWO_BYTES: {
                long twoByteValue = 0L;
                byte[] symbols = this.nextSymbols(2);
                twoByteValue |= (long)((symbols[0] & 0xFF) << 8);
                return twoByteValue |= (long)((symbols[1] & 0xFF) << 0);
            }
            case FOUR_BYTES: {
                long fourByteValue = 0L;
                byte[] symbols = this.nextSymbols(4);
                fourByteValue |= (long)(symbols[0] & 0xFF) << 24;
                fourByteValue |= (long)(symbols[1] & 0xFF) << 16;
                fourByteValue |= (long)(symbols[2] & 0xFF) << 8;
                return fourByteValue |= (long)(symbols[3] & 0xFF) << 0;
            }
            case EIGHT_BYTES: {
                long eightByteValue = 0L;
                byte[] symbols = this.nextSymbols(8);
                eightByteValue |= (long)(symbols[0] & 0xFF) << 56;
                eightByteValue |= (long)(symbols[1] & 0xFF) << 48;
                eightByteValue |= (long)(symbols[2] & 0xFF) << 40;
                eightByteValue |= (long)(symbols[3] & 0xFF) << 32;
                eightByteValue |= (long)(symbols[4] & 0xFF) << 24;
                eightByteValue |= (long)(symbols[5] & 0xFF) << 16;
                eightByteValue |= (long)(symbols[6] & 0xFF) << 8;
                return eightByteValue |= (long)(symbols[7] & 0xFF) << 0;
            }
            case INDEFINITE: {
                return -1L;
            }
        }
        throw new CborException("Reserved additional information");
    }

    protected BigInteger getLengthAsBigInteger(int initialByte) throws CborException {
        switch (AdditionalInformation.ofByte(initialByte)) {
            case DIRECT: {
                return BigInteger.valueOf(initialByte & 0x1F);
            }
            case ONE_BYTE: {
                return BigInteger.valueOf(this.nextSymbol());
            }
            case TWO_BYTES: {
                long twoByteValue = 0L;
                byte[] symbols = this.nextSymbols(2);
                twoByteValue |= (long)((symbols[0] & 0xFF) << 8);
                return BigInteger.valueOf(twoByteValue |= (long)((symbols[1] & 0xFF) << 0));
            }
            case FOUR_BYTES: {
                long fourByteValue = 0L;
                byte[] symbols = this.nextSymbols(4);
                fourByteValue |= (long)(symbols[0] & 0xFF) << 24;
                fourByteValue |= (long)(symbols[1] & 0xFF) << 16;
                fourByteValue |= (long)(symbols[2] & 0xFF) << 8;
                return BigInteger.valueOf(fourByteValue |= (long)(symbols[3] & 0xFF) << 0);
            }
            case EIGHT_BYTES: {
                BigInteger eightByteValue = BigInteger.ZERO;
                byte[] symbols = this.nextSymbols(8);
                eightByteValue = eightByteValue.or(BigInteger.valueOf(symbols[0] & 0xFF).shiftLeft(56));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(symbols[1] & 0xFF).shiftLeft(48));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(symbols[2] & 0xFF).shiftLeft(40));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(symbols[3] & 0xFF).shiftLeft(32));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(symbols[4] & 0xFF).shiftLeft(24));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(symbols[5] & 0xFF).shiftLeft(16));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(symbols[6] & 0xFF).shiftLeft(8));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(symbols[7] & 0xFF).shiftLeft(0));
                return eightByteValue;
            }
            case INDEFINITE: {
                return BigInteger.valueOf(-1L);
            }
        }
        throw new CborException("Reserved additional information");
    }

    int getPreallocationSize(long length) {
        int len = Math.abs((int)length);
        return this.maxPreallocationSize > 0 ? Math.min(this.maxPreallocationSize, len) : len;
    }

    public void setMaxPreallocationSize(int maxPreallocationSize) {
        this.maxPreallocationSize = maxPreallocationSize;
    }
}

