/*
 * Decompiled with CFR 0.152.
 */
package co.helmethair.scalatest.runtime;

import co.helmethair.scalatest.descriptor.ScalatestEngineDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestFailedInitDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestSuiteDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestTestDescriptor;
import co.helmethair.scalatest.scala.ScalaConversions;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.scalatest.DoNotDiscover;
import org.scalatest.Suite;
import org.scalatest.TagAnnotation;
import scala.Option;

public class Discovery {
    public ScalatestEngineDescriptor discover(ScalatestEngineDescriptor engineDescriptor, Set<String> classes, ClassLoader classLoader) {
        classes.forEach(c -> {
            Class<?> aClass = null;
            try {
                aClass = classLoader.loadClass((String)c);
                if (this.isScalaSuite(aClass)) {
                    Suite suite = (Suite)aClass.newInstance();
                    this.addSuite(suite, (TestDescriptor)engineDescriptor);
                }
            }
            catch (Throwable e) {
                if (aClass != null && Suite.class.isAssignableFrom(aClass)) {
                    this.addFailedInit(e, aClass, (TestDescriptor)engineDescriptor);
                }
                this.addFailedInit(e, (String)c, (TestDescriptor)engineDescriptor);
            }
        });
        return engineDescriptor;
    }

    private boolean isScalaSuite(Class<?> c) {
        return c.getEnclosingMethod() == null && !c.isSynthetic() && !Modifier.isAbstract(c.getModifiers()) && c.getAnnotation(DoNotDiscover.class) == null && Suite.class.isAssignableFrom(c);
    }

    private void addFailedInit(Throwable cause, String className, TestDescriptor parent) {
        ScalatestFailedInitDescriptor failed = new ScalatestFailedInitDescriptor(cause, className, Collections.emptySet());
        this.linkChild(parent, failed);
    }

    private void addFailedInit(Throwable cause, Class<? extends Suite> clazz, TestDescriptor parent) {
        String className = clazz.getName();
        ScalatestFailedInitDescriptor failed = new ScalatestFailedInitDescriptor(cause, className, this.extractTags(clazz));
        this.linkChild(parent, failed);
    }

    private void addSuite(Suite suite, TestDescriptor parent) {
        ScalatestSuiteDescriptor scalatestSuiteDescriptor = new ScalatestSuiteDescriptor(suite, suite.suiteId(), suite.suiteName());
        this.linkChild(parent, scalatestSuiteDescriptor);
        this.addTests(scalatestSuiteDescriptor, ScalaConversions.setAsJavaSet(suite.testNames()));
        ScalaConversions.asJavaCollection(suite.nestedSuites()).forEach(scalatestNestedSuite -> {
            try {
                this.addSuite((Suite)scalatestNestedSuite, scalatestSuiteDescriptor);
            }
            catch (Throwable e) {
                this.addFailedInit(e, scalatestNestedSuite.getClass(), (TestDescriptor)scalatestSuiteDescriptor);
            }
        });
    }

    private void linkChild(TestDescriptor parent, TestDescriptor child) {
        child.setParent(parent);
        parent.addChild(child);
    }

    private void addTests(ScalatestSuiteDescriptor suite, Set<String> testNames) {
        testNames.forEach(testName -> this.linkChild(suite, new ScalatestTestDescriptor(suite, (String)testName, this.getTags(suite.getScalasuite(), (String)testName))));
    }

    private Set<TestTag> extractTags(Class<? extends Suite> clazz) {
        return Arrays.stream(clazz.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(TagAnnotation.class)).map(a -> TestTag.create((String)a.annotationType().getName())).collect(Collectors.toSet());
    }

    private Set<TestTag> getTags(Suite scalasuite, String testName) {
        Option tagSetOption = scalasuite.tags().get((Object)testName);
        if (tagSetOption.isDefined()) {
            return ScalaConversions.setAsJavaSet((scala.collection.immutable.Set)tagSetOption.get()).stream().map(TestTag::create).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

