/*
 * Decompiled with CFR 0.152.
 */
package co.helmethair.scalatest.descriptor;

import co.helmethair.scalatest.descriptor.ScalatestEngineDescriptor;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

public abstract class ScalatestDescriptor
implements TestDescriptor {
    static final UniqueId ENGINE_ID = UniqueId.forEngine((String)"scalatest");
    static final ConcurrentHashMap<UniqueId, ScalatestDescriptor> descriptorsById = new ConcurrentHashMap();
    public static final String SUITE_TYPE = "suite";
    private final UniqueId id;
    private TestDescriptor parentDescriptor = null;
    private Set<TestDescriptor> childDescriptors = new HashSet<TestDescriptor>();
    protected Set<TestTag> tags = new HashSet<TestTag>();

    protected ScalatestDescriptor(UniqueId id) {
        this.id = id;
        descriptorsById.put(id, this);
    }

    public static Optional<ScalatestDescriptor> find(String suiteId, String testName) {
        return ScalatestDescriptor.findById(ScalatestDescriptor.descriptorId(suiteId, testName));
    }

    public static Optional<ScalatestDescriptor> findById(UniqueId uniqueId) {
        return Optional.ofNullable(descriptorsById.get(uniqueId));
    }

    static UniqueId testId(String suiteId, String testName) {
        return ENGINE_ID.append(SUITE_TYPE, suiteId).append("test", testName);
    }

    static UniqueId containerId(String suiteId) {
        return ENGINE_ID.append(SUITE_TYPE, suiteId);
    }

    static UniqueId descriptorId(String suiteId, String testName) {
        if (testName == null) {
            return ScalatestDescriptor.containerId(suiteId);
        }
        return ScalatestDescriptor.testId(suiteId, testName);
    }

    public UniqueId getUniqueId() {
        return this.id;
    }

    public Optional<TestDescriptor> getParent() {
        return Optional.ofNullable(this.parentDescriptor);
    }

    public void setParent(TestDescriptor parent) {
        if (parent != null && (parent instanceof ScalatestDescriptor || parent instanceof ScalatestEngineDescriptor)) {
            this.parentDescriptor = parent;
        }
    }

    public void addChild(TestDescriptor descriptor) {
        this.childDescriptors.add(descriptor);
    }

    public Set<TestDescriptor> getChildren() {
        return this.childDescriptors;
    }

    public Set<TestTag> getTags() {
        return this.tags;
    }

    public void removeFromHierarchy() {
        this.getParent().ifPresent(parent -> parent.removeChild((TestDescriptor)this));
    }

    public void removeChild(TestDescriptor descriptor) {
        if (this.getType() == TestDescriptor.Type.CONTAINER) {
            this.childDescriptors.remove(descriptor);
        }
    }

    public Optional<? extends TestDescriptor> findByUniqueId(UniqueId uniqueId) {
        return ScalatestDescriptor.findById(uniqueId);
    }
}

