/*
 * Decompiled with CFR 0.152.
 */
package co.helmethair.scalatest;

import co.helmethair.scalatest.descriptor.ScalatestEngineDescriptor;
import co.helmethair.scalatest.reporter.JUnitReporter;
import co.helmethair.scalatest.runtime.Discovery;
import co.helmethair.scalatest.runtime.Executor;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;

public class ScalatestEngine
implements TestEngine {
    public static final String ID = "scalatest";
    public static final String PARAMETER_SKIP_AFTER_FAIL = "scalatest.junit.skip_after_fail";
    public static final boolean DEFAULT_SKIP_AFTER_FAIL = false;
    Discovery runtime = new Discovery();

    public String getId() {
        return ID;
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        ScalatestEngineDescriptor engineDescriptor = new ScalatestEngineDescriptor(uniqueId, ID);
        return this.runtime.discover(engineDescriptor, Stream.concat(this.discoverClassSelectors(discoveryRequest).stream(), this.discoverUniqueIdSelectors(discoveryRequest).stream()).collect(Collectors.toSet()), Thread.currentThread().getContextClassLoader());
    }

    public void execute(ExecutionRequest executionRequest) {
        Optional<ConfigurationParameters> params = Optional.ofNullable(executionRequest.getConfigurationParameters());
        boolean skipAfterFail = params.map(p -> p.getBoolean(PARAMETER_SKIP_AFTER_FAIL).orElse(false)).orElse(false);
        Executor executor = new Executor(skipAfterFail);
        JUnitReporter reporter = new JUnitReporter(executionRequest.getEngineExecutionListener(), executionRequest.getRootTestDescriptor());
        executor.executeTest(executionRequest.getRootTestDescriptor(), reporter);
    }

    private List<String> discoverUniqueIdSelectors(EngineDiscoveryRequest discoveryRequest) {
        return discoveryRequest.getSelectorsByType(UniqueIdSelector.class).stream().map(this::getSuite).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<String> getSuite(UniqueIdSelector u) {
        UniqueId.Segment segment;
        UniqueId uniqueId = u.getUniqueId();
        if (uniqueId.hasPrefix(UniqueId.forEngine((String)ID)) && "suite".equals((segment = (UniqueId.Segment)uniqueId.getSegments().get(1)).getType())) {
            return Optional.of(segment.getValue());
        }
        return Optional.empty();
    }

    private List<String> discoverClassSelectors(EngineDiscoveryRequest discoveryRequest) {
        return discoveryRequest.getSelectorsByType(ClassSelector.class).stream().map(ClassSelector::getClassName).collect(Collectors.toList());
    }
}

