/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentTooLongException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.entity.AbstractBinDataConsumer;
import org.apache.hc.core5.util.ByteArrayBuffer;

public class BufferedByteConsumer
extends AbstractBinDataConsumer
implements AsyncEntityConsumer<ByteArrayEntity> {
    private final int limit;
    private volatile ByteArrayBuffer buffer;
    private volatile FutureCallback<ByteArrayEntity> resultCallback;
    private volatile ContentType contentType;
    private volatile String contentEncoding;
    private volatile ByteArrayEntity result;

    public BufferedByteConsumer(int bufferLimit) {
        if (bufferLimit <= 0) {
            throw new IllegalArgumentException("Buffer limit must be greater than 0");
        }
        this.limit = bufferLimit;
        this.buffer = new ByteArrayBuffer(8192);
    }

    public void streamStart(EntityDetails entityDetails, FutureCallback<ByteArrayEntity> resultCallback) {
        this.contentType = entityDetails != null ? ContentType.parse((CharSequence)entityDetails.getContentType()) : null;
        this.contentEncoding = entityDetails != null ? entityDetails.getContentEncoding() : null;
        this.resultCallback = resultCallback;
    }

    protected int capacityIncrement() {
        return this.limit;
    }

    protected void data(ByteBuffer src, boolean endOfStream) throws ContentTooLongException {
        if (this.buffer.length() + src.limit() > this.limit) {
            throw new ContentTooLongException("entity content is too long [" + src.limit() + "] for the configured buffer limit [" + this.limit + "]");
        }
        this.buffer.append(src);
    }

    protected final void completed() throws IOException {
        this.result = new ByteArrayEntity(this.buffer.toByteArray(), this.contentType, this.contentEncoding);
        if (this.resultCallback != null) {
            this.resultCallback.completed((Object)this.result);
        }
        this.releaseResources();
    }

    public ByteArrayEntity getContent() {
        return this.result;
    }

    public final void failed(Exception cause) {
        if (this.resultCallback != null) {
            this.resultCallback.failed(cause);
        }
        this.releaseResources();
    }

    public void releaseResources() {
        this.buffer.clear();
    }
}

