/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.ml.JobStatistics;
import co.elastic.clients.elasticsearch.xpack.usage.MlCounter;
import co.elastic.clients.elasticsearch.xpack.usage.MlInferenceTrainedModelsCount;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MlInferenceTrainedModels
implements JsonpSerializable {
    @Nullable
    private final JobStatistics estimatedOperations;
    @Nullable
    private final JobStatistics estimatedHeapMemoryUsageBytes;
    @Nullable
    private final MlInferenceTrainedModelsCount count;
    private final MlCounter all;
    @Nullable
    private final JobStatistics modelSizeBytes;
    public static final JsonpDeserializer<MlInferenceTrainedModels> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MlInferenceTrainedModels::setupMlInferenceTrainedModelsDeserializer);

    private MlInferenceTrainedModels(Builder builder) {
        this.estimatedOperations = builder.estimatedOperations;
        this.estimatedHeapMemoryUsageBytes = builder.estimatedHeapMemoryUsageBytes;
        this.count = builder.count;
        this.all = ApiTypeHelper.requireNonNull(builder.all, this, "all");
        this.modelSizeBytes = builder.modelSizeBytes;
    }

    public static MlInferenceTrainedModels of(Function<Builder, ObjectBuilder<MlInferenceTrainedModels>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final JobStatistics estimatedOperations() {
        return this.estimatedOperations;
    }

    @Nullable
    public final JobStatistics estimatedHeapMemoryUsageBytes() {
        return this.estimatedHeapMemoryUsageBytes;
    }

    @Nullable
    public final MlInferenceTrainedModelsCount count() {
        return this.count;
    }

    public final MlCounter all() {
        return this.all;
    }

    @Nullable
    public final JobStatistics modelSizeBytes() {
        return this.modelSizeBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.estimatedOperations != null) {
            generator.writeKey("estimated_operations");
            this.estimatedOperations.serialize(generator, mapper);
        }
        if (this.estimatedHeapMemoryUsageBytes != null) {
            generator.writeKey("estimated_heap_memory_usage_bytes");
            this.estimatedHeapMemoryUsageBytes.serialize(generator, mapper);
        }
        if (this.count != null) {
            generator.writeKey("count");
            this.count.serialize(generator, mapper);
        }
        generator.writeKey("_all");
        this.all.serialize(generator, mapper);
        if (this.modelSizeBytes != null) {
            generator.writeKey("model_size_bytes");
            this.modelSizeBytes.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMlInferenceTrainedModelsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::estimatedOperations, JobStatistics._DESERIALIZER, "estimated_operations");
        op.add(Builder::estimatedHeapMemoryUsageBytes, JobStatistics._DESERIALIZER, "estimated_heap_memory_usage_bytes");
        op.add(Builder::count, MlInferenceTrainedModelsCount._DESERIALIZER, "count");
        op.add(Builder::all, MlCounter._DESERIALIZER, "_all");
        op.add(Builder::modelSizeBytes, JobStatistics._DESERIALIZER, "model_size_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MlInferenceTrainedModels> {
        @Nullable
        private JobStatistics estimatedOperations;
        @Nullable
        private JobStatistics estimatedHeapMemoryUsageBytes;
        @Nullable
        private MlInferenceTrainedModelsCount count;
        private MlCounter all;
        @Nullable
        private JobStatistics modelSizeBytes;

        public Builder() {
        }

        private Builder(MlInferenceTrainedModels instance) {
            this.estimatedOperations = instance.estimatedOperations;
            this.estimatedHeapMemoryUsageBytes = instance.estimatedHeapMemoryUsageBytes;
            this.count = instance.count;
            this.all = instance.all;
            this.modelSizeBytes = instance.modelSizeBytes;
        }

        public final Builder estimatedOperations(@Nullable JobStatistics value) {
            this.estimatedOperations = value;
            return this;
        }

        public final Builder estimatedOperations(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.estimatedOperations(fn.apply(new JobStatistics.Builder()).build());
        }

        public final Builder estimatedHeapMemoryUsageBytes(@Nullable JobStatistics value) {
            this.estimatedHeapMemoryUsageBytes = value;
            return this;
        }

        public final Builder estimatedHeapMemoryUsageBytes(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.estimatedHeapMemoryUsageBytes(fn.apply(new JobStatistics.Builder()).build());
        }

        public final Builder count(@Nullable MlInferenceTrainedModelsCount value) {
            this.count = value;
            return this;
        }

        public final Builder count(Function<MlInferenceTrainedModelsCount.Builder, ObjectBuilder<MlInferenceTrainedModelsCount>> fn) {
            return this.count(fn.apply(new MlInferenceTrainedModelsCount.Builder()).build());
        }

        public final Builder all(MlCounter value) {
            this.all = value;
            return this;
        }

        public final Builder all(Function<MlCounter.Builder, ObjectBuilder<MlCounter>> fn) {
            return this.all(fn.apply(new MlCounter.Builder()).build());
        }

        public final Builder modelSizeBytes(@Nullable JobStatistics value) {
            this.modelSizeBytes = value;
            return this;
        }

        public final Builder modelSizeBytes(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.modelSizeBytes(fn.apply(new JobStatistics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MlInferenceTrainedModels build() {
            this._checkSingleUse();
            return new MlInferenceTrainedModels(this);
        }
    }
}

