/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataTierPhaseStatistics
implements JsonpSerializable {
    private final long nodeCount;
    private final long indexCount;
    private final long totalShardCount;
    private final long primaryShardCount;
    private final long docCount;
    private final long totalSizeBytes;
    private final long primarySizeBytes;
    private final long primaryShardSizeAvgBytes;
    private final long primaryShardSizeMedianBytes;
    private final long primaryShardSizeMadBytes;
    public static final JsonpDeserializer<DataTierPhaseStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataTierPhaseStatistics::setupDataTierPhaseStatisticsDeserializer);

    private DataTierPhaseStatistics(Builder builder) {
        this.nodeCount = ApiTypeHelper.requireNonNull(builder.nodeCount, (Object)this, "nodeCount", 0L);
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, (Object)this, "indexCount", 0L);
        this.totalShardCount = ApiTypeHelper.requireNonNull(builder.totalShardCount, (Object)this, "totalShardCount", 0L);
        this.primaryShardCount = ApiTypeHelper.requireNonNull(builder.primaryShardCount, (Object)this, "primaryShardCount", 0L);
        this.docCount = ApiTypeHelper.requireNonNull(builder.docCount, (Object)this, "docCount", 0L);
        this.totalSizeBytes = ApiTypeHelper.requireNonNull(builder.totalSizeBytes, (Object)this, "totalSizeBytes", 0L);
        this.primarySizeBytes = ApiTypeHelper.requireNonNull(builder.primarySizeBytes, (Object)this, "primarySizeBytes", 0L);
        this.primaryShardSizeAvgBytes = ApiTypeHelper.requireNonNull(builder.primaryShardSizeAvgBytes, (Object)this, "primaryShardSizeAvgBytes", 0L);
        this.primaryShardSizeMedianBytes = ApiTypeHelper.requireNonNull(builder.primaryShardSizeMedianBytes, (Object)this, "primaryShardSizeMedianBytes", 0L);
        this.primaryShardSizeMadBytes = ApiTypeHelper.requireNonNull(builder.primaryShardSizeMadBytes, (Object)this, "primaryShardSizeMadBytes", 0L);
    }

    public static DataTierPhaseStatistics of(Function<Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long nodeCount() {
        return this.nodeCount;
    }

    public final long indexCount() {
        return this.indexCount;
    }

    public final long totalShardCount() {
        return this.totalShardCount;
    }

    public final long primaryShardCount() {
        return this.primaryShardCount;
    }

    public final long docCount() {
        return this.docCount;
    }

    public final long totalSizeBytes() {
        return this.totalSizeBytes;
    }

    public final long primarySizeBytes() {
        return this.primarySizeBytes;
    }

    public final long primaryShardSizeAvgBytes() {
        return this.primaryShardSizeAvgBytes;
    }

    public final long primaryShardSizeMedianBytes() {
        return this.primaryShardSizeMedianBytes;
    }

    public final long primaryShardSizeMadBytes() {
        return this.primaryShardSizeMadBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_count");
        generator.write(this.nodeCount);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        generator.writeKey("total_shard_count");
        generator.write(this.totalShardCount);
        generator.writeKey("primary_shard_count");
        generator.write(this.primaryShardCount);
        generator.writeKey("doc_count");
        generator.write(this.docCount);
        generator.writeKey("total_size_bytes");
        generator.write(this.totalSizeBytes);
        generator.writeKey("primary_size_bytes");
        generator.write(this.primarySizeBytes);
        generator.writeKey("primary_shard_size_avg_bytes");
        generator.write(this.primaryShardSizeAvgBytes);
        generator.writeKey("primary_shard_size_median_bytes");
        generator.write(this.primaryShardSizeMedianBytes);
        generator.writeKey("primary_shard_size_mad_bytes");
        generator.write(this.primaryShardSizeMadBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataTierPhaseStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeCount, JsonpDeserializer.longDeserializer(), "node_count");
        op.add(Builder::indexCount, JsonpDeserializer.longDeserializer(), "index_count");
        op.add(Builder::totalShardCount, JsonpDeserializer.longDeserializer(), "total_shard_count");
        op.add(Builder::primaryShardCount, JsonpDeserializer.longDeserializer(), "primary_shard_count");
        op.add(Builder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
        op.add(Builder::totalSizeBytes, JsonpDeserializer.longDeserializer(), "total_size_bytes");
        op.add(Builder::primarySizeBytes, JsonpDeserializer.longDeserializer(), "primary_size_bytes");
        op.add(Builder::primaryShardSizeAvgBytes, JsonpDeserializer.longDeserializer(), "primary_shard_size_avg_bytes");
        op.add(Builder::primaryShardSizeMedianBytes, JsonpDeserializer.longDeserializer(), "primary_shard_size_median_bytes");
        op.add(Builder::primaryShardSizeMadBytes, JsonpDeserializer.longDeserializer(), "primary_shard_size_mad_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataTierPhaseStatistics> {
        private Long nodeCount;
        private Long indexCount;
        private Long totalShardCount;
        private Long primaryShardCount;
        private Long docCount;
        private Long totalSizeBytes;
        private Long primarySizeBytes;
        private Long primaryShardSizeAvgBytes;
        private Long primaryShardSizeMedianBytes;
        private Long primaryShardSizeMadBytes;

        public Builder() {
        }

        private Builder(DataTierPhaseStatistics instance) {
            this.nodeCount = instance.nodeCount;
            this.indexCount = instance.indexCount;
            this.totalShardCount = instance.totalShardCount;
            this.primaryShardCount = instance.primaryShardCount;
            this.docCount = instance.docCount;
            this.totalSizeBytes = instance.totalSizeBytes;
            this.primarySizeBytes = instance.primarySizeBytes;
            this.primaryShardSizeAvgBytes = instance.primaryShardSizeAvgBytes;
            this.primaryShardSizeMedianBytes = instance.primaryShardSizeMedianBytes;
            this.primaryShardSizeMadBytes = instance.primaryShardSizeMadBytes;
        }

        public final Builder nodeCount(long value) {
            this.nodeCount = value;
            return this;
        }

        public final Builder indexCount(long value) {
            this.indexCount = value;
            return this;
        }

        public final Builder totalShardCount(long value) {
            this.totalShardCount = value;
            return this;
        }

        public final Builder primaryShardCount(long value) {
            this.primaryShardCount = value;
            return this;
        }

        public final Builder docCount(long value) {
            this.docCount = value;
            return this;
        }

        public final Builder totalSizeBytes(long value) {
            this.totalSizeBytes = value;
            return this;
        }

        public final Builder primarySizeBytes(long value) {
            this.primarySizeBytes = value;
            return this;
        }

        public final Builder primaryShardSizeAvgBytes(long value) {
            this.primaryShardSizeAvgBytes = value;
            return this;
        }

        public final Builder primaryShardSizeMedianBytes(long value) {
            this.primaryShardSizeMedianBytes = value;
            return this;
        }

        public final Builder primaryShardSizeMadBytes(long value) {
            this.primaryShardSizeMadBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataTierPhaseStatistics build() {
            this._checkSingleUse();
            return new DataTierPhaseStatistics(this);
        }
    }
}

