/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ThrottleState
implements JsonpSerializable {
    private final String reason;
    private final DateTime timestamp;
    public static final JsonpDeserializer<ThrottleState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ThrottleState::setupThrottleStateDeserializer);

    private ThrottleState(Builder builder) {
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static ThrottleState of(Function<Builder, ObjectBuilder<ThrottleState>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String reason() {
        return this.reason;
    }

    public final DateTime timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("timestamp");
        this.timestamp.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupThrottleStateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::timestamp, DateTime._DESERIALIZER, "timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ThrottleState> {
        private String reason;
        private DateTime timestamp;

        public Builder() {
        }

        private Builder(ThrottleState instance) {
            this.reason = instance.reason;
            this.timestamp = instance.timestamp;
        }

        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public final Builder timestamp(DateTime value) {
            this.timestamp = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ThrottleState build() {
            this._checkSingleUse();
            return new ThrottleState(this);
        }
    }
}

