/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.transform.DeleteTransformResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteTransformRequest
extends RequestBase {
    @Nullable
    private final Boolean deleteDestIndex;
    @Nullable
    private final Boolean force;
    @Nullable
    private final Time timeout;
    private final String transformId;
    public static final Endpoint<DeleteTransformRequest, DeleteTransformResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteTransformRequest, DeleteTransformResponse>("es/transform.delete_transform", request -> "DELETE", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("transformId", request.transformId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.deleteDestIndex != null) {
            params.put("delete_dest_index", String.valueOf(request.deleteDestIndex));
        }
        if (request.force != null) {
            params.put("force", String.valueOf(request.force));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteTransformResponse._DESERIALIZER);

    private DeleteTransformRequest(Builder builder) {
        this.deleteDestIndex = builder.deleteDestIndex;
        this.force = builder.force;
        this.timeout = builder.timeout;
        this.transformId = ApiTypeHelper.requireNonNull(builder.transformId, this, "transformId");
    }

    public static DeleteTransformRequest of(Function<Builder, ObjectBuilder<DeleteTransformRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean deleteDestIndex() {
        return this.deleteDestIndex;
    }

    @Nullable
    public final Boolean force() {
        return this.force;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final String transformId() {
        return this.transformId;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteTransformRequest> {
        @Nullable
        private Boolean deleteDestIndex;
        @Nullable
        private Boolean force;
        @Nullable
        private Time timeout;
        private String transformId;

        public Builder() {
        }

        private Builder(DeleteTransformRequest instance) {
            this.deleteDestIndex = instance.deleteDestIndex;
            this.force = instance.force;
            this.timeout = instance.timeout;
            this.transformId = instance.transformId;
        }

        public final Builder deleteDestIndex(@Nullable Boolean value) {
            this.deleteDestIndex = value;
            return this;
        }

        public final Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder transformId(String value) {
            this.transformId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteTransformRequest build() {
            this._checkSingleUse();
            return new DeleteTransformRequest(this);
        }
    }
}

