/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure.test_grok_pattern;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class MatchedField
implements JsonpSerializable {
    private final String match;
    private final int offset;
    private final int length;
    public static final JsonpDeserializer<MatchedField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatchedField::setupMatchedFieldDeserializer);

    private MatchedField(Builder builder) {
        this.match = ApiTypeHelper.requireNonNull(builder.match, this, "match");
        this.offset = ApiTypeHelper.requireNonNull(builder.offset, (Object)this, "offset", 0);
        this.length = ApiTypeHelper.requireNonNull(builder.length, (Object)this, "length", 0);
    }

    public static MatchedField of(Function<Builder, ObjectBuilder<MatchedField>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String match() {
        return this.match;
    }

    public final int offset() {
        return this.offset;
    }

    public final int length() {
        return this.length;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("match");
        generator.write(this.match);
        generator.writeKey("offset");
        generator.write(this.offset);
        generator.writeKey("length");
        generator.write(this.length);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMatchedFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::match, JsonpDeserializer.stringDeserializer(), "match");
        op.add(Builder::offset, JsonpDeserializer.integerDeserializer(), "offset");
        op.add(Builder::length, JsonpDeserializer.integerDeserializer(), "length");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MatchedField> {
        private String match;
        private Integer offset;
        private Integer length;

        public Builder() {
        }

        private Builder(MatchedField instance) {
            this.match = instance.match;
            this.offset = instance.offset;
            this.length = instance.length;
        }

        public final Builder match(String value) {
            this.match = value;
            return this;
        }

        public final Builder offset(int value) {
            this.offset = value;
            return this;
        }

        public final Builder length(int value) {
            this.length = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MatchedField build() {
            this._checkSingleUse();
            return new MatchedField(this);
        }
    }
}

