/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.text_structure.EcsCompatibilityType;
import co.elastic.clients.elasticsearch.text_structure.FindFieldStructureResponse;
import co.elastic.clients.elasticsearch.text_structure.FormatType;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class FindFieldStructureRequest
extends RequestBase {
    private final List<String> columnNames;
    @Nullable
    private final String delimiter;
    @Nullable
    private final Number documentsToSample;
    @Nullable
    private final EcsCompatibilityType ecsCompatibility;
    @Nullable
    private final Boolean explain;
    private final String field;
    @Nullable
    private final FormatType format;
    @Nullable
    private final String grokPattern;
    private final String index;
    @Nullable
    private final String quote;
    @Nullable
    private final Boolean shouldTrimFields;
    @Nullable
    private final Time timeout;
    @Nullable
    private final String timestampField;
    @Nullable
    private final String timestampFormat;
    public static final Endpoint<FindFieldStructureRequest, FindFieldStructureResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<FindFieldStructureRequest, FindFieldStructureResponse>("es/text_structure.find_field_structure", request -> "GET", request -> "/_text_structure/find_field_structure", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.explain != null) {
            params.put("explain", String.valueOf(request.explain));
        }
        if (request.format != null) {
            params.put("format", request.format.jsonValue());
        }
        params.put("index", request.index);
        if (request.timestampField != null) {
            params.put("timestamp_field", request.timestampField);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (request.timestampFormat != null) {
            params.put("timestamp_format", request.timestampFormat);
        }
        if (request.quote != null) {
            params.put("quote", request.quote);
        }
        if (request.shouldTrimFields != null) {
            params.put("should_trim_fields", String.valueOf(request.shouldTrimFields));
        }
        params.put("field", request.field);
        if (request.grokPattern != null) {
            params.put("grok_pattern", request.grokPattern);
        }
        if (request.delimiter != null) {
            params.put("delimiter", request.delimiter);
        }
        if (ApiTypeHelper.isDefined(request.columnNames)) {
            params.put("column_names", request.columnNames.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.documentsToSample != null) {
            params.put("documents_to_sample", request.documentsToSample.toString());
        }
        if (request.ecsCompatibility != null) {
            params.put("ecs_compatibility", request.ecsCompatibility.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, FindFieldStructureResponse._DESERIALIZER);

    private FindFieldStructureRequest(Builder builder) {
        this.columnNames = ApiTypeHelper.unmodifiable(builder.columnNames);
        this.delimiter = builder.delimiter;
        this.documentsToSample = builder.documentsToSample;
        this.ecsCompatibility = builder.ecsCompatibility;
        this.explain = builder.explain;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.format = builder.format;
        this.grokPattern = builder.grokPattern;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.quote = builder.quote;
        this.shouldTrimFields = builder.shouldTrimFields;
        this.timeout = builder.timeout;
        this.timestampField = builder.timestampField;
        this.timestampFormat = builder.timestampFormat;
    }

    public static FindFieldStructureRequest of(Function<Builder, ObjectBuilder<FindFieldStructureRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> columnNames() {
        return this.columnNames;
    }

    @Nullable
    public final String delimiter() {
        return this.delimiter;
    }

    @Nullable
    public final Number documentsToSample() {
        return this.documentsToSample;
    }

    @Nullable
    public final EcsCompatibilityType ecsCompatibility() {
        return this.ecsCompatibility;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final FormatType format() {
        return this.format;
    }

    @Nullable
    public final String grokPattern() {
        return this.grokPattern;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String quote() {
        return this.quote;
    }

    @Nullable
    public final Boolean shouldTrimFields() {
        return this.shouldTrimFields;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final String timestampField() {
        return this.timestampField;
    }

    @Nullable
    public final String timestampFormat() {
        return this.timestampFormat;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FindFieldStructureRequest> {
        @Nullable
        private List<String> columnNames;
        @Nullable
        private String delimiter;
        @Nullable
        private Number documentsToSample;
        @Nullable
        private EcsCompatibilityType ecsCompatibility;
        @Nullable
        private Boolean explain;
        private String field;
        @Nullable
        private FormatType format;
        @Nullable
        private String grokPattern;
        private String index;
        @Nullable
        private String quote;
        @Nullable
        private Boolean shouldTrimFields;
        @Nullable
        private Time timeout;
        @Nullable
        private String timestampField;
        @Nullable
        private String timestampFormat;

        public Builder() {
        }

        private Builder(FindFieldStructureRequest instance) {
            this.columnNames = instance.columnNames;
            this.delimiter = instance.delimiter;
            this.documentsToSample = instance.documentsToSample;
            this.ecsCompatibility = instance.ecsCompatibility;
            this.explain = instance.explain;
            this.field = instance.field;
            this.format = instance.format;
            this.grokPattern = instance.grokPattern;
            this.index = instance.index;
            this.quote = instance.quote;
            this.shouldTrimFields = instance.shouldTrimFields;
            this.timeout = instance.timeout;
            this.timestampField = instance.timestampField;
            this.timestampFormat = instance.timestampFormat;
        }

        public final Builder columnNames(List<String> list) {
            this.columnNames = Builder._listAddAll(this.columnNames, list);
            return this;
        }

        public final Builder columnNames(String value, String ... values) {
            this.columnNames = Builder._listAdd(this.columnNames, value, values);
            return this;
        }

        public final Builder delimiter(@Nullable String value) {
            this.delimiter = value;
            return this;
        }

        public final Builder documentsToSample(@Nullable Number value) {
            this.documentsToSample = value;
            return this;
        }

        public final Builder ecsCompatibility(@Nullable EcsCompatibilityType value) {
            this.ecsCompatibility = value;
            return this;
        }

        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder format(@Nullable FormatType value) {
            this.format = value;
            return this;
        }

        public final Builder grokPattern(@Nullable String value) {
            this.grokPattern = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder quote(@Nullable String value) {
            this.quote = value;
            return this;
        }

        public final Builder shouldTrimFields(@Nullable Boolean value) {
            this.shouldTrimFields = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder timestampField(@Nullable String value) {
            this.timestampField = value;
            return this;
        }

        public final Builder timestampFormat(@Nullable String value) {
            this.timestampFormat = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FindFieldStructureRequest build() {
            this._checkSingleUse();
            return new FindFieldStructureRequest(this);
        }
    }
}

