/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.synonyms;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.synonyms.PutSynonymRuleResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutSynonymRuleRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean refresh;
    private final String ruleId;
    private final String setId;
    private final String synonyms;
    public static final JsonpDeserializer<PutSynonymRuleRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutSynonymRuleRequest::setupPutSynonymRuleRequestDeserializer);
    public static final Endpoint<PutSynonymRuleRequest, PutSynonymRuleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutSynonymRuleRequest, PutSynonymRuleResponse>("es/synonyms.put_synonym_rule", request -> "PUT", request -> {
        boolean _ruleId = true;
        int _setId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_synonyms");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.setId, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.ruleId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _ruleId = true;
        int _setId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("setId", request.setId);
            params.put("ruleId", request.ruleId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", String.valueOf(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutSynonymRuleResponse._DESERIALIZER);

    private PutSynonymRuleRequest(Builder builder) {
        this.refresh = builder.refresh;
        this.ruleId = ApiTypeHelper.requireNonNull(builder.ruleId, this, "ruleId");
        this.setId = ApiTypeHelper.requireNonNull(builder.setId, this, "setId");
        this.synonyms = ApiTypeHelper.requireNonNull(builder.synonyms, this, "synonyms");
    }

    public static PutSynonymRuleRequest of(Function<Builder, ObjectBuilder<PutSynonymRuleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean refresh() {
        return this.refresh;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final String setId() {
        return this.setId;
    }

    public final String synonyms() {
        return this.synonyms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("synonyms");
        generator.write(this.synonyms);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutSynonymRuleRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::synonyms, JsonpDeserializer.stringDeserializer(), "synonyms");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutSynonymRuleRequest> {
        @Nullable
        private Boolean refresh;
        private String ruleId;
        private String setId;
        private String synonyms;

        public Builder() {
        }

        private Builder(PutSynonymRuleRequest instance) {
            this.refresh = instance.refresh;
            this.ruleId = instance.ruleId;
            this.setId = instance.setId;
            this.synonyms = instance.synonyms;
        }

        public final Builder refresh(@Nullable Boolean value) {
            this.refresh = value;
            return this;
        }

        public final Builder ruleId(String value) {
            this.ruleId = value;
            return this;
        }

        public final Builder setId(String value) {
            this.setId = value;
            return this;
        }

        public final Builder synonyms(String value) {
            this.synonyms = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutSynonymRuleRequest build() {
            this._checkSingleUse();
            return new PutSynonymRuleRequest(this);
        }
    }
}

