/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot.repository_analyze;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SnapshotNodeInfo
implements JsonpSerializable {
    private final String id;
    private final String name;
    public static final JsonpDeserializer<SnapshotNodeInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotNodeInfo::setupSnapshotNodeInfoDeserializer);

    private SnapshotNodeInfo(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static SnapshotNodeInfo of(Function<Builder, ObjectBuilder<SnapshotNodeInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("name");
        generator.write(this.name);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSnapshotNodeInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotNodeInfo> {
        private String id;
        private String name;

        public Builder() {
        }

        private Builder(SnapshotNodeInfo instance) {
            this.id = instance.id;
            this.name = instance.name;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotNodeInfo build() {
            this._checkSingleUse();
            return new SnapshotNodeInfo(this);
        }
    }
}

