/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.IndexDetails;
import co.elastic.clients.elasticsearch.snapshot.InfoFeatureState;
import co.elastic.clients.elasticsearch.snapshot.SnapshotShardFailure;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SnapshotInfo
implements JsonpSerializable {
    private final List<String> dataStreams;
    @Nullable
    private final Time duration;
    @Nullable
    private final Long durationInMillis;
    @Nullable
    private final DateTime endTime;
    @Nullable
    private final Long endTimeInMillis;
    private final List<SnapshotShardFailure> failures;
    @Nullable
    private final Boolean includeGlobalState;
    private final List<String> indices;
    private final Map<String, IndexDetails> indexDetails;
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String reason;
    @Nullable
    private final String repository;
    private final String snapshot;
    @Nullable
    private final ShardStatistics shards;
    @Nullable
    private final DateTime startTime;
    @Nullable
    private final Long startTimeInMillis;
    @Nullable
    private final String state;
    private final String uuid;
    @Nullable
    private final String version;
    @Nullable
    private final Long versionId;
    private final List<InfoFeatureState> featureStates;
    public static final JsonpDeserializer<SnapshotInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotInfo::setupSnapshotInfoDeserializer);

    private SnapshotInfo(Builder builder) {
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
        this.duration = builder.duration;
        this.durationInMillis = builder.durationInMillis;
        this.endTime = builder.endTime;
        this.endTimeInMillis = builder.endTimeInMillis;
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
        this.includeGlobalState = builder.includeGlobalState;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.indexDetails = ApiTypeHelper.unmodifiable(builder.indexDetails);
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.reason = builder.reason;
        this.repository = builder.repository;
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.shards = builder.shards;
        this.startTime = builder.startTime;
        this.startTimeInMillis = builder.startTimeInMillis;
        this.state = builder.state;
        this.uuid = ApiTypeHelper.requireNonNull(builder.uuid, this, "uuid");
        this.version = builder.version;
        this.versionId = builder.versionId;
        this.featureStates = ApiTypeHelper.unmodifiable(builder.featureStates);
    }

    public static SnapshotInfo of(Function<Builder, ObjectBuilder<SnapshotInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> dataStreams() {
        return this.dataStreams;
    }

    @Nullable
    public final Time duration() {
        return this.duration;
    }

    @Nullable
    public final Long durationInMillis() {
        return this.durationInMillis;
    }

    @Nullable
    public final DateTime endTime() {
        return this.endTime;
    }

    @Nullable
    public final Long endTimeInMillis() {
        return this.endTimeInMillis;
    }

    public final List<SnapshotShardFailure> failures() {
        return this.failures;
    }

    @Nullable
    public final Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final Map<String, IndexDetails> indexDetails() {
        return this.indexDetails;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    @Nullable
    public final String repository() {
        return this.repository;
    }

    public final String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Nullable
    public final DateTime startTime() {
        return this.startTime;
    }

    @Nullable
    public final Long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public final String state() {
        return this.state;
    }

    public final String uuid() {
        return this.uuid;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Nullable
    public final Long versionId() {
        return this.versionId;
    }

    public final List<InfoFeatureState> featureStates() {
        return this.featureStates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.dataStreams)) {
            generator.writeKey("data_streams");
            generator.writeStartArray();
            for (String string : this.dataStreams) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.duration != null) {
            generator.writeKey("duration");
            this.duration.serialize(generator, mapper);
        }
        if (this.durationInMillis != null) {
            generator.writeKey("duration_in_millis");
            generator.write(this.durationInMillis.longValue());
        }
        if (this.endTime != null) {
            generator.writeKey("end_time");
            this.endTime.serialize(generator, mapper);
        }
        if (this.endTimeInMillis != null) {
            generator.writeKey("end_time_in_millis");
            generator.write(this.endTimeInMillis.longValue());
        }
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (SnapshotShardFailure snapshotShardFailure : this.failures) {
                snapshotShardFailure.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.includeGlobalState != null) {
            generator.writeKey("include_global_state");
            generator.write(this.includeGlobalState.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indexDetails)) {
            generator.writeKey("index_details");
            generator.writeStartObject();
            for (Map.Entry entry : this.indexDetails.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((IndexDetails)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        if (this.repository != null) {
            generator.writeKey("repository");
            generator.write(this.repository);
        }
        generator.writeKey("snapshot");
        generator.write(this.snapshot);
        if (this.shards != null) {
            generator.writeKey("shards");
            this.shards.serialize(generator, mapper);
        }
        if (this.startTime != null) {
            generator.writeKey("start_time");
            this.startTime.serialize(generator, mapper);
        }
        if (this.startTimeInMillis != null) {
            generator.writeKey("start_time_in_millis");
            generator.write(this.startTimeInMillis.longValue());
        }
        if (this.state != null) {
            generator.writeKey("state");
            generator.write(this.state);
        }
        generator.writeKey("uuid");
        generator.write(this.uuid);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.versionId != null) {
            generator.writeKey("version_id");
            generator.write(this.versionId.longValue());
        }
        if (ApiTypeHelper.isDefined(this.featureStates)) {
            generator.writeKey("feature_states");
            generator.writeStartArray();
            for (InfoFeatureState infoFeatureState : this.featureStates) {
                infoFeatureState.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSnapshotInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "data_streams");
        op.add(Builder::duration, Time._DESERIALIZER, "duration");
        op.add(Builder::durationInMillis, JsonpDeserializer.longDeserializer(), "duration_in_millis");
        op.add(Builder::endTime, DateTime._DESERIALIZER, "end_time");
        op.add(Builder::endTimeInMillis, JsonpDeserializer.longDeserializer(), "end_time_in_millis");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(SnapshotShardFailure._DESERIALIZER), "failures");
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::indexDetails, JsonpDeserializer.stringMapDeserializer(IndexDetails._DESERIALIZER), "index_details");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository");
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "shards");
        op.add(Builder::startTime, DateTime._DESERIALIZER, "start_time");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state");
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::versionId, JsonpDeserializer.longDeserializer(), "version_id");
        op.add(Builder::featureStates, JsonpDeserializer.arrayDeserializer(InfoFeatureState._DESERIALIZER), "feature_states");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotInfo> {
        private List<String> dataStreams;
        @Nullable
        private Time duration;
        @Nullable
        private Long durationInMillis;
        @Nullable
        private DateTime endTime;
        @Nullable
        private Long endTimeInMillis;
        @Nullable
        private List<SnapshotShardFailure> failures;
        @Nullable
        private Boolean includeGlobalState;
        @Nullable
        private List<String> indices;
        @Nullable
        private Map<String, IndexDetails> indexDetails;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String reason;
        @Nullable
        private String repository;
        private String snapshot;
        @Nullable
        private ShardStatistics shards;
        @Nullable
        private DateTime startTime;
        @Nullable
        private Long startTimeInMillis;
        @Nullable
        private String state;
        private String uuid;
        @Nullable
        private String version;
        @Nullable
        private Long versionId;
        @Nullable
        private List<InfoFeatureState> featureStates;

        public Builder() {
        }

        private Builder(SnapshotInfo instance) {
            this.dataStreams = instance.dataStreams;
            this.duration = instance.duration;
            this.durationInMillis = instance.durationInMillis;
            this.endTime = instance.endTime;
            this.endTimeInMillis = instance.endTimeInMillis;
            this.failures = instance.failures;
            this.includeGlobalState = instance.includeGlobalState;
            this.indices = instance.indices;
            this.indexDetails = instance.indexDetails;
            this.metadata = instance.metadata;
            this.reason = instance.reason;
            this.repository = instance.repository;
            this.snapshot = instance.snapshot;
            this.shards = instance.shards;
            this.startTime = instance.startTime;
            this.startTimeInMillis = instance.startTimeInMillis;
            this.state = instance.state;
            this.uuid = instance.uuid;
            this.version = instance.version;
            this.versionId = instance.versionId;
            this.featureStates = instance.featureStates;
        }

        public final Builder dataStreams(List<String> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        public final Builder dataStreams(String value, String ... values) {
            this.dataStreams = Builder._listAdd(this.dataStreams, value, values);
            return this;
        }

        public final Builder duration(@Nullable Time value) {
            this.duration = value;
            return this;
        }

        public final Builder duration(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.duration(fn.apply(new Time.Builder()).build());
        }

        public final Builder durationInMillis(@Nullable Long value) {
            this.durationInMillis = value;
            return this;
        }

        public final Builder endTime(@Nullable DateTime value) {
            this.endTime = value;
            return this;
        }

        public final Builder endTimeInMillis(@Nullable Long value) {
            this.endTimeInMillis = value;
            return this;
        }

        public final Builder failures(List<SnapshotShardFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        public final Builder failures(SnapshotShardFailure value, SnapshotShardFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        public final Builder failures(Function<SnapshotShardFailure.Builder, ObjectBuilder<SnapshotShardFailure>> fn) {
            return this.failures(fn.apply(new SnapshotShardFailure.Builder()).build(), new SnapshotShardFailure[0]);
        }

        public final Builder includeGlobalState(@Nullable Boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indexDetails(Map<String, IndexDetails> map) {
            this.indexDetails = Builder._mapPutAll(this.indexDetails, map);
            return this;
        }

        public final Builder indexDetails(String key, IndexDetails value) {
            this.indexDetails = Builder._mapPut(this.indexDetails, key, value);
            return this;
        }

        public final Builder indexDetails(String key, Function<IndexDetails.Builder, ObjectBuilder<IndexDetails>> fn) {
            return this.indexDetails(key, fn.apply(new IndexDetails.Builder()).build());
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        public final Builder repository(@Nullable String value) {
            this.repository = value;
            return this;
        }

        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public final Builder shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder startTime(@Nullable DateTime value) {
            this.startTime = value;
            return this;
        }

        public final Builder startTimeInMillis(@Nullable Long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public final Builder state(@Nullable String value) {
            this.state = value;
            return this;
        }

        public final Builder uuid(String value) {
            this.uuid = value;
            return this;
        }

        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public final Builder versionId(@Nullable Long value) {
            this.versionId = value;
            return this;
        }

        public final Builder featureStates(List<InfoFeatureState> list) {
            this.featureStates = Builder._listAddAll(this.featureStates, list);
            return this;
        }

        public final Builder featureStates(InfoFeatureState value, InfoFeatureState ... values) {
            this.featureStates = Builder._listAdd(this.featureStates, value, values);
            return this;
        }

        public final Builder featureStates(Function<InfoFeatureState.Builder, ObjectBuilder<InfoFeatureState>> fn) {
            return this.featureStates(fn.apply(new InfoFeatureState.Builder()).build(), new InfoFeatureState[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotInfo build() {
            this._checkSingleUse();
            return new SnapshotInfo(this);
        }
    }
}

