/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.RepositorySettingsBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class S3RepositorySettings
extends RepositorySettingsBase {
    private final String bucket;
    @Nullable
    private final String basePath;
    @Nullable
    private final String bufferSize;
    @Nullable
    private final String cannedAcl;
    @Nullable
    private final String client;
    @Nullable
    private final Integer deleteObjectsMaxSize;
    @Nullable
    private final Time getRegisterRetryDelay;
    @Nullable
    private final Integer maxMultipartParts;
    @Nullable
    private final Integer maxMultipartUploadCleanupSize;
    @Nullable
    private final Boolean readonly;
    @Nullable
    private final Boolean serverSideEncryption;
    @Nullable
    private final String storageClass;
    @Nullable
    private final Time throttledDeleteRetryDelayIncrement;
    @Nullable
    private final Time throttledDeleteRetryMaximumDelay;
    @Nullable
    private final Integer throttledDeleteRetryMaximumNumberOfRetries;
    public static final JsonpDeserializer<S3RepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, S3RepositorySettings::setupS3RepositorySettingsDeserializer);

    private S3RepositorySettings(Builder builder) {
        super(builder);
        this.bucket = ApiTypeHelper.requireNonNull(builder.bucket, this, "bucket");
        this.basePath = builder.basePath;
        this.bufferSize = builder.bufferSize;
        this.cannedAcl = builder.cannedAcl;
        this.client = builder.client;
        this.deleteObjectsMaxSize = builder.deleteObjectsMaxSize;
        this.getRegisterRetryDelay = builder.getRegisterRetryDelay;
        this.maxMultipartParts = builder.maxMultipartParts;
        this.maxMultipartUploadCleanupSize = builder.maxMultipartUploadCleanupSize;
        this.readonly = builder.readonly;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.storageClass = builder.storageClass;
        this.throttledDeleteRetryDelayIncrement = builder.throttledDeleteRetryDelayIncrement;
        this.throttledDeleteRetryMaximumDelay = builder.throttledDeleteRetryMaximumDelay;
        this.throttledDeleteRetryMaximumNumberOfRetries = builder.throttledDeleteRetryMaximumNumberOfRetries;
    }

    public static S3RepositorySettings of(Function<Builder, ObjectBuilder<S3RepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String bucket() {
        return this.bucket;
    }

    @Nullable
    public final String basePath() {
        return this.basePath;
    }

    @Nullable
    public final String bufferSize() {
        return this.bufferSize;
    }

    @Nullable
    public final String cannedAcl() {
        return this.cannedAcl;
    }

    @Nullable
    public final String client() {
        return this.client;
    }

    @Nullable
    public final Integer deleteObjectsMaxSize() {
        return this.deleteObjectsMaxSize;
    }

    @Nullable
    public final Time getRegisterRetryDelay() {
        return this.getRegisterRetryDelay;
    }

    @Nullable
    public final Integer maxMultipartParts() {
        return this.maxMultipartParts;
    }

    @Nullable
    public final Integer maxMultipartUploadCleanupSize() {
        return this.maxMultipartUploadCleanupSize;
    }

    @Nullable
    public final Boolean readonly() {
        return this.readonly;
    }

    @Nullable
    public final Boolean serverSideEncryption() {
        return this.serverSideEncryption;
    }

    @Nullable
    public final String storageClass() {
        return this.storageClass;
    }

    @Nullable
    public final Time throttledDeleteRetryDelayIncrement() {
        return this.throttledDeleteRetryDelayIncrement;
    }

    @Nullable
    public final Time throttledDeleteRetryMaximumDelay() {
        return this.throttledDeleteRetryMaximumDelay;
    }

    @Nullable
    public final Integer throttledDeleteRetryMaximumNumberOfRetries() {
        return this.throttledDeleteRetryMaximumNumberOfRetries;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("bucket");
        generator.write(this.bucket);
        if (this.basePath != null) {
            generator.writeKey("base_path");
            generator.write(this.basePath);
        }
        if (this.bufferSize != null) {
            generator.writeKey("buffer_size");
            generator.write(this.bufferSize);
        }
        if (this.cannedAcl != null) {
            generator.writeKey("canned_acl");
            generator.write(this.cannedAcl);
        }
        if (this.client != null) {
            generator.writeKey("client");
            generator.write(this.client);
        }
        if (this.deleteObjectsMaxSize != null) {
            generator.writeKey("delete_objects_max_size");
            generator.write(this.deleteObjectsMaxSize.intValue());
        }
        if (this.getRegisterRetryDelay != null) {
            generator.writeKey("get_register_retry_delay");
            this.getRegisterRetryDelay.serialize(generator, mapper);
        }
        if (this.maxMultipartParts != null) {
            generator.writeKey("max_multipart_parts");
            generator.write(this.maxMultipartParts.intValue());
        }
        if (this.maxMultipartUploadCleanupSize != null) {
            generator.writeKey("max_multipart_upload_cleanup_size");
            generator.write(this.maxMultipartUploadCleanupSize.intValue());
        }
        if (this.readonly != null) {
            generator.writeKey("readonly");
            generator.write(this.readonly.booleanValue());
        }
        if (this.serverSideEncryption != null) {
            generator.writeKey("server_side_encryption");
            generator.write(this.serverSideEncryption.booleanValue());
        }
        if (this.storageClass != null) {
            generator.writeKey("storage_class");
            generator.write(this.storageClass);
        }
        if (this.throttledDeleteRetryDelayIncrement != null) {
            generator.writeKey("throttled_delete_retry.delay_increment");
            this.throttledDeleteRetryDelayIncrement.serialize(generator, mapper);
        }
        if (this.throttledDeleteRetryMaximumDelay != null) {
            generator.writeKey("throttled_delete_retry.maximum_delay");
            this.throttledDeleteRetryMaximumDelay.serialize(generator, mapper);
        }
        if (this.throttledDeleteRetryMaximumNumberOfRetries != null) {
            generator.writeKey("throttled_delete_retry.maximum_number_of_retries");
            generator.write(this.throttledDeleteRetryMaximumNumberOfRetries.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupS3RepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        RepositorySettingsBase.setupRepositorySettingsBaseDeserializer(op);
        op.add(Builder::bucket, JsonpDeserializer.stringDeserializer(), "bucket");
        op.add(Builder::basePath, JsonpDeserializer.stringDeserializer(), "base_path");
        op.add(Builder::bufferSize, JsonpDeserializer.stringDeserializer(), "buffer_size");
        op.add(Builder::cannedAcl, JsonpDeserializer.stringDeserializer(), "canned_acl");
        op.add(Builder::client, JsonpDeserializer.stringDeserializer(), "client");
        op.add(Builder::deleteObjectsMaxSize, JsonpDeserializer.integerDeserializer(), "delete_objects_max_size");
        op.add(Builder::getRegisterRetryDelay, Time._DESERIALIZER, "get_register_retry_delay");
        op.add(Builder::maxMultipartParts, JsonpDeserializer.integerDeserializer(), "max_multipart_parts");
        op.add(Builder::maxMultipartUploadCleanupSize, JsonpDeserializer.integerDeserializer(), "max_multipart_upload_cleanup_size");
        op.add(Builder::readonly, JsonpDeserializer.booleanDeserializer(), "readonly");
        op.add(Builder::serverSideEncryption, JsonpDeserializer.booleanDeserializer(), "server_side_encryption");
        op.add(Builder::storageClass, JsonpDeserializer.stringDeserializer(), "storage_class");
        op.add(Builder::throttledDeleteRetryDelayIncrement, Time._DESERIALIZER, "throttled_delete_retry.delay_increment");
        op.add(Builder::throttledDeleteRetryMaximumDelay, Time._DESERIALIZER, "throttled_delete_retry.maximum_delay");
        op.add(Builder::throttledDeleteRetryMaximumNumberOfRetries, JsonpDeserializer.integerDeserializer(), "throttled_delete_retry.maximum_number_of_retries");
    }

    public static class Builder
    extends RepositorySettingsBase.AbstractBuilder<Builder>
    implements ObjectBuilder<S3RepositorySettings> {
        private String bucket;
        @Nullable
        private String basePath;
        @Nullable
        private String bufferSize;
        @Nullable
        private String cannedAcl;
        @Nullable
        private String client;
        @Nullable
        private Integer deleteObjectsMaxSize;
        @Nullable
        private Time getRegisterRetryDelay;
        @Nullable
        private Integer maxMultipartParts;
        @Nullable
        private Integer maxMultipartUploadCleanupSize;
        @Nullable
        private Boolean readonly;
        @Nullable
        private Boolean serverSideEncryption;
        @Nullable
        private String storageClass;
        @Nullable
        private Time throttledDeleteRetryDelayIncrement;
        @Nullable
        private Time throttledDeleteRetryMaximumDelay;
        @Nullable
        private Integer throttledDeleteRetryMaximumNumberOfRetries;

        public Builder() {
        }

        private Builder(S3RepositorySettings instance) {
            this.bucket = instance.bucket;
            this.basePath = instance.basePath;
            this.bufferSize = instance.bufferSize;
            this.cannedAcl = instance.cannedAcl;
            this.client = instance.client;
            this.deleteObjectsMaxSize = instance.deleteObjectsMaxSize;
            this.getRegisterRetryDelay = instance.getRegisterRetryDelay;
            this.maxMultipartParts = instance.maxMultipartParts;
            this.maxMultipartUploadCleanupSize = instance.maxMultipartUploadCleanupSize;
            this.readonly = instance.readonly;
            this.serverSideEncryption = instance.serverSideEncryption;
            this.storageClass = instance.storageClass;
            this.throttledDeleteRetryDelayIncrement = instance.throttledDeleteRetryDelayIncrement;
            this.throttledDeleteRetryMaximumDelay = instance.throttledDeleteRetryMaximumDelay;
            this.throttledDeleteRetryMaximumNumberOfRetries = instance.throttledDeleteRetryMaximumNumberOfRetries;
        }

        public final Builder bucket(String value) {
            this.bucket = value;
            return this;
        }

        public final Builder basePath(@Nullable String value) {
            this.basePath = value;
            return this;
        }

        public final Builder bufferSize(@Nullable String value) {
            this.bufferSize = value;
            return this;
        }

        public final Builder cannedAcl(@Nullable String value) {
            this.cannedAcl = value;
            return this;
        }

        public final Builder client(@Nullable String value) {
            this.client = value;
            return this;
        }

        public final Builder deleteObjectsMaxSize(@Nullable Integer value) {
            this.deleteObjectsMaxSize = value;
            return this;
        }

        public final Builder getRegisterRetryDelay(@Nullable Time value) {
            this.getRegisterRetryDelay = value;
            return this;
        }

        public final Builder getRegisterRetryDelay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.getRegisterRetryDelay(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxMultipartParts(@Nullable Integer value) {
            this.maxMultipartParts = value;
            return this;
        }

        public final Builder maxMultipartUploadCleanupSize(@Nullable Integer value) {
            this.maxMultipartUploadCleanupSize = value;
            return this;
        }

        public final Builder readonly(@Nullable Boolean value) {
            this.readonly = value;
            return this;
        }

        public final Builder serverSideEncryption(@Nullable Boolean value) {
            this.serverSideEncryption = value;
            return this;
        }

        public final Builder storageClass(@Nullable String value) {
            this.storageClass = value;
            return this;
        }

        public final Builder throttledDeleteRetryDelayIncrement(@Nullable Time value) {
            this.throttledDeleteRetryDelayIncrement = value;
            return this;
        }

        public final Builder throttledDeleteRetryDelayIncrement(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttledDeleteRetryDelayIncrement(fn.apply(new Time.Builder()).build());
        }

        public final Builder throttledDeleteRetryMaximumDelay(@Nullable Time value) {
            this.throttledDeleteRetryMaximumDelay = value;
            return this;
        }

        public final Builder throttledDeleteRetryMaximumDelay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttledDeleteRetryMaximumDelay(fn.apply(new Time.Builder()).build());
        }

        public final Builder throttledDeleteRetryMaximumNumberOfRetries(@Nullable Integer value) {
            this.throttledDeleteRetryMaximumNumberOfRetries = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public S3RepositorySettings build() {
            this._checkSingleUse();
            return new S3RepositorySettings(this);
        }
    }
}

