/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.RepositorySettingsBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GcsRepositorySettings
extends RepositorySettingsBase {
    private final String bucket;
    @Nullable
    private final String applicationName;
    @Nullable
    private final String basePath;
    @Nullable
    private final String client;
    @Nullable
    private final Boolean readonly;
    public static final JsonpDeserializer<GcsRepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GcsRepositorySettings::setupGcsRepositorySettingsDeserializer);

    private GcsRepositorySettings(Builder builder) {
        super(builder);
        this.bucket = ApiTypeHelper.requireNonNull(builder.bucket, this, "bucket");
        this.applicationName = builder.applicationName;
        this.basePath = builder.basePath;
        this.client = builder.client;
        this.readonly = builder.readonly;
    }

    public static GcsRepositorySettings of(Function<Builder, ObjectBuilder<GcsRepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String bucket() {
        return this.bucket;
    }

    @Deprecated
    @Nullable
    public final String applicationName() {
        return this.applicationName;
    }

    @Nullable
    public final String basePath() {
        return this.basePath;
    }

    @Nullable
    public final String client() {
        return this.client;
    }

    @Nullable
    public final Boolean readonly() {
        return this.readonly;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("bucket");
        generator.write(this.bucket);
        if (this.applicationName != null) {
            generator.writeKey("application_name");
            generator.write(this.applicationName);
        }
        if (this.basePath != null) {
            generator.writeKey("base_path");
            generator.write(this.basePath);
        }
        if (this.client != null) {
            generator.writeKey("client");
            generator.write(this.client);
        }
        if (this.readonly != null) {
            generator.writeKey("readonly");
            generator.write(this.readonly.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGcsRepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        RepositorySettingsBase.setupRepositorySettingsBaseDeserializer(op);
        op.add(Builder::bucket, JsonpDeserializer.stringDeserializer(), "bucket");
        op.add(Builder::applicationName, JsonpDeserializer.stringDeserializer(), "application_name");
        op.add(Builder::basePath, JsonpDeserializer.stringDeserializer(), "base_path");
        op.add(Builder::client, JsonpDeserializer.stringDeserializer(), "client");
        op.add(Builder::readonly, JsonpDeserializer.booleanDeserializer(), "readonly");
    }

    public static class Builder
    extends RepositorySettingsBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GcsRepositorySettings> {
        private String bucket;
        @Nullable
        private String applicationName;
        @Nullable
        private String basePath;
        @Nullable
        private String client;
        @Nullable
        private Boolean readonly;

        public Builder() {
        }

        private Builder(GcsRepositorySettings instance) {
            this.bucket = instance.bucket;
            this.applicationName = instance.applicationName;
            this.basePath = instance.basePath;
            this.client = instance.client;
            this.readonly = instance.readonly;
        }

        public final Builder bucket(String value) {
            this.bucket = value;
            return this;
        }

        @Deprecated
        public final Builder applicationName(@Nullable String value) {
            this.applicationName = value;
            return this;
        }

        public final Builder basePath(@Nullable String value) {
            this.basePath = value;
            return this;
        }

        public final Builder client(@Nullable String value) {
            this.client = value;
            return this;
        }

        public final Builder readonly(@Nullable Boolean value) {
            this.readonly = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GcsRepositorySettings build() {
            this._checkSingleUse();
            return new GcsRepositorySettings(this);
        }
    }
}

