/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.get_token;

import co.elastic.clients.elasticsearch.security.User;
import co.elastic.clients.elasticsearch.security.get_token.AuthenticationProvider;
import co.elastic.clients.elasticsearch.security.get_token.UserRealm;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AuthenticatedUser
extends User {
    private final UserRealm authenticationRealm;
    private final UserRealm lookupRealm;
    @Nullable
    private final AuthenticationProvider authenticationProvider;
    private final String authenticationType;
    public static final JsonpDeserializer<AuthenticatedUser> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AuthenticatedUser::setupAuthenticatedUserDeserializer);

    private AuthenticatedUser(Builder builder) {
        super(builder);
        this.authenticationRealm = ApiTypeHelper.requireNonNull(builder.authenticationRealm, this, "authenticationRealm");
        this.lookupRealm = ApiTypeHelper.requireNonNull(builder.lookupRealm, this, "lookupRealm");
        this.authenticationProvider = builder.authenticationProvider;
        this.authenticationType = ApiTypeHelper.requireNonNull(builder.authenticationType, this, "authenticationType");
    }

    public static AuthenticatedUser of(Function<Builder, ObjectBuilder<AuthenticatedUser>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final UserRealm authenticationRealm() {
        return this.authenticationRealm;
    }

    public final UserRealm lookupRealm() {
        return this.lookupRealm;
    }

    @Nullable
    public final AuthenticationProvider authenticationProvider() {
        return this.authenticationProvider;
    }

    public final String authenticationType() {
        return this.authenticationType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("authentication_realm");
        this.authenticationRealm.serialize(generator, mapper);
        generator.writeKey("lookup_realm");
        this.lookupRealm.serialize(generator, mapper);
        if (this.authenticationProvider != null) {
            generator.writeKey("authentication_provider");
            this.authenticationProvider.serialize(generator, mapper);
        }
        generator.writeKey("authentication_type");
        generator.write(this.authenticationType);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAuthenticatedUserDeserializer(ObjectDeserializer<Builder> op) {
        User.setupUserDeserializer(op);
        op.add(Builder::authenticationRealm, UserRealm._DESERIALIZER, "authentication_realm");
        op.add(Builder::lookupRealm, UserRealm._DESERIALIZER, "lookup_realm");
        op.add(Builder::authenticationProvider, AuthenticationProvider._DESERIALIZER, "authentication_provider");
        op.add(Builder::authenticationType, JsonpDeserializer.stringDeserializer(), "authentication_type");
    }

    public static class Builder
    extends User.AbstractBuilder<Builder>
    implements ObjectBuilder<AuthenticatedUser> {
        private UserRealm authenticationRealm;
        private UserRealm lookupRealm;
        @Nullable
        private AuthenticationProvider authenticationProvider;
        private String authenticationType;

        public Builder() {
        }

        private Builder(AuthenticatedUser instance) {
            this.authenticationRealm = instance.authenticationRealm;
            this.lookupRealm = instance.lookupRealm;
            this.authenticationProvider = instance.authenticationProvider;
            this.authenticationType = instance.authenticationType;
        }

        public final Builder authenticationRealm(UserRealm value) {
            this.authenticationRealm = value;
            return this;
        }

        public final Builder authenticationRealm(Function<UserRealm.Builder, ObjectBuilder<UserRealm>> fn) {
            return this.authenticationRealm(fn.apply(new UserRealm.Builder()).build());
        }

        public final Builder lookupRealm(UserRealm value) {
            this.lookupRealm = value;
            return this;
        }

        public final Builder lookupRealm(Function<UserRealm.Builder, ObjectBuilder<UserRealm>> fn) {
            return this.lookupRealm(fn.apply(new UserRealm.Builder()).build());
        }

        public final Builder authenticationProvider(@Nullable AuthenticationProvider value) {
            this.authenticationProvider = value;
            return this;
        }

        public final Builder authenticationProvider(Function<AuthenticationProvider.Builder, ObjectBuilder<AuthenticationProvider>> fn) {
            return this.authenticationProvider(fn.apply(new AuthenticationProvider.Builder()).build());
        }

        public final Builder authenticationType(String value) {
            this.authenticationType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AuthenticatedUser build() {
            this._checkSingleUse();
            return new AuthenticatedUser(this);
        }
    }
}

