/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.delegate_pki;

import co.elastic.clients.elasticsearch.security.delegate_pki.AuthenticationRealm;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Authentication
implements JsonpSerializable {
    private final String username;
    private final List<String> roles;
    @Nullable
    private final String fullName;
    @Nullable
    private final String email;
    private final Map<String, String> token;
    private final Map<String, JsonData> metadata;
    private final boolean enabled;
    private final AuthenticationRealm authenticationRealm;
    private final AuthenticationRealm lookupRealm;
    private final String authenticationType;
    private final Map<String, String> apiKey;
    public static final JsonpDeserializer<Authentication> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Authentication::setupAuthenticationDeserializer);

    private Authentication(Builder builder) {
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.fullName = builder.fullName;
        this.email = builder.email;
        this.token = ApiTypeHelper.unmodifiable(builder.token);
        this.metadata = ApiTypeHelper.unmodifiableRequired(builder.metadata, (Object)this, "metadata");
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, (Object)this, "enabled", false);
        this.authenticationRealm = ApiTypeHelper.requireNonNull(builder.authenticationRealm, this, "authenticationRealm");
        this.lookupRealm = ApiTypeHelper.requireNonNull(builder.lookupRealm, this, "lookupRealm");
        this.authenticationType = ApiTypeHelper.requireNonNull(builder.authenticationType, this, "authenticationType");
        this.apiKey = ApiTypeHelper.unmodifiable(builder.apiKey);
    }

    public static Authentication of(Function<Builder, ObjectBuilder<Authentication>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String username() {
        return this.username;
    }

    public final List<String> roles() {
        return this.roles;
    }

    @Nullable
    public final String fullName() {
        return this.fullName;
    }

    @Nullable
    public final String email() {
        return this.email;
    }

    public final Map<String, String> token() {
        return this.token;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final boolean enabled() {
        return this.enabled;
    }

    public final AuthenticationRealm authenticationRealm() {
        return this.authenticationRealm;
    }

    public final AuthenticationRealm lookupRealm() {
        return this.lookupRealm;
    }

    public final String authenticationType() {
        return this.authenticationType;
    }

    public final Map<String, String> apiKey() {
        return this.apiKey;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("username");
        generator.write(this.username);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.fullName != null) {
            generator.writeKey("full_name");
            generator.write(this.fullName);
        }
        if (this.email != null) {
            generator.writeKey("email");
            generator.write(this.email);
        }
        if (ApiTypeHelper.isDefined(this.token)) {
            generator.writeKey("token");
            generator.writeStartObject();
            for (Map.Entry entry : this.token.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("enabled");
        generator.write(this.enabled);
        generator.writeKey("authentication_realm");
        this.authenticationRealm.serialize(generator, mapper);
        generator.writeKey("lookup_realm");
        this.lookupRealm.serialize(generator, mapper);
        generator.writeKey("authentication_type");
        generator.write(this.authenticationType);
        if (ApiTypeHelper.isDefined(this.apiKey)) {
            generator.writeKey("api_key");
            generator.writeStartObject();
            for (Map.Entry entry : this.apiKey.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAuthenticationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::fullName, JsonpDeserializer.stringDeserializer(), "full_name");
        op.add(Builder::email, JsonpDeserializer.stringDeserializer(), "email");
        op.add(Builder::token, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "token");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::authenticationRealm, AuthenticationRealm._DESERIALIZER, "authentication_realm");
        op.add(Builder::lookupRealm, AuthenticationRealm._DESERIALIZER, "lookup_realm");
        op.add(Builder::authenticationType, JsonpDeserializer.stringDeserializer(), "authentication_type");
        op.add(Builder::apiKey, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "api_key");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Authentication> {
        private String username;
        private List<String> roles;
        @Nullable
        private String fullName;
        @Nullable
        private String email;
        @Nullable
        private Map<String, String> token;
        private Map<String, JsonData> metadata;
        private Boolean enabled;
        private AuthenticationRealm authenticationRealm;
        private AuthenticationRealm lookupRealm;
        private String authenticationType;
        @Nullable
        private Map<String, String> apiKey;

        public Builder() {
        }

        private Builder(Authentication instance) {
            this.username = instance.username;
            this.roles = instance.roles;
            this.fullName = instance.fullName;
            this.email = instance.email;
            this.token = instance.token;
            this.metadata = instance.metadata;
            this.enabled = instance.enabled;
            this.authenticationRealm = instance.authenticationRealm;
            this.lookupRealm = instance.lookupRealm;
            this.authenticationType = instance.authenticationType;
            this.apiKey = instance.apiKey;
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder fullName(@Nullable String value) {
            this.fullName = value;
            return this;
        }

        public final Builder email(@Nullable String value) {
            this.email = value;
            return this;
        }

        public final Builder token(Map<String, String> map) {
            this.token = Builder._mapPutAll(this.token, map);
            return this;
        }

        public final Builder token(String key, String value) {
            this.token = Builder._mapPut(this.token, key, value);
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder authenticationRealm(AuthenticationRealm value) {
            this.authenticationRealm = value;
            return this;
        }

        public final Builder authenticationRealm(Function<AuthenticationRealm.Builder, ObjectBuilder<AuthenticationRealm>> fn) {
            return this.authenticationRealm(fn.apply(new AuthenticationRealm.Builder()).build());
        }

        public final Builder lookupRealm(AuthenticationRealm value) {
            this.lookupRealm = value;
            return this;
        }

        public final Builder lookupRealm(Function<AuthenticationRealm.Builder, ObjectBuilder<AuthenticationRealm>> fn) {
            return this.lookupRealm(fn.apply(new AuthenticationRealm.Builder()).build());
        }

        public final Builder authenticationType(String value) {
            this.authenticationType = value;
            return this;
        }

        public final Builder apiKey(Map<String, String> map) {
            this.apiKey = Builder._mapPutAll(this.apiKey, map);
            return this;
        }

        public final Builder apiKey(String key, String value) {
            this.apiKey = Builder._mapPut(this.apiKey, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Authentication build() {
            this._checkSingleUse();
            return new Authentication(this);
        }
    }
}

