/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.RemoteClusterPrivilege;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RemoteClusterPrivileges
implements JsonpSerializable {
    private final List<String> clusters;
    private final List<RemoteClusterPrivilege> privileges;
    public static final JsonpDeserializer<RemoteClusterPrivileges> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoteClusterPrivileges::setupRemoteClusterPrivilegesDeserializer);

    private RemoteClusterPrivileges(Builder builder) {
        this.clusters = ApiTypeHelper.unmodifiableRequired(builder.clusters, (Object)this, "clusters");
        this.privileges = ApiTypeHelper.unmodifiableRequired(builder.privileges, (Object)this, "privileges");
    }

    public static RemoteClusterPrivileges of(Function<Builder, ObjectBuilder<RemoteClusterPrivileges>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> clusters() {
        return this.clusters;
    }

    public final List<RemoteClusterPrivilege> privileges() {
        return this.privileges;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.clusters)) {
            generator.writeKey("clusters");
            generator.writeStartArray();
            for (String string : this.clusters) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.privileges)) {
            generator.writeKey("privileges");
            generator.writeStartArray();
            for (RemoteClusterPrivilege remoteClusterPrivilege : this.privileges) {
                remoteClusterPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRemoteClusterPrivilegesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "clusters");
        op.add(Builder::privileges, JsonpDeserializer.arrayDeserializer(RemoteClusterPrivilege._DESERIALIZER), "privileges");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RemoteClusterPrivileges> {
        private List<String> clusters;
        private List<RemoteClusterPrivilege> privileges;

        public Builder() {
        }

        private Builder(RemoteClusterPrivileges instance) {
            this.clusters = instance.clusters;
            this.privileges = instance.privileges;
        }

        public final Builder clusters(List<String> list) {
            this.clusters = Builder._listAddAll(this.clusters, list);
            return this;
        }

        public final Builder clusters(String value, String ... values) {
            this.clusters = Builder._listAdd(this.clusters, value, values);
            return this;
        }

        public final Builder privileges(List<RemoteClusterPrivilege> list) {
            this.privileges = Builder._listAddAll(this.privileges, list);
            return this;
        }

        public final Builder privileges(RemoteClusterPrivilege value, RemoteClusterPrivilege ... values) {
            this.privileges = Builder._listAdd(this.privileges, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RemoteClusterPrivileges build() {
            this._checkSingleUse();
            return new RemoteClusterPrivileges(this);
        }
    }
}

