/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetServiceCredentialsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

public class GetServiceCredentialsRequest
extends RequestBase {
    private final String namespace;
    private final String service;
    public static final Endpoint<GetServiceCredentialsRequest, GetServiceCredentialsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetServiceCredentialsRequest, GetServiceCredentialsResponse>("es/security.get_service_credentials", request -> "GET", request -> {
        boolean _service = true;
        int _namespace = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            buf.append("/credential");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _service = true;
        int _namespace = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("namespace", request.namespace);
            params.put("service", request.service);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetServiceCredentialsResponse._DESERIALIZER);

    private GetServiceCredentialsRequest(Builder builder) {
        this.namespace = ApiTypeHelper.requireNonNull(builder.namespace, this, "namespace");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
    }

    public static GetServiceCredentialsRequest of(Function<Builder, ObjectBuilder<GetServiceCredentialsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String service() {
        return this.service;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetServiceCredentialsRequest> {
        private String namespace;
        private String service;

        public Builder() {
        }

        private Builder(GetServiceCredentialsRequest instance) {
            this.namespace = instance.namespace;
            this.service = instance.service;
        }

        public final Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public final Builder service(String value) {
            this.service = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetServiceCredentialsRequest build() {
            this._checkSingleUse();
            return new GetServiceCredentialsRequest(this);
        }
    }
}

