/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetRoleResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetRoleRequest
extends RequestBase {
    private final List<String> name;
    public static final Endpoint<GetRoleRequest, GetRoleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetRoleRequest, GetRoleResponse>("es/security.get_role", request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.name())) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/role");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/role");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.name())) {
            propsSet |= true;
        }
        if (propsSet) {
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (!propsSet) {
            // empty if block
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetRoleResponse._DESERIALIZER);

    private GetRoleRequest(Builder builder) {
        this.name = ApiTypeHelper.unmodifiable(builder.name);
    }

    public static GetRoleRequest of(Function<Builder, ObjectBuilder<GetRoleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> name() {
        return this.name;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetRoleRequest> {
        @Nullable
        private List<String> name;

        public Builder() {
        }

        private Builder(GetRoleRequest instance) {
            this.name = instance.name;
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetRoleRequest build() {
            this._checkSingleUse();
            return new GetRoleRequest(this);
        }
    }
}

