/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.ReplicationAccess;
import co.elastic.clients.elasticsearch.security.SearchAccess;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Access
implements JsonpSerializable {
    private final List<ReplicationAccess> replication;
    private final List<SearchAccess> search;
    public static final JsonpDeserializer<Access> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Access::setupAccessDeserializer);

    private Access(Builder builder) {
        this.replication = ApiTypeHelper.unmodifiable(builder.replication);
        this.search = ApiTypeHelper.unmodifiable(builder.search);
    }

    public static Access of(Function<Builder, ObjectBuilder<Access>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ReplicationAccess> replication() {
        return this.replication;
    }

    public final List<SearchAccess> search() {
        return this.search;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.replication)) {
            generator.writeKey("replication");
            generator.writeStartArray();
            for (ReplicationAccess replicationAccess : this.replication) {
                replicationAccess.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.search)) {
            generator.writeKey("search");
            generator.writeStartArray();
            for (SearchAccess searchAccess : this.search) {
                searchAccess.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAccessDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::replication, JsonpDeserializer.arrayDeserializer(ReplicationAccess._DESERIALIZER), "replication");
        op.add(Builder::search, JsonpDeserializer.arrayDeserializer(SearchAccess._DESERIALIZER), "search");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Access> {
        @Nullable
        private List<ReplicationAccess> replication;
        @Nullable
        private List<SearchAccess> search;

        public Builder() {
        }

        private Builder(Access instance) {
            this.replication = instance.replication;
            this.search = instance.search;
        }

        public final Builder replication(List<ReplicationAccess> list) {
            this.replication = Builder._listAddAll(this.replication, list);
            return this;
        }

        public final Builder replication(ReplicationAccess value, ReplicationAccess ... values) {
            this.replication = Builder._listAdd(this.replication, value, values);
            return this;
        }

        public final Builder replication(Function<ReplicationAccess.Builder, ObjectBuilder<ReplicationAccess>> fn) {
            return this.replication(fn.apply(new ReplicationAccess.Builder()).build(), new ReplicationAccess[0]);
        }

        public final Builder search(List<SearchAccess> list) {
            this.search = Builder._listAddAll(this.search, list);
            return this;
        }

        public final Builder search(SearchAccess value, SearchAccess ... values) {
            this.search = Builder._listAdd(this.search, value, values);
            return this;
        }

        public final Builder search(Function<SearchAccess.Builder, ObjectBuilder<SearchAccess>> fn) {
            return this.search(fn.apply(new SearchAccess.Builder()).build(), new SearchAccess[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Access build() {
            this._checkSingleUse();
            return new Access(this);
        }
    }
}

