/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_jobs;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RollupJobStats
implements JsonpSerializable {
    private final long documentsProcessed;
    private final long indexFailures;
    private final long indexTimeInMs;
    private final long indexTotal;
    private final long pagesProcessed;
    private final long rollupsIndexed;
    private final long searchFailures;
    private final long searchTimeInMs;
    private final long searchTotal;
    private final long triggerCount;
    private final long processingTimeInMs;
    private final long processingTotal;
    public static final JsonpDeserializer<RollupJobStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupJobStats::setupRollupJobStatsDeserializer);

    private RollupJobStats(Builder builder) {
        this.documentsProcessed = ApiTypeHelper.requireNonNull(builder.documentsProcessed, (Object)this, "documentsProcessed", 0L);
        this.indexFailures = ApiTypeHelper.requireNonNull(builder.indexFailures, (Object)this, "indexFailures", 0L);
        this.indexTimeInMs = ApiTypeHelper.requireNonNull(builder.indexTimeInMs, (Object)this, "indexTimeInMs", 0L);
        this.indexTotal = ApiTypeHelper.requireNonNull(builder.indexTotal, (Object)this, "indexTotal", 0L);
        this.pagesProcessed = ApiTypeHelper.requireNonNull(builder.pagesProcessed, (Object)this, "pagesProcessed", 0L);
        this.rollupsIndexed = ApiTypeHelper.requireNonNull(builder.rollupsIndexed, (Object)this, "rollupsIndexed", 0L);
        this.searchFailures = ApiTypeHelper.requireNonNull(builder.searchFailures, (Object)this, "searchFailures", 0L);
        this.searchTimeInMs = ApiTypeHelper.requireNonNull(builder.searchTimeInMs, (Object)this, "searchTimeInMs", 0L);
        this.searchTotal = ApiTypeHelper.requireNonNull(builder.searchTotal, (Object)this, "searchTotal", 0L);
        this.triggerCount = ApiTypeHelper.requireNonNull(builder.triggerCount, (Object)this, "triggerCount", 0L);
        this.processingTimeInMs = ApiTypeHelper.requireNonNull(builder.processingTimeInMs, (Object)this, "processingTimeInMs", 0L);
        this.processingTotal = ApiTypeHelper.requireNonNull(builder.processingTotal, (Object)this, "processingTotal", 0L);
    }

    public static RollupJobStats of(Function<Builder, ObjectBuilder<RollupJobStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long documentsProcessed() {
        return this.documentsProcessed;
    }

    public final long indexFailures() {
        return this.indexFailures;
    }

    public final long indexTimeInMs() {
        return this.indexTimeInMs;
    }

    public final long indexTotal() {
        return this.indexTotal;
    }

    public final long pagesProcessed() {
        return this.pagesProcessed;
    }

    public final long rollupsIndexed() {
        return this.rollupsIndexed;
    }

    public final long searchFailures() {
        return this.searchFailures;
    }

    public final long searchTimeInMs() {
        return this.searchTimeInMs;
    }

    public final long searchTotal() {
        return this.searchTotal;
    }

    public final long triggerCount() {
        return this.triggerCount;
    }

    public final long processingTimeInMs() {
        return this.processingTimeInMs;
    }

    public final long processingTotal() {
        return this.processingTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("documents_processed");
        generator.write(this.documentsProcessed);
        generator.writeKey("index_failures");
        generator.write(this.indexFailures);
        generator.writeKey("index_time_in_ms");
        generator.write(this.indexTimeInMs);
        generator.writeKey("index_total");
        generator.write(this.indexTotal);
        generator.writeKey("pages_processed");
        generator.write(this.pagesProcessed);
        generator.writeKey("rollups_indexed");
        generator.write(this.rollupsIndexed);
        generator.writeKey("search_failures");
        generator.write(this.searchFailures);
        generator.writeKey("search_time_in_ms");
        generator.write(this.searchTimeInMs);
        generator.writeKey("search_total");
        generator.write(this.searchTotal);
        generator.writeKey("trigger_count");
        generator.write(this.triggerCount);
        generator.writeKey("processing_time_in_ms");
        generator.write(this.processingTimeInMs);
        generator.writeKey("processing_total");
        generator.write(this.processingTotal);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRollupJobStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::documentsProcessed, JsonpDeserializer.longDeserializer(), "documents_processed");
        op.add(Builder::indexFailures, JsonpDeserializer.longDeserializer(), "index_failures");
        op.add(Builder::indexTimeInMs, JsonpDeserializer.longDeserializer(), "index_time_in_ms");
        op.add(Builder::indexTotal, JsonpDeserializer.longDeserializer(), "index_total");
        op.add(Builder::pagesProcessed, JsonpDeserializer.longDeserializer(), "pages_processed");
        op.add(Builder::rollupsIndexed, JsonpDeserializer.longDeserializer(), "rollups_indexed");
        op.add(Builder::searchFailures, JsonpDeserializer.longDeserializer(), "search_failures");
        op.add(Builder::searchTimeInMs, JsonpDeserializer.longDeserializer(), "search_time_in_ms");
        op.add(Builder::searchTotal, JsonpDeserializer.longDeserializer(), "search_total");
        op.add(Builder::triggerCount, JsonpDeserializer.longDeserializer(), "trigger_count");
        op.add(Builder::processingTimeInMs, JsonpDeserializer.longDeserializer(), "processing_time_in_ms");
        op.add(Builder::processingTotal, JsonpDeserializer.longDeserializer(), "processing_total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RollupJobStats> {
        private Long documentsProcessed;
        private Long indexFailures;
        private Long indexTimeInMs;
        private Long indexTotal;
        private Long pagesProcessed;
        private Long rollupsIndexed;
        private Long searchFailures;
        private Long searchTimeInMs;
        private Long searchTotal;
        private Long triggerCount;
        private Long processingTimeInMs;
        private Long processingTotal;

        public Builder() {
        }

        private Builder(RollupJobStats instance) {
            this.documentsProcessed = instance.documentsProcessed;
            this.indexFailures = instance.indexFailures;
            this.indexTimeInMs = instance.indexTimeInMs;
            this.indexTotal = instance.indexTotal;
            this.pagesProcessed = instance.pagesProcessed;
            this.rollupsIndexed = instance.rollupsIndexed;
            this.searchFailures = instance.searchFailures;
            this.searchTimeInMs = instance.searchTimeInMs;
            this.searchTotal = instance.searchTotal;
            this.triggerCount = instance.triggerCount;
            this.processingTimeInMs = instance.processingTimeInMs;
            this.processingTotal = instance.processingTotal;
        }

        public final Builder documentsProcessed(long value) {
            this.documentsProcessed = value;
            return this;
        }

        public final Builder indexFailures(long value) {
            this.indexFailures = value;
            return this;
        }

        public final Builder indexTimeInMs(long value) {
            this.indexTimeInMs = value;
            return this;
        }

        public final Builder indexTotal(long value) {
            this.indexTotal = value;
            return this;
        }

        public final Builder pagesProcessed(long value) {
            this.pagesProcessed = value;
            return this;
        }

        public final Builder rollupsIndexed(long value) {
            this.rollupsIndexed = value;
            return this;
        }

        public final Builder searchFailures(long value) {
            this.searchFailures = value;
            return this;
        }

        public final Builder searchTimeInMs(long value) {
            this.searchTimeInMs = value;
            return this;
        }

        public final Builder searchTotal(long value) {
            this.searchTotal = value;
            return this;
        }

        public final Builder triggerCount(long value) {
            this.triggerCount = value;
            return this;
        }

        public final Builder processingTimeInMs(long value) {
            this.processingTimeInMs = value;
            return this;
        }

        public final Builder processingTotal(long value) {
            this.processingTotal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RollupJobStats build() {
            this._checkSingleUse();
            return new RollupJobStats(this);
        }
    }
}

