/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_rules;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.query_rules.PutRuleResponse;
import co.elastic.clients.elasticsearch.query_rules.QueryRuleActions;
import co.elastic.clients.elasticsearch.query_rules.QueryRuleCriteria;
import co.elastic.clients.elasticsearch.query_rules.QueryRuleType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutRuleRequest
extends RequestBase
implements JsonpSerializable {
    private final QueryRuleActions actions;
    private final List<QueryRuleCriteria> criteria;
    @Nullable
    private final Integer priority;
    private final String ruleId;
    private final String rulesetId;
    private final QueryRuleType type;
    public static final JsonpDeserializer<PutRuleRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutRuleRequest::setupPutRuleRequestDeserializer);
    public static final Endpoint<PutRuleRequest, PutRuleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutRuleRequest, PutRuleResponse>("es/query_rules.put_rule", request -> "PUT", request -> {
        boolean _ruleId = true;
        int _rulesetId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_query_rules");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.rulesetId, buf);
            buf.append("/_rule");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.ruleId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _ruleId = true;
        int _rulesetId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("rulesetId", request.rulesetId);
            params.put("ruleId", request.ruleId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutRuleResponse._DESERIALIZER);

    private PutRuleRequest(Builder builder) {
        this.actions = ApiTypeHelper.requireNonNull(builder.actions, this, "actions");
        this.criteria = ApiTypeHelper.unmodifiableRequired(builder.criteria, (Object)this, "criteria");
        this.priority = builder.priority;
        this.ruleId = ApiTypeHelper.requireNonNull(builder.ruleId, this, "ruleId");
        this.rulesetId = ApiTypeHelper.requireNonNull(builder.rulesetId, this, "rulesetId");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static PutRuleRequest of(Function<Builder, ObjectBuilder<PutRuleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final QueryRuleActions actions() {
        return this.actions;
    }

    public final List<QueryRuleCriteria> criteria() {
        return this.criteria;
    }

    @Nullable
    public final Integer priority() {
        return this.priority;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final String rulesetId() {
        return this.rulesetId;
    }

    public final QueryRuleType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actions");
        this.actions.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.criteria)) {
            generator.writeKey("criteria");
            generator.writeStartArray();
            for (QueryRuleCriteria item0 : this.criteria) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.intValue());
        }
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutRuleRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, QueryRuleActions._DESERIALIZER, "actions");
        op.add(Builder::criteria, JsonpDeserializer.arrayDeserializer(QueryRuleCriteria._DESERIALIZER), "criteria");
        op.add(Builder::priority, JsonpDeserializer.integerDeserializer(), "priority");
        op.add(Builder::type, QueryRuleType._DESERIALIZER, "type");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutRuleRequest> {
        private QueryRuleActions actions;
        private List<QueryRuleCriteria> criteria;
        @Nullable
        private Integer priority;
        private String ruleId;
        private String rulesetId;
        private QueryRuleType type;

        public Builder() {
        }

        private Builder(PutRuleRequest instance) {
            this.actions = instance.actions;
            this.criteria = instance.criteria;
            this.priority = instance.priority;
            this.ruleId = instance.ruleId;
            this.rulesetId = instance.rulesetId;
            this.type = instance.type;
        }

        public final Builder actions(QueryRuleActions value) {
            this.actions = value;
            return this;
        }

        public final Builder actions(Function<QueryRuleActions.Builder, ObjectBuilder<QueryRuleActions>> fn) {
            return this.actions(fn.apply(new QueryRuleActions.Builder()).build());
        }

        public final Builder criteria(List<QueryRuleCriteria> list) {
            this.criteria = Builder._listAddAll(this.criteria, list);
            return this;
        }

        public final Builder criteria(QueryRuleCriteria value, QueryRuleCriteria ... values) {
            this.criteria = Builder._listAdd(this.criteria, value, values);
            return this;
        }

        public final Builder criteria(Function<QueryRuleCriteria.Builder, ObjectBuilder<QueryRuleCriteria>> fn) {
            return this.criteria(fn.apply(new QueryRuleCriteria.Builder()).build(), new QueryRuleCriteria[0]);
        }

        public final Builder priority(@Nullable Integer value) {
            this.priority = value;
            return this;
        }

        public final Builder ruleId(String value) {
            this.ruleId = value;
            return this;
        }

        public final Builder rulesetId(String value) {
            this.rulesetId = value;
            return this;
        }

        public final Builder type(QueryRuleType value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutRuleRequest build() {
            this._checkSingleUse();
            return new PutRuleRequest(this);
        }
    }
}

