/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.project.tags;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Tags
implements JsonpSerializable {
    private final Map<String, String> userDefinedTags;
    private final String id;
    private final String alias;
    private final String type;
    private final String organisation;
    public static final JsonpDeserializer<Tags> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Tags::setupTagsDeserializer);

    private Tags(Builder builder) {
        this.userDefinedTags = ApiTypeHelper.unmodifiable(builder.userDefinedTags);
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.alias = ApiTypeHelper.requireNonNull(builder.alias, this, "alias");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.organisation = ApiTypeHelper.requireNonNull(builder.organisation, this, "organisation");
    }

    public static Tags of(Function<Builder, ObjectBuilder<Tags>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, String> userDefinedTags() {
        return this.userDefinedTags;
    }

    public final String id() {
        return this.id;
    }

    public final String alias() {
        return this.alias;
    }

    public final String type() {
        return this.type;
    }

    public final String organisation() {
        return this.organisation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, String> item0 : this.userDefinedTags.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue());
        }
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_alias");
        generator.write(this.alias);
        generator.writeKey("_type");
        generator.write(this.type);
        generator.writeKey("_organisation");
        generator.write(this.organisation);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTagsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::alias, JsonpDeserializer.stringDeserializer(), "_alias");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type");
        op.add(Builder::organisation, JsonpDeserializer.stringDeserializer(), "_organisation");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> builder.userDefinedTags((String)name, JsonpDeserializer.stringDeserializer().deserialize((JsonParser)parser, (JsonpMapper)mapper)));
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Tags> {
        @Nullable
        private Map<String, String> userDefinedTags = new HashMap<String, String>();
        private String id;
        private String alias;
        private String type;
        private String organisation;

        public final Builder userDefinedTags(Map<String, String> map) {
            this.userDefinedTags = Builder._mapPutAll(this.userDefinedTags, map);
            return this;
        }

        public final Builder userDefinedTags(String key, String value) {
            this.userDefinedTags = Builder._mapPut(this.userDefinedTags, key, value);
            return this;
        }

        public Builder() {
        }

        private Builder(Tags instance) {
            this.id = instance.id;
            this.alias = instance.alias;
            this.type = instance.type;
            this.organisation = instance.organisation;
            this.userDefinedTags = instance.userDefinedTags;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder alias(String value) {
            this.alias = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder organisation(String value) {
            this.organisation = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Tags build() {
            this._checkSingleUse();
            return new Tags(this);
        }
    }
}

