/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ScriptCache
implements JsonpSerializable {
    @Nullable
    private final Long cacheEvictions;
    @Nullable
    private final Long compilationLimitTriggered;
    @Nullable
    private final Long compilations;
    @Nullable
    private final String context;
    public static final JsonpDeserializer<ScriptCache> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptCache::setupScriptCacheDeserializer);

    private ScriptCache(Builder builder) {
        this.cacheEvictions = builder.cacheEvictions;
        this.compilationLimitTriggered = builder.compilationLimitTriggered;
        this.compilations = builder.compilations;
        this.context = builder.context;
    }

    public static ScriptCache of(Function<Builder, ObjectBuilder<ScriptCache>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long cacheEvictions() {
        return this.cacheEvictions;
    }

    @Nullable
    public final Long compilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    @Nullable
    public final Long compilations() {
        return this.compilations;
    }

    @Nullable
    public final String context() {
        return this.context;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cacheEvictions != null) {
            generator.writeKey("cache_evictions");
            generator.write(this.cacheEvictions.longValue());
        }
        if (this.compilationLimitTriggered != null) {
            generator.writeKey("compilation_limit_triggered");
            generator.write(this.compilationLimitTriggered.longValue());
        }
        if (this.compilations != null) {
            generator.writeKey("compilations");
            generator.write(this.compilations.longValue());
        }
        if (this.context != null) {
            generator.writeKey("context");
            generator.write(this.context);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupScriptCacheDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cacheEvictions, JsonpDeserializer.longDeserializer(), "cache_evictions");
        op.add(Builder::compilationLimitTriggered, JsonpDeserializer.longDeserializer(), "compilation_limit_triggered");
        op.add(Builder::compilations, JsonpDeserializer.longDeserializer(), "compilations");
        op.add(Builder::context, JsonpDeserializer.stringDeserializer(), "context");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ScriptCache> {
        @Nullable
        private Long cacheEvictions;
        @Nullable
        private Long compilationLimitTriggered;
        @Nullable
        private Long compilations;
        @Nullable
        private String context;

        public Builder() {
        }

        private Builder(ScriptCache instance) {
            this.cacheEvictions = instance.cacheEvictions;
            this.compilationLimitTriggered = instance.compilationLimitTriggered;
            this.compilations = instance.compilations;
            this.context = instance.context;
        }

        public final Builder cacheEvictions(@Nullable Long value) {
            this.cacheEvictions = value;
            return this;
        }

        public final Builder compilationLimitTriggered(@Nullable Long value) {
            this.compilationLimitTriggered = value;
            return this;
        }

        public final Builder compilations(@Nullable Long value) {
            this.compilations = value;
            return this;
        }

        public final Builder context(@Nullable String value) {
            this.context = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptCache build() {
            this._checkSingleUse();
            return new ScriptCache(this);
        }
    }
}

