/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.CommonStatsFlag;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.NodeStatsLevel;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.nodes.NodesStatsResponse;
import co.elastic.clients.elasticsearch.nodes.stats.NodeStatsMetric;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class NodesStatsRequest
extends RequestBase {
    private final List<String> completionFields;
    private final List<String> fielddataFields;
    private final List<String> fields;
    @Nullable
    private final Boolean groups;
    @Nullable
    private final Boolean includeSegmentFileSizes;
    @Nullable
    private final Boolean includeUnloadedSegments;
    private final List<CommonStatsFlag> indexMetric;
    @Nullable
    private final NodeStatsLevel level;
    private final List<NodeStatsMetric> metric;
    private final List<String> nodeId;
    @Nullable
    private final Time timeout;
    private final List<String> types;
    public static final Endpoint<NodesStatsRequest, NodesStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<NodesStatsRequest, NodesStatsResponse>("es/nodes.stats", request -> "GET", request -> {
        boolean _metric = true;
        int _indexMetric = 2;
        int _nodeId = 4;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.indexMetric())) {
            propsSet |= 2;
        }
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= 4;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet == 4) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 5) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexMetric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexMetric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _metric = true;
        int _indexMetric = 2;
        int _nodeId = 4;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.indexMetric())) {
            propsSet |= 2;
        }
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= 4;
        }
        if (propsSet == 0) {
            // empty if block
        }
        if (propsSet == 4) {
            params.put("nodeId", request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (propsSet == 1) {
            params.put("metric", request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (propsSet == 5) {
            params.put("nodeId", request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")));
            params.put("metric", request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (propsSet == 3) {
            params.put("metric", request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
            params.put("indexMetric", request.indexMetric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (propsSet == 7) {
            params.put("nodeId", request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")));
            params.put("metric", request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
            params.put("indexMetric", request.indexMetric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.types)) {
            params.put("types", request.types.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.level != null) {
            params.put("level", request.level.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.completionFields)) {
            params.put("completion_fields", request.completionFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.fielddataFields)) {
            params.put("fielddata_fields", request.fielddataFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.groups != null) {
            params.put("groups", String.valueOf(request.groups));
        }
        if (request.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(request.includeUnloadedSegments));
        }
        if (ApiTypeHelper.isDefined(request.fields)) {
            params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.includeSegmentFileSizes != null) {
            params.put("include_segment_file_sizes", String.valueOf(request.includeSegmentFileSizes));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, NodesStatsResponse._DESERIALIZER);

    private NodesStatsRequest(Builder builder) {
        this.completionFields = ApiTypeHelper.unmodifiable(builder.completionFields);
        this.fielddataFields = ApiTypeHelper.unmodifiable(builder.fielddataFields);
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.groups = builder.groups;
        this.includeSegmentFileSizes = builder.includeSegmentFileSizes;
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
        this.indexMetric = ApiTypeHelper.unmodifiable(builder.indexMetric);
        this.level = builder.level;
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.timeout = builder.timeout;
        this.types = ApiTypeHelper.unmodifiable(builder.types);
    }

    public static NodesStatsRequest of(Function<Builder, ObjectBuilder<NodesStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> completionFields() {
        return this.completionFields;
    }

    public final List<String> fielddataFields() {
        return this.fielddataFields;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final Boolean groups() {
        return this.groups;
    }

    @Nullable
    public final Boolean includeSegmentFileSizes() {
        return this.includeSegmentFileSizes;
    }

    @Nullable
    public final Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    public final List<CommonStatsFlag> indexMetric() {
        return this.indexMetric;
    }

    @Nullable
    public final NodeStatsLevel level() {
        return this.level;
    }

    public final List<NodeStatsMetric> metric() {
        return this.metric;
    }

    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final List<String> types() {
        return this.types;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NodesStatsRequest> {
        @Nullable
        private List<String> completionFields;
        @Nullable
        private List<String> fielddataFields;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean groups;
        @Nullable
        private Boolean includeSegmentFileSizes;
        @Nullable
        private Boolean includeUnloadedSegments;
        @Nullable
        private List<CommonStatsFlag> indexMetric;
        @Nullable
        private NodeStatsLevel level;
        @Nullable
        private List<NodeStatsMetric> metric;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Time timeout;
        @Nullable
        private List<String> types;

        public Builder() {
        }

        private Builder(NodesStatsRequest instance) {
            this.completionFields = instance.completionFields;
            this.fielddataFields = instance.fielddataFields;
            this.fields = instance.fields;
            this.groups = instance.groups;
            this.includeSegmentFileSizes = instance.includeSegmentFileSizes;
            this.includeUnloadedSegments = instance.includeUnloadedSegments;
            this.indexMetric = instance.indexMetric;
            this.level = instance.level;
            this.metric = instance.metric;
            this.nodeId = instance.nodeId;
            this.timeout = instance.timeout;
            this.types = instance.types;
        }

        public final Builder completionFields(List<String> list) {
            this.completionFields = Builder._listAddAll(this.completionFields, list);
            return this;
        }

        public final Builder completionFields(String value, String ... values) {
            this.completionFields = Builder._listAdd(this.completionFields, value, values);
            return this;
        }

        public final Builder fielddataFields(List<String> list) {
            this.fielddataFields = Builder._listAddAll(this.fielddataFields, list);
            return this;
        }

        public final Builder fielddataFields(String value, String ... values) {
            this.fielddataFields = Builder._listAdd(this.fielddataFields, value, values);
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder groups(@Nullable Boolean value) {
            this.groups = value;
            return this;
        }

        public final Builder includeSegmentFileSizes(@Nullable Boolean value) {
            this.includeSegmentFileSizes = value;
            return this;
        }

        public final Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        public final Builder indexMetric(List<CommonStatsFlag> list) {
            this.indexMetric = Builder._listAddAll(this.indexMetric, list);
            return this;
        }

        public final Builder indexMetric(CommonStatsFlag value, CommonStatsFlag ... values) {
            this.indexMetric = Builder._listAdd(this.indexMetric, value, values);
            return this;
        }

        public final Builder level(@Nullable NodeStatsLevel value) {
            this.level = value;
            return this;
        }

        public final Builder metric(List<NodeStatsMetric> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        public final Builder metric(NodeStatsMetric value, NodeStatsMetric ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder types(List<String> list) {
            this.types = Builder._listAddAll(this.types, list);
            return this;
        }

        public final Builder types(String value, String ... values) {
            this.types = Builder._listAdd(this.types, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodesStatsRequest build() {
            this._checkSingleUse();
            return new NodesStatsRequest(this);
        }
    }
}

