/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Pool;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JvmMemoryStats
implements JsonpSerializable {
    @Nullable
    private final Long heapUsedInBytes;
    @Nullable
    private final Long heapUsedPercent;
    @Nullable
    private final Long heapCommittedInBytes;
    @Nullable
    private final Long heapMaxInBytes;
    @Nullable
    private final String heapMax;
    @Nullable
    private final Long nonHeapUsedInBytes;
    @Nullable
    private final Long nonHeapCommittedInBytes;
    private final Map<String, Pool> pools;
    public static final JsonpDeserializer<JvmMemoryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JvmMemoryStats::setupJvmMemoryStatsDeserializer);

    private JvmMemoryStats(Builder builder) {
        this.heapUsedInBytes = builder.heapUsedInBytes;
        this.heapUsedPercent = builder.heapUsedPercent;
        this.heapCommittedInBytes = builder.heapCommittedInBytes;
        this.heapMaxInBytes = builder.heapMaxInBytes;
        this.heapMax = builder.heapMax;
        this.nonHeapUsedInBytes = builder.nonHeapUsedInBytes;
        this.nonHeapCommittedInBytes = builder.nonHeapCommittedInBytes;
        this.pools = ApiTypeHelper.unmodifiable(builder.pools);
    }

    public static JvmMemoryStats of(Function<Builder, ObjectBuilder<JvmMemoryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long heapUsedInBytes() {
        return this.heapUsedInBytes;
    }

    @Nullable
    public final Long heapUsedPercent() {
        return this.heapUsedPercent;
    }

    @Nullable
    public final Long heapCommittedInBytes() {
        return this.heapCommittedInBytes;
    }

    @Nullable
    public final Long heapMaxInBytes() {
        return this.heapMaxInBytes;
    }

    @Nullable
    public final String heapMax() {
        return this.heapMax;
    }

    @Nullable
    public final Long nonHeapUsedInBytes() {
        return this.nonHeapUsedInBytes;
    }

    @Nullable
    public final Long nonHeapCommittedInBytes() {
        return this.nonHeapCommittedInBytes;
    }

    public final Map<String, Pool> pools() {
        return this.pools;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.heapUsedInBytes != null) {
            generator.writeKey("heap_used_in_bytes");
            generator.write(this.heapUsedInBytes.longValue());
        }
        if (this.heapUsedPercent != null) {
            generator.writeKey("heap_used_percent");
            generator.write(this.heapUsedPercent.longValue());
        }
        if (this.heapCommittedInBytes != null) {
            generator.writeKey("heap_committed_in_bytes");
            generator.write(this.heapCommittedInBytes.longValue());
        }
        if (this.heapMaxInBytes != null) {
            generator.writeKey("heap_max_in_bytes");
            generator.write(this.heapMaxInBytes.longValue());
        }
        if (this.heapMax != null) {
            generator.writeKey("heap_max");
            generator.write(this.heapMax);
        }
        if (this.nonHeapUsedInBytes != null) {
            generator.writeKey("non_heap_used_in_bytes");
            generator.write(this.nonHeapUsedInBytes.longValue());
        }
        if (this.nonHeapCommittedInBytes != null) {
            generator.writeKey("non_heap_committed_in_bytes");
            generator.write(this.nonHeapCommittedInBytes.longValue());
        }
        if (ApiTypeHelper.isDefined(this.pools)) {
            generator.writeKey("pools");
            generator.writeStartObject();
            for (Map.Entry<String, Pool> item0 : this.pools.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupJvmMemoryStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::heapUsedInBytes, JsonpDeserializer.longDeserializer(), "heap_used_in_bytes");
        op.add(Builder::heapUsedPercent, JsonpDeserializer.longDeserializer(), "heap_used_percent");
        op.add(Builder::heapCommittedInBytes, JsonpDeserializer.longDeserializer(), "heap_committed_in_bytes");
        op.add(Builder::heapMaxInBytes, JsonpDeserializer.longDeserializer(), "heap_max_in_bytes");
        op.add(Builder::heapMax, JsonpDeserializer.stringDeserializer(), "heap_max");
        op.add(Builder::nonHeapUsedInBytes, JsonpDeserializer.longDeserializer(), "non_heap_used_in_bytes");
        op.add(Builder::nonHeapCommittedInBytes, JsonpDeserializer.longDeserializer(), "non_heap_committed_in_bytes");
        op.add(Builder::pools, JsonpDeserializer.stringMapDeserializer(Pool._DESERIALIZER), "pools");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<JvmMemoryStats> {
        @Nullable
        private Long heapUsedInBytes;
        @Nullable
        private Long heapUsedPercent;
        @Nullable
        private Long heapCommittedInBytes;
        @Nullable
        private Long heapMaxInBytes;
        @Nullable
        private String heapMax;
        @Nullable
        private Long nonHeapUsedInBytes;
        @Nullable
        private Long nonHeapCommittedInBytes;
        @Nullable
        private Map<String, Pool> pools;

        public Builder() {
        }

        private Builder(JvmMemoryStats instance) {
            this.heapUsedInBytes = instance.heapUsedInBytes;
            this.heapUsedPercent = instance.heapUsedPercent;
            this.heapCommittedInBytes = instance.heapCommittedInBytes;
            this.heapMaxInBytes = instance.heapMaxInBytes;
            this.heapMax = instance.heapMax;
            this.nonHeapUsedInBytes = instance.nonHeapUsedInBytes;
            this.nonHeapCommittedInBytes = instance.nonHeapCommittedInBytes;
            this.pools = instance.pools;
        }

        public final Builder heapUsedInBytes(@Nullable Long value) {
            this.heapUsedInBytes = value;
            return this;
        }

        public final Builder heapUsedPercent(@Nullable Long value) {
            this.heapUsedPercent = value;
            return this;
        }

        public final Builder heapCommittedInBytes(@Nullable Long value) {
            this.heapCommittedInBytes = value;
            return this;
        }

        public final Builder heapMaxInBytes(@Nullable Long value) {
            this.heapMaxInBytes = value;
            return this;
        }

        public final Builder heapMax(@Nullable String value) {
            this.heapMax = value;
            return this;
        }

        public final Builder nonHeapUsedInBytes(@Nullable Long value) {
            this.nonHeapUsedInBytes = value;
            return this;
        }

        public final Builder nonHeapCommittedInBytes(@Nullable Long value) {
            this.nonHeapCommittedInBytes = value;
            return this;
        }

        public final Builder pools(Map<String, Pool> map) {
            this.pools = Builder._mapPutAll(this.pools, map);
            return this;
        }

        public final Builder pools(String key, Pool value) {
            this.pools = Builder._mapPut(this.pools, key, value);
            return this;
        }

        public final Builder pools(String key, Function<Pool.Builder, ObjectBuilder<Pool>> fn) {
            return this.pools(key, fn.apply(new Pool.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JvmMemoryStats build() {
            this._checkSingleUse();
            return new JvmMemoryStats(this);
        }
    }
}

