/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Client;
import co.elastic.clients.elasticsearch.nodes.HttpRoute;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Http
implements JsonpSerializable {
    @Nullable
    private final Integer currentOpen;
    @Nullable
    private final Long totalOpened;
    private final List<Client> clients;
    private final Map<String, HttpRoute> routes;
    public static final JsonpDeserializer<Http> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Http::setupHttpDeserializer);

    private Http(Builder builder) {
        this.currentOpen = builder.currentOpen;
        this.totalOpened = builder.totalOpened;
        this.clients = ApiTypeHelper.unmodifiable(builder.clients);
        this.routes = ApiTypeHelper.unmodifiable(builder.routes);
    }

    public static Http of(Function<Builder, ObjectBuilder<Http>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer currentOpen() {
        return this.currentOpen;
    }

    @Nullable
    public final Long totalOpened() {
        return this.totalOpened;
    }

    public final List<Client> clients() {
        return this.clients;
    }

    public final Map<String, HttpRoute> routes() {
        return this.routes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentOpen != null) {
            generator.writeKey("current_open");
            generator.write(this.currentOpen.intValue());
        }
        if (this.totalOpened != null) {
            generator.writeKey("total_opened");
            generator.write(this.totalOpened.longValue());
        }
        if (ApiTypeHelper.isDefined(this.clients)) {
            generator.writeKey("clients");
            generator.writeStartArray();
            for (Client client : this.clients) {
                client.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.routes)) {
            generator.writeKey("routes");
            generator.writeStartObject();
            for (Map.Entry entry : this.routes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((HttpRoute)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupHttpDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentOpen, JsonpDeserializer.integerDeserializer(), "current_open");
        op.add(Builder::totalOpened, JsonpDeserializer.longDeserializer(), "total_opened");
        op.add(Builder::clients, JsonpDeserializer.arrayDeserializer(Client._DESERIALIZER), "clients");
        op.add(Builder::routes, JsonpDeserializer.stringMapDeserializer(HttpRoute._DESERIALIZER), "routes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Http> {
        @Nullable
        private Integer currentOpen;
        @Nullable
        private Long totalOpened;
        @Nullable
        private List<Client> clients;
        @Nullable
        private Map<String, HttpRoute> routes;

        public Builder() {
        }

        private Builder(Http instance) {
            this.currentOpen = instance.currentOpen;
            this.totalOpened = instance.totalOpened;
            this.clients = instance.clients;
            this.routes = instance.routes;
        }

        public final Builder currentOpen(@Nullable Integer value) {
            this.currentOpen = value;
            return this;
        }

        public final Builder totalOpened(@Nullable Long value) {
            this.totalOpened = value;
            return this;
        }

        public final Builder clients(List<Client> list) {
            this.clients = Builder._listAddAll(this.clients, list);
            return this;
        }

        public final Builder clients(Client value, Client ... values) {
            this.clients = Builder._listAdd(this.clients, value, values);
            return this;
        }

        public final Builder clients(Function<Client.Builder, ObjectBuilder<Client>> fn) {
            return this.clients(fn.apply(new Client.Builder()).build(), new Client[0]);
        }

        public final Builder routes(Map<String, HttpRoute> map) {
            this.routes = Builder._mapPutAll(this.routes, map);
            return this;
        }

        public final Builder routes(String key, HttpRoute value) {
            this.routes = Builder._mapPut(this.routes, key, value);
            return this;
        }

        public final Builder routes(String key, Function<HttpRoute.Builder, ObjectBuilder<HttpRoute>> fn) {
            return this.routes(key, fn.apply(new HttpRoute.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Http build() {
            this._checkSingleUse();
            return new Http(this);
        }
    }
}

