/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GarbageCollectorTotal
implements JsonpSerializable {
    @Nullable
    private final Long collectionCount;
    @Nullable
    private final String collectionTime;
    @Nullable
    private final Long collectionTimeInMillis;
    public static final JsonpDeserializer<GarbageCollectorTotal> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GarbageCollectorTotal::setupGarbageCollectorTotalDeserializer);

    private GarbageCollectorTotal(Builder builder) {
        this.collectionCount = builder.collectionCount;
        this.collectionTime = builder.collectionTime;
        this.collectionTimeInMillis = builder.collectionTimeInMillis;
    }

    public static GarbageCollectorTotal of(Function<Builder, ObjectBuilder<GarbageCollectorTotal>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long collectionCount() {
        return this.collectionCount;
    }

    @Nullable
    public final String collectionTime() {
        return this.collectionTime;
    }

    @Nullable
    public final Long collectionTimeInMillis() {
        return this.collectionTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.collectionCount != null) {
            generator.writeKey("collection_count");
            generator.write(this.collectionCount.longValue());
        }
        if (this.collectionTime != null) {
            generator.writeKey("collection_time");
            generator.write(this.collectionTime);
        }
        if (this.collectionTimeInMillis != null) {
            generator.writeKey("collection_time_in_millis");
            generator.write(this.collectionTimeInMillis.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGarbageCollectorTotalDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collectionCount, JsonpDeserializer.longDeserializer(), "collection_count");
        op.add(Builder::collectionTime, JsonpDeserializer.stringDeserializer(), "collection_time");
        op.add(Builder::collectionTimeInMillis, JsonpDeserializer.longDeserializer(), "collection_time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GarbageCollectorTotal> {
        @Nullable
        private Long collectionCount;
        @Nullable
        private String collectionTime;
        @Nullable
        private Long collectionTimeInMillis;

        public Builder() {
        }

        private Builder(GarbageCollectorTotal instance) {
            this.collectionCount = instance.collectionCount;
            this.collectionTime = instance.collectionTime;
            this.collectionTimeInMillis = instance.collectionTimeInMillis;
        }

        public final Builder collectionCount(@Nullable Long value) {
            this.collectionCount = value;
            return this;
        }

        public final Builder collectionTime(@Nullable String value) {
            this.collectionTime = value;
            return this;
        }

        public final Builder collectionTimeInMillis(@Nullable Long value) {
            this.collectionTimeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GarbageCollectorTotal build() {
            this._checkSingleUse();
            return new GarbageCollectorTotal(this);
        }
    }
}

