/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.MemoryStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExtendedMemoryStats
extends MemoryStats {
    @Nullable
    private final Integer freePercent;
    @Nullable
    private final Integer usedPercent;
    public static final JsonpDeserializer<ExtendedMemoryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExtendedMemoryStats::setupExtendedMemoryStatsDeserializer);

    private ExtendedMemoryStats(Builder builder) {
        super(builder);
        this.freePercent = builder.freePercent;
        this.usedPercent = builder.usedPercent;
    }

    public static ExtendedMemoryStats of(Function<Builder, ObjectBuilder<ExtendedMemoryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer freePercent() {
        return this.freePercent;
    }

    @Nullable
    public final Integer usedPercent() {
        return this.usedPercent;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.freePercent != null) {
            generator.writeKey("free_percent");
            generator.write(this.freePercent.intValue());
        }
        if (this.usedPercent != null) {
            generator.writeKey("used_percent");
            generator.write(this.usedPercent.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupExtendedMemoryStatsDeserializer(ObjectDeserializer<Builder> op) {
        MemoryStats.setupMemoryStatsDeserializer(op);
        op.add(Builder::freePercent, JsonpDeserializer.integerDeserializer(), "free_percent");
        op.add(Builder::usedPercent, JsonpDeserializer.integerDeserializer(), "used_percent");
    }

    public static class Builder
    extends MemoryStats.AbstractBuilder<Builder>
    implements ObjectBuilder<ExtendedMemoryStats> {
        @Nullable
        private Integer freePercent;
        @Nullable
        private Integer usedPercent;

        public Builder() {
        }

        private Builder(ExtendedMemoryStats instance) {
            this.freePercent = instance.freePercent;
            this.usedPercent = instance.usedPercent;
        }

        public final Builder freePercent(@Nullable Integer value) {
            this.freePercent = value;
            return this;
        }

        public final Builder usedPercent(@Nullable Integer value) {
            this.usedPercent = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExtendedMemoryStats build() {
            this._checkSingleUse();
            return new ExtendedMemoryStats(this);
        }
    }
}

