/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CgroupMemory
implements JsonpSerializable {
    @Nullable
    private final String controlGroup;
    @Nullable
    private final String limitInBytes;
    @Nullable
    private final String usageInBytes;
    public static final JsonpDeserializer<CgroupMemory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CgroupMemory::setupCgroupMemoryDeserializer);

    private CgroupMemory(Builder builder) {
        this.controlGroup = builder.controlGroup;
        this.limitInBytes = builder.limitInBytes;
        this.usageInBytes = builder.usageInBytes;
    }

    public static CgroupMemory of(Function<Builder, ObjectBuilder<CgroupMemory>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String controlGroup() {
        return this.controlGroup;
    }

    @Nullable
    public final String limitInBytes() {
        return this.limitInBytes;
    }

    @Nullable
    public final String usageInBytes() {
        return this.usageInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.controlGroup != null) {
            generator.writeKey("control_group");
            generator.write(this.controlGroup);
        }
        if (this.limitInBytes != null) {
            generator.writeKey("limit_in_bytes");
            generator.write(this.limitInBytes);
        }
        if (this.usageInBytes != null) {
            generator.writeKey("usage_in_bytes");
            generator.write(this.usageInBytes);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCgroupMemoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::controlGroup, JsonpDeserializer.stringDeserializer(), "control_group");
        op.add(Builder::limitInBytes, JsonpDeserializer.stringDeserializer(), "limit_in_bytes");
        op.add(Builder::usageInBytes, JsonpDeserializer.stringDeserializer(), "usage_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CgroupMemory> {
        @Nullable
        private String controlGroup;
        @Nullable
        private String limitInBytes;
        @Nullable
        private String usageInBytes;

        public Builder() {
        }

        private Builder(CgroupMemory instance) {
            this.controlGroup = instance.controlGroup;
            this.limitInBytes = instance.limitInBytes;
            this.usageInBytes = instance.usageInBytes;
        }

        public final Builder controlGroup(@Nullable String value) {
            this.controlGroup = value;
            return this;
        }

        public final Builder limitInBytes(@Nullable String value) {
            this.limitInBytes = value;
            return this;
        }

        public final Builder usageInBytes(@Nullable String value) {
            this.usageInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CgroupMemory build() {
            this._checkSingleUse();
            return new CgroupMemory(this);
        }
    }
}

