/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.Ensemble;
import co.elastic.clients.elasticsearch.ml.put_trained_model.TrainedModelTree;
import co.elastic.clients.elasticsearch.ml.put_trained_model.TrainedModelTreeNode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModel
implements JsonpSerializable {
    @Nullable
    private final TrainedModelTree tree;
    @Nullable
    private final TrainedModelTreeNode treeNode;
    @Nullable
    private final Ensemble ensemble;
    public static final JsonpDeserializer<TrainedModel> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModel::setupTrainedModelDeserializer);

    private TrainedModel(Builder builder) {
        this.tree = builder.tree;
        this.treeNode = builder.treeNode;
        this.ensemble = builder.ensemble;
    }

    public static TrainedModel of(Function<Builder, ObjectBuilder<TrainedModel>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TrainedModelTree tree() {
        return this.tree;
    }

    @Nullable
    public final TrainedModelTreeNode treeNode() {
        return this.treeNode;
    }

    @Nullable
    public final Ensemble ensemble() {
        return this.ensemble;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.tree != null) {
            generator.writeKey("tree");
            this.tree.serialize(generator, mapper);
        }
        if (this.treeNode != null) {
            generator.writeKey("tree_node");
            this.treeNode.serialize(generator, mapper);
        }
        if (this.ensemble != null) {
            generator.writeKey("ensemble");
            this.ensemble.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTrainedModelDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::tree, TrainedModelTree._DESERIALIZER, "tree");
        op.add(Builder::treeNode, TrainedModelTreeNode._DESERIALIZER, "tree_node");
        op.add(Builder::ensemble, Ensemble._DESERIALIZER, "ensemble");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModel> {
        @Nullable
        private TrainedModelTree tree;
        @Nullable
        private TrainedModelTreeNode treeNode;
        @Nullable
        private Ensemble ensemble;

        public Builder() {
        }

        private Builder(TrainedModel instance) {
            this.tree = instance.tree;
            this.treeNode = instance.treeNode;
            this.ensemble = instance.ensemble;
        }

        public final Builder tree(@Nullable TrainedModelTree value) {
            this.tree = value;
            return this;
        }

        public final Builder tree(Function<TrainedModelTree.Builder, ObjectBuilder<TrainedModelTree>> fn) {
            return this.tree(fn.apply(new TrainedModelTree.Builder()).build());
        }

        public final Builder treeNode(@Nullable TrainedModelTreeNode value) {
            this.treeNode = value;
            return this;
        }

        public final Builder treeNode(Function<TrainedModelTreeNode.Builder, ObjectBuilder<TrainedModelTreeNode>> fn) {
            return this.treeNode(fn.apply(new TrainedModelTreeNode.Builder()).build());
        }

        public final Builder ensemble(@Nullable Ensemble value) {
            this.ensemble = value;
            return this;
        }

        public final Builder ensemble(Function<Ensemble.Builder, ObjectBuilder<Ensemble>> fn) {
            return this.ensemble(fn.apply(new Ensemble.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModel build() {
            this._checkSingleUse();
            return new TrainedModel(this);
        }
    }
}

