/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Limits
implements JsonpSerializable {
    @Nullable
    private final Integer maxSingleMlNodeProcessors;
    @Nullable
    private final Integer totalMlProcessors;
    @Nullable
    private final String maxModelMemoryLimit;
    @Nullable
    private final String effectiveMaxModelMemoryLimit;
    private final String totalMlMemory;
    public static final JsonpDeserializer<Limits> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Limits::setupLimitsDeserializer);

    private Limits(Builder builder) {
        this.maxSingleMlNodeProcessors = builder.maxSingleMlNodeProcessors;
        this.totalMlProcessors = builder.totalMlProcessors;
        this.maxModelMemoryLimit = builder.maxModelMemoryLimit;
        this.effectiveMaxModelMemoryLimit = builder.effectiveMaxModelMemoryLimit;
        this.totalMlMemory = ApiTypeHelper.requireNonNull(builder.totalMlMemory, this, "totalMlMemory");
    }

    public static Limits of(Function<Builder, ObjectBuilder<Limits>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer maxSingleMlNodeProcessors() {
        return this.maxSingleMlNodeProcessors;
    }

    @Nullable
    public final Integer totalMlProcessors() {
        return this.totalMlProcessors;
    }

    @Nullable
    public final String maxModelMemoryLimit() {
        return this.maxModelMemoryLimit;
    }

    @Nullable
    public final String effectiveMaxModelMemoryLimit() {
        return this.effectiveMaxModelMemoryLimit;
    }

    public final String totalMlMemory() {
        return this.totalMlMemory;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxSingleMlNodeProcessors != null) {
            generator.writeKey("max_single_ml_node_processors");
            generator.write(this.maxSingleMlNodeProcessors.intValue());
        }
        if (this.totalMlProcessors != null) {
            generator.writeKey("total_ml_processors");
            generator.write(this.totalMlProcessors.intValue());
        }
        if (this.maxModelMemoryLimit != null) {
            generator.writeKey("max_model_memory_limit");
            generator.write(this.maxModelMemoryLimit);
        }
        if (this.effectiveMaxModelMemoryLimit != null) {
            generator.writeKey("effective_max_model_memory_limit");
            generator.write(this.effectiveMaxModelMemoryLimit);
        }
        generator.writeKey("total_ml_memory");
        generator.write(this.totalMlMemory);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupLimitsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxSingleMlNodeProcessors, JsonpDeserializer.integerDeserializer(), "max_single_ml_node_processors");
        op.add(Builder::totalMlProcessors, JsonpDeserializer.integerDeserializer(), "total_ml_processors");
        op.add(Builder::maxModelMemoryLimit, JsonpDeserializer.stringDeserializer(), "max_model_memory_limit");
        op.add(Builder::effectiveMaxModelMemoryLimit, JsonpDeserializer.stringDeserializer(), "effective_max_model_memory_limit");
        op.add(Builder::totalMlMemory, JsonpDeserializer.stringDeserializer(), "total_ml_memory");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Limits> {
        @Nullable
        private Integer maxSingleMlNodeProcessors;
        @Nullable
        private Integer totalMlProcessors;
        @Nullable
        private String maxModelMemoryLimit;
        @Nullable
        private String effectiveMaxModelMemoryLimit;
        private String totalMlMemory;

        public Builder() {
        }

        private Builder(Limits instance) {
            this.maxSingleMlNodeProcessors = instance.maxSingleMlNodeProcessors;
            this.totalMlProcessors = instance.totalMlProcessors;
            this.maxModelMemoryLimit = instance.maxModelMemoryLimit;
            this.effectiveMaxModelMemoryLimit = instance.effectiveMaxModelMemoryLimit;
            this.totalMlMemory = instance.totalMlMemory;
        }

        public final Builder maxSingleMlNodeProcessors(@Nullable Integer value) {
            this.maxSingleMlNodeProcessors = value;
            return this;
        }

        public final Builder totalMlProcessors(@Nullable Integer value) {
            this.totalMlProcessors = value;
            return this;
        }

        public final Builder maxModelMemoryLimit(@Nullable String value) {
            this.maxModelMemoryLimit = value;
            return this;
        }

        public final Builder effectiveMaxModelMemoryLimit(@Nullable String value) {
            this.effectiveMaxModelMemoryLimit = value;
            return this;
        }

        public final Builder totalMlMemory(String value) {
            this.totalMlMemory = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Limits build() {
            this._checkSingleUse();
            return new Limits(this);
        }
    }
}

