/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.ApiKeyAuthorization;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TransformAuthorization
implements JsonpSerializable {
    @Nullable
    private final ApiKeyAuthorization apiKey;
    private final List<String> roles;
    @Nullable
    private final String serviceAccount;
    public static final JsonpDeserializer<TransformAuthorization> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransformAuthorization::setupTransformAuthorizationDeserializer);

    private TransformAuthorization(Builder builder) {
        this.apiKey = builder.apiKey;
        this.roles = ApiTypeHelper.unmodifiable(builder.roles);
        this.serviceAccount = builder.serviceAccount;
    }

    public static TransformAuthorization of(Function<Builder, ObjectBuilder<TransformAuthorization>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ApiKeyAuthorization apiKey() {
        return this.apiKey;
    }

    public final List<String> roles() {
        return this.roles;
    }

    @Nullable
    public final String serviceAccount() {
        return this.serviceAccount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.apiKey != null) {
            generator.writeKey("api_key");
            this.apiKey.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String item0 : this.roles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.serviceAccount != null) {
            generator.writeKey("service_account");
            generator.write(this.serviceAccount);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTransformAuthorizationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, ApiKeyAuthorization._DESERIALIZER, "api_key");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::serviceAccount, JsonpDeserializer.stringDeserializer(), "service_account");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TransformAuthorization> {
        @Nullable
        private ApiKeyAuthorization apiKey;
        @Nullable
        private List<String> roles;
        @Nullable
        private String serviceAccount;

        public Builder() {
        }

        private Builder(TransformAuthorization instance) {
            this.apiKey = instance.apiKey;
            this.roles = instance.roles;
            this.serviceAccount = instance.serviceAccount;
        }

        public final Builder apiKey(@Nullable ApiKeyAuthorization value) {
            this.apiKey = value;
            return this;
        }

        public final Builder apiKey(Function<ApiKeyAuthorization.Builder, ObjectBuilder<ApiKeyAuthorization>> fn) {
            return this.apiKey(fn.apply(new ApiKeyAuthorization.Builder()).build());
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder serviceAccount(@Nullable String value) {
            this.serviceAccount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransformAuthorization build() {
            this._checkSingleUse();
            return new TransformAuthorization(this);
        }
    }
}

