/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TrainingPriority;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelAssignmentTaskParameters
implements JsonpSerializable {
    private final String modelBytes;
    private final String modelId;
    private final String deploymentId;
    @Nullable
    private final String cacheSize;
    private final int numberOfAllocations;
    private final TrainingPriority priority;
    private final String perDeploymentMemoryBytes;
    private final String perAllocationMemoryBytes;
    private final int queueCapacity;
    private final int threadsPerAllocation;
    public static final JsonpDeserializer<TrainedModelAssignmentTaskParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelAssignmentTaskParameters::setupTrainedModelAssignmentTaskParametersDeserializer);

    private TrainedModelAssignmentTaskParameters(Builder builder) {
        this.modelBytes = ApiTypeHelper.requireNonNull(builder.modelBytes, this, "modelBytes");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.deploymentId = ApiTypeHelper.requireNonNull(builder.deploymentId, this, "deploymentId");
        this.cacheSize = builder.cacheSize;
        this.numberOfAllocations = ApiTypeHelper.requireNonNull(builder.numberOfAllocations, (Object)this, "numberOfAllocations", 0);
        this.priority = ApiTypeHelper.requireNonNull(builder.priority, this, "priority");
        this.perDeploymentMemoryBytes = ApiTypeHelper.requireNonNull(builder.perDeploymentMemoryBytes, this, "perDeploymentMemoryBytes");
        this.perAllocationMemoryBytes = ApiTypeHelper.requireNonNull(builder.perAllocationMemoryBytes, this, "perAllocationMemoryBytes");
        this.queueCapacity = ApiTypeHelper.requireNonNull(builder.queueCapacity, (Object)this, "queueCapacity", 0);
        this.threadsPerAllocation = ApiTypeHelper.requireNonNull(builder.threadsPerAllocation, (Object)this, "threadsPerAllocation", 0);
    }

    public static TrainedModelAssignmentTaskParameters of(Function<Builder, ObjectBuilder<TrainedModelAssignmentTaskParameters>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelBytes() {
        return this.modelBytes;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    @Nullable
    public final String cacheSize() {
        return this.cacheSize;
    }

    public final int numberOfAllocations() {
        return this.numberOfAllocations;
    }

    public final TrainingPriority priority() {
        return this.priority;
    }

    public final String perDeploymentMemoryBytes() {
        return this.perDeploymentMemoryBytes;
    }

    public final String perAllocationMemoryBytes() {
        return this.perAllocationMemoryBytes;
    }

    public final int queueCapacity() {
        return this.queueCapacity;
    }

    public final int threadsPerAllocation() {
        return this.threadsPerAllocation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_bytes");
        generator.write(this.modelBytes);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("deployment_id");
        generator.write(this.deploymentId);
        if (this.cacheSize != null) {
            generator.writeKey("cache_size");
            generator.write(this.cacheSize);
        }
        generator.writeKey("number_of_allocations");
        generator.write(this.numberOfAllocations);
        generator.writeKey("priority");
        this.priority.serialize(generator, mapper);
        generator.writeKey("per_deployment_memory_bytes");
        generator.write(this.perDeploymentMemoryBytes);
        generator.writeKey("per_allocation_memory_bytes");
        generator.write(this.perAllocationMemoryBytes);
        generator.writeKey("queue_capacity");
        generator.write(this.queueCapacity);
        generator.writeKey("threads_per_allocation");
        generator.write(this.threadsPerAllocation);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTrainedModelAssignmentTaskParametersDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelBytes, JsonpDeserializer.stringDeserializer(), "model_bytes");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::deploymentId, JsonpDeserializer.stringDeserializer(), "deployment_id");
        op.add(Builder::cacheSize, JsonpDeserializer.stringDeserializer(), "cache_size");
        op.add(Builder::numberOfAllocations, JsonpDeserializer.integerDeserializer(), "number_of_allocations");
        op.add(Builder::priority, TrainingPriority._DESERIALIZER, "priority");
        op.add(Builder::perDeploymentMemoryBytes, JsonpDeserializer.stringDeserializer(), "per_deployment_memory_bytes");
        op.add(Builder::perAllocationMemoryBytes, JsonpDeserializer.stringDeserializer(), "per_allocation_memory_bytes");
        op.add(Builder::queueCapacity, JsonpDeserializer.integerDeserializer(), "queue_capacity");
        op.add(Builder::threadsPerAllocation, JsonpDeserializer.integerDeserializer(), "threads_per_allocation");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelAssignmentTaskParameters> {
        private String modelBytes;
        private String modelId;
        private String deploymentId;
        @Nullable
        private String cacheSize;
        private Integer numberOfAllocations;
        private TrainingPriority priority;
        private String perDeploymentMemoryBytes;
        private String perAllocationMemoryBytes;
        private Integer queueCapacity;
        private Integer threadsPerAllocation;

        public Builder() {
        }

        private Builder(TrainedModelAssignmentTaskParameters instance) {
            this.modelBytes = instance.modelBytes;
            this.modelId = instance.modelId;
            this.deploymentId = instance.deploymentId;
            this.cacheSize = instance.cacheSize;
            this.numberOfAllocations = instance.numberOfAllocations;
            this.priority = instance.priority;
            this.perDeploymentMemoryBytes = instance.perDeploymentMemoryBytes;
            this.perAllocationMemoryBytes = instance.perAllocationMemoryBytes;
            this.queueCapacity = instance.queueCapacity;
            this.threadsPerAllocation = instance.threadsPerAllocation;
        }

        public final Builder modelBytes(String value) {
            this.modelBytes = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder deploymentId(String value) {
            this.deploymentId = value;
            return this;
        }

        public final Builder cacheSize(@Nullable String value) {
            this.cacheSize = value;
            return this;
        }

        public final Builder numberOfAllocations(int value) {
            this.numberOfAllocations = value;
            return this;
        }

        public final Builder priority(TrainingPriority value) {
            this.priority = value;
            return this;
        }

        public final Builder perDeploymentMemoryBytes(String value) {
            this.perDeploymentMemoryBytes = value;
            return this;
        }

        public final Builder perAllocationMemoryBytes(String value) {
            this.perAllocationMemoryBytes = value;
            return this;
        }

        public final Builder queueCapacity(int value) {
            this.queueCapacity = value;
            return this;
        }

        public final Builder threadsPerAllocation(int value) {
            this.threadsPerAllocation = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelAssignmentTaskParameters build() {
            this._checkSingleUse();
            return new TrainedModelAssignmentTaskParameters(this);
        }
    }
}

