/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TrainedModelPrefixStrings;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ModelPackageConfig
implements JsonpSerializable {
    @Nullable
    private final Long createTime;
    @Nullable
    private final String description;
    private final Map<String, JsonData> inferenceConfig;
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String minimumVersion;
    @Nullable
    private final String modelRepository;
    @Nullable
    private final String modelType;
    private final String packagedModelId;
    @Nullable
    private final String platformArchitecture;
    @Nullable
    private final TrainedModelPrefixStrings prefixStrings;
    @Nullable
    private final String size;
    @Nullable
    private final String sha256;
    private final List<String> tags;
    @Nullable
    private final String vocabularyFile;
    public static final JsonpDeserializer<ModelPackageConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ModelPackageConfig::setupModelPackageConfigDeserializer);

    private ModelPackageConfig(Builder builder) {
        this.createTime = builder.createTime;
        this.description = builder.description;
        this.inferenceConfig = ApiTypeHelper.unmodifiable(builder.inferenceConfig);
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.minimumVersion = builder.minimumVersion;
        this.modelRepository = builder.modelRepository;
        this.modelType = builder.modelType;
        this.packagedModelId = ApiTypeHelper.requireNonNull(builder.packagedModelId, this, "packagedModelId");
        this.platformArchitecture = builder.platformArchitecture;
        this.prefixStrings = builder.prefixStrings;
        this.size = builder.size;
        this.sha256 = builder.sha256;
        this.tags = ApiTypeHelper.unmodifiable(builder.tags);
        this.vocabularyFile = builder.vocabularyFile;
    }

    public static ModelPackageConfig of(Function<Builder, ObjectBuilder<ModelPackageConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long createTime() {
        return this.createTime;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final Map<String, JsonData> inferenceConfig() {
        return this.inferenceConfig;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final String minimumVersion() {
        return this.minimumVersion;
    }

    @Nullable
    public final String modelRepository() {
        return this.modelRepository;
    }

    @Nullable
    public final String modelType() {
        return this.modelType;
    }

    public final String packagedModelId() {
        return this.packagedModelId;
    }

    @Nullable
    public final String platformArchitecture() {
        return this.platformArchitecture;
    }

    @Nullable
    public final TrainedModelPrefixStrings prefixStrings() {
        return this.prefixStrings;
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    @Nullable
    public final String sha256() {
        return this.sha256;
    }

    public final List<String> tags() {
        return this.tags;
    }

    @Nullable
    public final String vocabularyFile() {
        return this.vocabularyFile;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.createTime != null) {
            generator.writeKey("create_time");
            generator.write(this.createTime.longValue());
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.inferenceConfig)) {
            generator.writeKey("inference_config");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.inferenceConfig.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.minimumVersion != null) {
            generator.writeKey("minimum_version");
            generator.write(this.minimumVersion);
        }
        if (this.modelRepository != null) {
            generator.writeKey("model_repository");
            generator.write(this.modelRepository);
        }
        if (this.modelType != null) {
            generator.writeKey("model_type");
            generator.write(this.modelType);
        }
        generator.writeKey("packaged_model_id");
        generator.write(this.packagedModelId);
        if (this.platformArchitecture != null) {
            generator.writeKey("platform_architecture");
            generator.write(this.platformArchitecture);
        }
        if (this.prefixStrings != null) {
            generator.writeKey("prefix_strings");
            this.prefixStrings.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (this.sha256 != null) {
            generator.writeKey("sha256");
            generator.write(this.sha256);
        }
        if (ApiTypeHelper.isDefined(this.tags)) {
            generator.writeKey("tags");
            generator.writeStartArray();
            for (String string : this.tags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.vocabularyFile != null) {
            generator.writeKey("vocabulary_file");
            generator.write(this.vocabularyFile);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupModelPackageConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::createTime, JsonpDeserializer.longDeserializer(), "create_time");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::inferenceConfig, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "inference_config");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::minimumVersion, JsonpDeserializer.stringDeserializer(), "minimum_version");
        op.add(Builder::modelRepository, JsonpDeserializer.stringDeserializer(), "model_repository");
        op.add(Builder::modelType, JsonpDeserializer.stringDeserializer(), "model_type");
        op.add(Builder::packagedModelId, JsonpDeserializer.stringDeserializer(), "packaged_model_id");
        op.add(Builder::platformArchitecture, JsonpDeserializer.stringDeserializer(), "platform_architecture");
        op.add(Builder::prefixStrings, TrainedModelPrefixStrings._DESERIALIZER, "prefix_strings");
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::sha256, JsonpDeserializer.stringDeserializer(), "sha256");
        op.add(Builder::tags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tags");
        op.add(Builder::vocabularyFile, JsonpDeserializer.stringDeserializer(), "vocabulary_file");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ModelPackageConfig> {
        @Nullable
        private Long createTime;
        @Nullable
        private String description;
        @Nullable
        private Map<String, JsonData> inferenceConfig;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String minimumVersion;
        @Nullable
        private String modelRepository;
        @Nullable
        private String modelType;
        private String packagedModelId;
        @Nullable
        private String platformArchitecture;
        @Nullable
        private TrainedModelPrefixStrings prefixStrings;
        @Nullable
        private String size;
        @Nullable
        private String sha256;
        @Nullable
        private List<String> tags;
        @Nullable
        private String vocabularyFile;

        public Builder() {
        }

        private Builder(ModelPackageConfig instance) {
            this.createTime = instance.createTime;
            this.description = instance.description;
            this.inferenceConfig = instance.inferenceConfig;
            this.metadata = instance.metadata;
            this.minimumVersion = instance.minimumVersion;
            this.modelRepository = instance.modelRepository;
            this.modelType = instance.modelType;
            this.packagedModelId = instance.packagedModelId;
            this.platformArchitecture = instance.platformArchitecture;
            this.prefixStrings = instance.prefixStrings;
            this.size = instance.size;
            this.sha256 = instance.sha256;
            this.tags = instance.tags;
            this.vocabularyFile = instance.vocabularyFile;
        }

        public final Builder createTime(@Nullable Long value) {
            this.createTime = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder inferenceConfig(Map<String, JsonData> map) {
            this.inferenceConfig = Builder._mapPutAll(this.inferenceConfig, map);
            return this;
        }

        public final Builder inferenceConfig(String key, JsonData value) {
            this.inferenceConfig = Builder._mapPut(this.inferenceConfig, key, value);
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder minimumVersion(@Nullable String value) {
            this.minimumVersion = value;
            return this;
        }

        public final Builder modelRepository(@Nullable String value) {
            this.modelRepository = value;
            return this;
        }

        public final Builder modelType(@Nullable String value) {
            this.modelType = value;
            return this;
        }

        public final Builder packagedModelId(String value) {
            this.packagedModelId = value;
            return this;
        }

        public final Builder platformArchitecture(@Nullable String value) {
            this.platformArchitecture = value;
            return this;
        }

        public final Builder prefixStrings(@Nullable TrainedModelPrefixStrings value) {
            this.prefixStrings = value;
            return this;
        }

        public final Builder prefixStrings(Function<TrainedModelPrefixStrings.Builder, ObjectBuilder<TrainedModelPrefixStrings>> fn) {
            return this.prefixStrings(fn.apply(new TrainedModelPrefixStrings.Builder()).build());
        }

        public final Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public final Builder sha256(@Nullable String value) {
            this.sha256 = value;
            return this;
        }

        public final Builder tags(List<String> list) {
            this.tags = Builder._listAddAll(this.tags, list);
            return this;
        }

        public final Builder tags(String value, String ... values) {
            this.tags = Builder._listAdd(this.tags, value, values);
            return this;
        }

        public final Builder vocabularyFile(@Nullable String value) {
            this.vocabularyFile = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ModelPackageConfig build() {
            this._checkSingleUse();
            return new ModelPackageConfig(this);
        }
    }
}

